/*
 * Decompiled with CFR 0.152.
 */
package com.ddwhm.jesen.imblocker.immanager.windows;

import com.ddwhm.jesen.imblocker.ImBlocker;
import com.ddwhm.jesen.imblocker.immanager.ImManager;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;

public class WindowsImManager
implements ImManager {
    private boolean status = true;
    private static final User32 u;

    private static native WinNT.HANDLE ImmGetContext(WinDef.HWND var0);

    private static native WinNT.HANDLE ImmAssociateContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native boolean ImmReleaseContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native WinNT.HANDLE ImmCreateContext();

    private static native boolean ImmDestroyContext(WinNT.HANDLE var0);

    @Override
    public void makeOn() {
        ImBlocker.LOGGER.debug("status:{} makeOn", (Object)this.status);
        if (this.status) {
            return;
        }
        this.status = true;
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = WindowsImManager.ImmGetContext(hwnd);
        if (himc == null) {
            himc = WindowsImManager.ImmCreateContext();
            WindowsImManager.ImmAssociateContext(hwnd, himc);
        }
        WindowsImManager.ImmReleaseContext(hwnd, himc);
    }

    @Override
    public void makeOff() {
        ImBlocker.LOGGER.debug("status:{} makeOff", (Object)this.status);
        if (!this.status) {
            return;
        }
        this.status = false;
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = WindowsImManager.ImmAssociateContext(hwnd, null);
        if (himc != null) {
            WindowsImManager.ImmDestroyContext(himc);
        }
        WindowsImManager.ImmReleaseContext(hwnd, himc);
    }

    @Override
    public boolean getStatus() {
        return this.status;
    }

    static {
        Native.register((String)"imm32");
        u = User32.INSTANCE;
    }
}

