/*
 * Decompiled with CFR 0.152.
 */
package com.ddwhm.jesen.imblocker.util;

import com.ddwhm.jesen.imblocker.ImBlocker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class WidgetManager {
    private static final ReentrantLock lock = new ReentrantLock(true);
    private static final Map<Object, Long> widgetLifeTime = new HashMap<Object, Long>();
    private static final Map<Object, Boolean> widgetStatus = new HashMap<Object, Boolean>();

    public static void updateWidgetStatus(Object widget, boolean status) {
        lock.lock();
        widgetLifeTime.put(widget, 0L);
        widgetStatus.put(widget, status);
        WidgetManager.updateImManager();
        lock.unlock();
    }

    public static void updateLifeTime(Object widget) {
        lock.lock();
        widgetLifeTime.put(widget, 0L);
        WidgetManager.updateImManager();
        lock.unlock();
    }

    public static void tick() {
        lock.lock();
        Iterator<Map.Entry<Object, Long>> it = widgetLifeTime.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Long> entry = it.next();
            if (entry.getValue() <= 20L) continue;
            widgetStatus.remove(entry.getKey());
            it.remove();
        }
        widgetLifeTime.replaceAll((k, v) -> v + 1L);
        lock.unlock();
    }

    private static void updateImManager() {
        boolean on = false;
        for (boolean v : widgetStatus.values()) {
            on |= v;
        }
        if (on) {
            ImBlocker.imManager.makeOn();
        } else {
            ImBlocker.imManager.makeOff();
        }
    }

    public static void clear() {
        lock.lock();
        widgetLifeTime.clear();
        widgetStatus.clear();
        lock.unlock();
        ImBlocker.imManager.makeOff();
    }
}

