/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HiddenEffectMode {
    OBFUSCATED{

        @Override
        public String getText(boolean isLong, boolean motion) {
            return (motion ? "f" : "?").repeat(isLong ? 8 : 2);
        }

        @Override
        public class_5250 stylize(class_5250 text, boolean motion) {
            return motion ? text.method_27692(class_124.field_1051) : text;
        }
    }
    ,
    ENCHANTMENT{

        @Override
        public String getText(boolean isLong, boolean motion) {
            return isLong ? "lostquasar" : "na";
        }

        @Override
        public class_5250 stylize(class_5250 text, boolean motion) {
            text = text.method_27694(style -> style.method_27704(ALT_FONT_ID));
            return motion ? text.method_27692(class_124.field_1051) : text;
        }
    };

    private static final class_2960 ALT_FONT_ID;
    public static final PrimitiveCodec<HiddenEffectMode> CODEC;

    public abstract String getText(boolean var1, boolean var2);

    public abstract class_5250 stylize(class_5250 var1, boolean var2);

    public HiddenEffectMode next() {
        HiddenEffectMode[] v = HiddenEffectMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<HiddenEffectMode> byId(@NotNull String id) {
        return Arrays.stream(HiddenEffectMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    static {
        ALT_FONT_ID = new class_2960("minecraft", "alt");
        CODEC = new PrimitiveCodec<HiddenEffectMode>(){

            public <T> DataResult<HiddenEffectMode> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(id -> HiddenEffectMode.byId(id).orElse(ENCHANTMENT));
            }

            public <T> T write(DynamicOps<T> ops, HiddenEffectMode value) {
                return (T)ops.createString(value.getName());
            }

            public String toString() {
                return "HiddenEffectMode";
            }
        };
    }

    public static class HiddenEffectType
    implements ArgumentType<HiddenEffectMode> {
        private static final SimpleCommandExceptionType UNKNOWN_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"inspecio.command.error.unknown_hidden_effect_mode"));
        private static final List<HiddenEffectMode> VALUES = List.of(HiddenEffectMode.values());

        private HiddenEffectType() {
        }

        public static HiddenEffectType hiddenEffectMode() {
            return new HiddenEffectType();
        }

        public static HiddenEffectMode getHiddenEffectMode(CommandContext<?> context, String name) {
            return (HiddenEffectMode)((Object)context.getArgument(name, HiddenEffectMode.class));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            VALUES.stream().map(HiddenEffectMode::getName).filter(s -> s.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return VALUES.stream().map(HiddenEffectMode::getName).collect(Collectors.toList());
        }

        public HiddenEffectMode parse(StringReader reader) throws CommandSyntaxException {
            String value = reader.readString();
            return VALUES.stream().filter(s -> s.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> UNKNOWN_VALUE.createWithContext((ImmutableStringReader)reader));
        }
    }
}

