/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.api.InspecioEntrypoint;
import io.github.queerbric.inspecio.api.InventoryProvider;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.loader.api.QuiltLoader;
import org.quiltmc.qsl.base.api.entrypoint.client.ClientModInitializer;
import org.quiltmc.qsl.tag.api.QuiltTagKey;
import org.quiltmc.qsl.tag.api.TagType;

public class Inspecio
implements ClientModInitializer {
    public static final String NAMESPACE = "inspecio";
    private static final Logger LOGGER = LogManager.getLogger((String)"inspecio");
    public static final class_6862<class_1792> HIDDEN_EFFECTS_TAG = QuiltTagKey.of((class_5321)class_7924.field_41197, (class_2960)new class_2960("inspecio", "hidden_effects"), (TagType)TagType.CLIENT_FALLBACK);
    public static final class_5819 COMMON_RANDOM = new class_5820(System.currentTimeMillis());
    public static final class_2960 GUI_ICONS_TEXTURE = new class_2960("textures/gui/icons.png");
    private static InspecioConfig config = InspecioConfig.defaultConfig();
    private static ModContainer mod;

    public void onInitializeClient(ModContainer mod) {
        Inspecio.mod = mod;
        Inspecio.reloadConfig();
        InventoryProvider.register((stack, config) -> {
            class_1792 patt3155$temp;
            if (config != null && config.isEnabled() && (patt3155$temp = stack.method_7909()) instanceof class_1747) {
                class_2487 nbt;
                class_1747 blockItem = (class_1747)patt3155$temp;
                class_1767 color = null;
                class_2248 patt3245$temp = blockItem.method_7711();
                if (patt3245$temp instanceof class_2480) {
                    class_2480 shulkerBoxBlock = (class_2480)patt3245$temp;
                    if (((InspecioConfig.ShulkerBoxConfig)config).hasColor()) {
                        color = shulkerBoxBlock.method_10528();
                    }
                }
                if ((nbt = class_1747.method_38072((class_1799)stack)) == null) {
                    return null;
                }
                class_2371<class_1799> inventory = Inspecio.readInventory(nbt, Inspecio.getInvSizeFor(stack));
                if (inventory == null) {
                    return null;
                }
                return new InventoryProvider.Context((List<class_1799>)inventory, color);
            }
            return null;
        }, new class_1792[0]);
        List entrypoints = QuiltLoader.getEntrypoints((String)NAMESPACE, InspecioEntrypoint.class);
        for (InspecioEntrypoint entrypoint : entrypoints) {
            entrypoint.onInspecioInitialized();
        }
    }

    public static void log(String info) {
        LOGGER.info("[Inspecio] " + info);
    }

    public static void warn(String info) {
        LOGGER.warn("[Inspecio] " + info);
    }

    public static void warn(String info, Object ... params) {
        LOGGER.warn("[Inspecio] " + info, params);
    }

    public static void warn(String info, Throwable throwable) {
        LOGGER.warn("[Inspecio] " + info, throwable);
    }

    public static InspecioConfig getConfig() {
        return config;
    }

    static void reloadConfig() {
        config = InspecioConfig.load();
    }

    static Consumer<String> onConfigError(String path) {
        return error -> {
            InspecioConfig.shouldSaveConfigAfterLoad = true;
            Inspecio.warn("Configuration error at \"" + path + "\", error: " + error);
        };
    }

    static String getVersion() {
        String version = mod.metadata().version().raw();
        if (version.equals("${version}")) {
            return "dev";
        }
        return version;
    }

    private static int getInvSizeFor(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            if (block instanceof class_2315) {
                return 9;
            }
            if (block instanceof class_2377) {
                return 5;
            }
            return 27;
        }
        return 0;
    }

    public static void appendBlockItemTooltip(class_1799 stack, class_2248 block, List<class_2561> tooltip) {
        class_2487 blockEntityNbt;
        InspecioConfig.StorageContainerConfig config = Inspecio.getConfig().getContainersConfig().forBlock(block);
        if (config != null && config.hasLootTable() && (blockEntityNbt = class_1747.method_38072((class_1799)stack)) != null && blockEntityNbt.method_10545("LootTable")) {
            tooltip.add((class_2561)class_2561.method_43469((String)"inspecio.tooltip.loot_table", (Object[])new Object[]{class_2561.method_43470((String)blockEntityNbt.method_10558("LootTable")).method_27692(class_124.field_1065)}).method_27692(class_124.field_1080));
        }
    }

    public static void removeVanillaTooltips(List<class_2561> tooltips, int fromIndex) {
        if (fromIndex >= tooltips.size()) {
            return;
        }
        int keepIndex = tooltips.indexOf(class_2561.method_43473());
        if (keepIndex != -1) {
            int tooltipsToKeep = tooltips.size() - ++keepIndex;
            for (int i = 0; i < tooltipsToKeep; ++i) {
                tooltips.set(fromIndex + i, tooltips.get(keepIndex + i));
            }
            fromIndex += tooltipsToKeep;
        }
        tooltips.subList(fromIndex, tooltips.size()).clear();
    }

    @Nullable
    public static class_1293 getRawEffectFromTag(class_2487 tag, String tagKey) {
        class_1291 effect;
        if (tag == null) {
            return null;
        }
        if (tag.method_10573(tagKey, 3) && (effect = class_1291.method_5569((int)tag.method_10550(tagKey))) != null) {
            return new class_1293(effect, 200, 0);
        }
        return null;
    }

    @Nullable
    public static class_2371<class_1799> readInventory(class_2487 nbt, int size) {
        class_2371 inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, (class_2371)inventory);
        boolean empty = true;
        for (class_1799 item : inventory) {
            if (item.method_7960()) continue;
            empty = false;
            break;
        }
        if (empty) {
            return null;
        }
        return inventory;
    }
}

