/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.queerbric.inspecio.HiddenEffectMode;
import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.JukeboxTooltipMode;
import io.github.queerbric.inspecio.SaturationTooltipMode;
import io.github.queerbric.inspecio.SignTooltipMode;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.quiltmc.qsl.command.api.client.ClientCommandManager;
import org.quiltmc.qsl.command.api.client.ClientCommandRegistrationCallback;
import org.quiltmc.qsl.command.api.client.QuiltClientCommandSource;

public final class InspecioCommand
implements ClientCommandRegistrationCallback {
    public void registerCommands(CommandDispatcher<QuiltClientCommandSource> dispatcher, class_7157 buildContext, class_2170.class_5364 environment) {
        LiteralArgumentBuilder literalSubCommand = ClientCommandManager.literal((String)"config");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalSubCommand.then(ClientCommandManager.literal((String)"reload").executes(ctx -> {
            ((QuiltClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"inspecio.config.reloading").method_27692(class_124.field_1060));
            Inspecio.reloadConfig();
            return 0;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"armor").executes(InspecioCommand.onGetter("armor", InspecioCommand.getter(InspecioConfig::hasArmor)))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("armor", InspecioCommand.setter(InspecioConfig::setArmor)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"banner_pattern").executes(InspecioCommand.onGetter("banner_pattern", InspecioCommand.getter(InspecioConfig::hasBannerPattern)))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("armor", InspecioCommand.setter(InspecioConfig::setBannerPattern)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"containers").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"campfire").executes(InspecioCommand.onGetter("containers/campfire", InspecioCommand.getter(cfg -> cfg.getContainersConfig().isCampfireEnabled())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("containers/campfire", InspecioCommand.setter((cfg, val) -> cfg.getContainersConfig().setCampfire((boolean)val))))))).then(InspecioCommand.initContainer("storage", cfg -> cfg.getContainersConfig().getStorageConfig()))).then(InspecioCommand.initContainer("shulker_box", cfg -> cfg.getContainersConfig().getShulkerBoxConfig()).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"color").executes(InspecioCommand.onGetter("containers/shulker_box/color", InspecioCommand.getter(cfg -> cfg.getContainersConfig().getShulkerBoxConfig().hasColor())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("containers/shulker_box/color", InspecioCommand.setter((cfg, val) -> cfg.getContainersConfig().getShulkerBoxConfig().setColor((boolean)val)))))))).then(InspecioCommand.initContainer("chiseled_bookshelf", cfg -> cfg.getContainersConfig().getChiseledBookshelfConfig()).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"block_render").executes(InspecioCommand.onGetter("containers/chiseled_bookshelf/block_render", InspecioCommand.getter(cfg -> cfg.getContainersConfig().getChiseledBookshelfConfig().hasBlockRender())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("containers/chiseled_bookshelf/block_render", InspecioCommand.setter((cfg, val) -> cfg.getContainersConfig().getChiseledBookshelfConfig().setBlockRender((boolean)val))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"effects").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"potions").executes(InspecioCommand.onGetter("effects/potions", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasPotions())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/potions", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setPotions((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tipped_arrows").executes(InspecioCommand.onGetter("effects/tipped_arrows", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasTippedArrows())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/tipped_arrows", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setTippedArrows((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"spectral_arrow").executes(InspecioCommand.onGetter("effects/spectral_arrow", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasSpectralArrow())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/spectral_arrow", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setSpectralArrow((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"food").executes(InspecioCommand.onGetter("effects/food", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasFood())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/food", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setFood((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hidden_motion").executes(InspecioCommand.onGetter("effects/hidden_motion", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasHiddenMotion())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/hidden_motion", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setHiddenMotion((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hidden_effect_mode").executes(InspecioCommand.onGetter("hidden_effect_mode", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().getHiddenEffectMode())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)HiddenEffectMode.HiddenEffectType.hiddenEffectMode()).executes(InspecioCommand::onSetHiddenEffect)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"beacon").executes(InspecioCommand.onGetter("effects/beacon", InspecioCommand.getter(cfg -> cfg.getEffectsConfig().hasHiddenMotion())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("effects/beacon", InspecioCommand.setter((cfg, val) -> cfg.getEffectsConfig().setBeacon((boolean)val)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"entities").then(InspecioCommand.initEntity("armor_stand", cfg -> cfg.getEntitiesConfig().getArmorStandConfig()))).then(InspecioCommand.initEntity("bee", cfg -> cfg.getEntitiesConfig().getBeeConfig()).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"show_honey_level").executes(InspecioCommand.onGetter("entities/bee/show_honey_level", () -> Inspecio.getConfig().getEntitiesConfig().getBeeConfig().shouldShowHoney()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("entities/bee/show_honey_level", val -> Inspecio.getConfig().getEntitiesConfig().getBeeConfig().setShowHoneyLevel((boolean)val))))))).then(InspecioCommand.initEntity("fish_bucket", cfg -> cfg.getEntitiesConfig().getFishBucketConfig()))).then(InspecioCommand.initEntity("spawn_egg", cfg -> cfg.getEntitiesConfig().getSpawnEggConfig()))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pufferfish_puff_state").executes(InspecioCommand.onGetter("entities/pufferfish_puff_state", InspecioCommand.getter(cfg -> cfg.getEntitiesConfig().getPufferFishPuffState())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(InspecioCommand.onIntegerSetter("entities/pufferfish_puff_state", InspecioCommand.setter((cfg, val) -> cfg.getEntitiesConfig().setPufferFishPuffState((int)val)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"filled_map").executes(InspecioCommand.onGetter("filled_map", InspecioCommand.getter(cfg -> cfg.getFilledMapConfig().isEnabled())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("filled_map", InspecioCommand.setter((cfg, val) -> cfg.getFilledMapConfig().setEnabled((boolean)val)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"show_player_icon").executes(InspecioCommand.onGetter("filled_map/show_player_icon", InspecioCommand.getter(cfg -> cfg.getFilledMapConfig().shouldShowPlayerIcon())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("filled_map/show_player_icon", InspecioCommand.setter((cfg, val) -> cfg.getFilledMapConfig().setShowPlayerIcon((boolean)val)))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"food").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hunger").executes(InspecioCommand.onGetter("food/hunger", InspecioCommand.getter(cfg -> cfg.getFoodConfig().hasHunger())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("food/hunger", InspecioCommand.setter((cfg, val) -> cfg.getFoodConfig().setHunger((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"saturation").executes(InspecioCommand.onGetter("food/saturation", InspecioCommand.getter(cfg -> cfg.getFoodConfig().getSaturationMode())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)SaturationTooltipMode.SaturationArgumentType.saturationTooltipMode()).executes(InspecioCommand::onSetSaturation))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"jukebox").executes(InspecioCommand.onGetter("jukebox", InspecioCommand.getter(InspecioConfig::getJukeboxTooltipMode)))).then(ClientCommandManager.argument((String)"value", (ArgumentType)JukeboxTooltipMode.JukeboxArgumentType.jukeboxTooltipMode()).executes(InspecioCommand::onSetJukebox)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sign").executes(InspecioCommand.onGetter("sign", InspecioCommand.getter(InspecioConfig::getSignTooltipMode)))).then(ClientCommandManager.argument((String)"value", (ArgumentType)SignTooltipMode.SignArgumentType.signTooltipMode()).executes(InspecioCommand::onSetSign)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"advanced_tooltips").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"repair_cost").executes(InspecioCommand.onGetter("advanced_tooltips/repair_cost", InspecioCommand.getter(cfg -> cfg.getAdvancedTooltipsConfig().hasRepairCost())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("advanced_tooltips/repair_cost", InspecioCommand.setter((cfg, val) -> cfg.getAdvancedTooltipsConfig().setRepairCost((boolean)val))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lodestone_coords").executes(InspecioCommand.onGetter("advanced_tooltips/lodestone_coords", InspecioCommand.getter(cfg -> cfg.getAdvancedTooltipsConfig().hasLodestoneCoords())))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter("advanced_tooltips/lodestone_coords", InspecioCommand.setter((cfg, val) -> cfg.getAdvancedTooltipsConfig().setLodestoneCoords((boolean)val)))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"inspecio").executes(InspecioCommand.onInspecioCommand((LiteralCommandNode<QuiltClientCommandSource>)literalSubCommand.build()))).then((ArgumentBuilder)literalSubCommand));
    }

    private static LiteralArgumentBuilder<QuiltClientCommandSource> initContainer(String name, Function<InspecioConfig, InspecioConfig.StorageContainerConfig> containerGetter) {
        String prefix = "containers/" + name;
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(InspecioCommand.onGetter(prefix, () -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).isEnabled()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix, val -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).setEnabled((boolean)val))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"compact").executes(InspecioCommand.onGetter(prefix + "/compact", () -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).isCompact()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix + "/compact", val -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).setCompact((boolean)val)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"loot_table").executes(InspecioCommand.onGetter(prefix + "/loot_table", () -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).hasLootTable()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix + "/loot_table", val -> ((InspecioConfig.StorageContainerConfig)containerGetter.apply(Inspecio.getConfig())).setLootTable((boolean)val)))));
    }

    private static LiteralArgumentBuilder<QuiltClientCommandSource> initEntity(String name, Function<InspecioConfig, InspecioConfig.EntityConfig> containerGetter) {
        String prefix = "entities/" + name;
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(InspecioCommand.onGetter(prefix, () -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).isEnabled()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix, val -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).setEnabled((boolean)val))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"always_show_name").executes(InspecioCommand.onGetter(prefix + "/always_show_name", () -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).shouldAlwaysShowName()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix + "/always_show_name", val -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).setAlwaysShowName((boolean)val)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"spin").executes(InspecioCommand.onGetter(prefix + "/spin", () -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).shouldSpin()))).then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(InspecioCommand.onBooleanSetter(prefix + "/spin", val -> ((InspecioConfig.EntityConfig)containerGetter.apply(Inspecio.getConfig())).setSpin((boolean)val)))));
    }

    private static class_2561 formatBoolean(boolean bool) {
        return bool ? class_2561.method_43470((String)"true").method_27692(class_124.field_1060) : class_2561.method_43470((String)"false").method_27692(class_124.field_1061);
    }

    private static Command<QuiltClientCommandSource> onInspecioCommand(LiteralCommandNode<QuiltClientCommandSource> config) {
        class_5250 msg = class_2561.method_43470((String)"Inspecio").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)(" v" + Inspecio.getVersion() + "\n")).method_27692(class_124.field_1080));
        InspecioCommand.buildHelpCommand(config, 0, msg);
        return ctx -> {
            ((QuiltClientCommandSource)ctx.getSource()).sendFeedback((class_2561)msg);
            return 0;
        };
    }

    private static void buildHelpCommand(LiteralCommandNode<QuiltClientCommandSource> node, int step, class_5250 text) {
        text.method_10852((class_2561)class_2561.method_43470((String)("\n" + " ".repeat(step * 2) + "- ")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)node.getLiteral()).method_27692(class_124.field_1065)));
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            InspecioCommand.buildHelpCommand((LiteralCommandNode<QuiltClientCommandSource>)((LiteralCommandNode)child), step + 1, text);
        }
    }

    private static int onSetJukebox(CommandContext<QuiltClientCommandSource> context) {
        JukeboxTooltipMode value = JukeboxTooltipMode.JukeboxArgumentType.getJukeboxTooltipMode(context, "value");
        InspecioConfig config = Inspecio.getConfig();
        config.setJukeboxTooltipMode(value);
        config.save();
        ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix("jukebox").method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1068)));
        return 0;
    }

    private static int onSetSaturation(CommandContext<QuiltClientCommandSource> context) {
        SaturationTooltipMode value = SaturationTooltipMode.SaturationArgumentType.getSaturationTooltipMode(context, "value");
        InspecioConfig config = Inspecio.getConfig();
        config.getFoodConfig().setSaturationMode(value);
        config.save();
        ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix("food/saturation").method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1068)));
        return 0;
    }

    private static int onSetSign(CommandContext<QuiltClientCommandSource> context) {
        SignTooltipMode value = SignTooltipMode.SignArgumentType.getSignTooltipMode(context, "value");
        InspecioConfig config = Inspecio.getConfig();
        config.setSignTooltipMode(value);
        config.save();
        ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix("sign").method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1068)));
        return 0;
    }

    private static int onSetHiddenEffect(CommandContext<QuiltClientCommandSource> context) {
        HiddenEffectMode value = HiddenEffectMode.HiddenEffectType.getHiddenEffectMode(context, "value");
        InspecioConfig.EffectsConfig config = Inspecio.getConfig().getEffectsConfig();
        config.setHiddenEffectMode(value);
        Inspecio.getConfig().save();
        ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix("effects/hidden_effect_mode").method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1068)));
        return 0;
    }

    private static class_5250 prefix(String path) {
        return class_2561.method_43470((String)path).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
    }

    private static <T> Supplier<T> getter(Function<InspecioConfig, T> func) {
        return () -> func.apply(Inspecio.getConfig());
    }

    private static <T> Consumer<T> setter(BiConsumer<InspecioConfig, T> func) {
        return val -> func.accept(Inspecio.getConfig(), val);
    }

    private static <T> Command<QuiltClientCommandSource> onGetter(String path, Supplier<T> getter) {
        return context -> {
            class_5250 valueText;
            Object value = getter.get();
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                valueText = InspecioCommand.formatBoolean(boolValue);
            } else {
                valueText = class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1068);
            }
            ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix(path).method_10852((class_2561)valueText));
            return 0;
        };
    }

    private static Command<QuiltClientCommandSource> onBooleanSetter(String path, Consumer<Boolean> setter) {
        return context -> {
            boolean value = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            setter.accept(value);
            Inspecio.getConfig().save();
            ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix(path).method_10852(InspecioCommand.formatBoolean(value)));
            return 0;
        };
    }

    private static Command<QuiltClientCommandSource> onIntegerSetter(String path, Consumer<Integer> setter) {
        return context -> {
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            setter.accept(value);
            Inspecio.getConfig().save();
            ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)InspecioCommand.prefix(path).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(value)).method_27692(class_124.field_1068)));
            return 0;
        };
    }
}

