/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.queerbric.inspecio.HiddenEffectMode;
import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.JukeboxTooltipMode;
import io.github.queerbric.inspecio.SaturationTooltipMode;
import io.github.queerbric.inspecio.SignTooltipMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_3532;
import net.minecraft.class_3708;
import org.jetbrains.annotations.Nullable;

public class InspecioConfig {
    public static final Path CONFIG_PATH = FileSystems.getDefault().getPath("config", "inspecio.json");
    public static final Path CONFIG_BACKUP_PATH = FileSystems.getDefault().getPath("config/backup", "inspecio.json");
    public static final boolean DEFAULT_ARMOR = true;
    public static final boolean DEFAULT_BANNER_PATTERN = true;
    public static final boolean DEFAULT_PAINTING = true;
    public static final JukeboxTooltipMode DEFAULT_JUKEBOX_TOOLTIP_MODE = JukeboxTooltipMode.FANCY;
    public static final SignTooltipMode DEFAULT_SIGN_TOOLTIP_MODE = SignTooltipMode.FANCY;
    public static final Codec<InspecioConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("armor", true, InspecioConfig::hasArmor), InspecioConfig.configEntry("banner_pattern", true, InspecioConfig::hasBannerPattern), InspecioConfig.configEntry("painting", true, InspecioConfig::hasPainting), InspecioConfig.configEntry(ContainersConfig.CODEC, "containers", ContainersConfig::defaultConfig, InspecioConfig::getContainersConfig), InspecioConfig.configEntry(EffectsConfig.CODEC, "effects", EffectsConfig::defaultConfig, InspecioConfig::getEffectsConfig), InspecioConfig.configEntry(EntitiesConfig.CODEC, "entities", EntitiesConfig::defaultConfig, InspecioConfig::getEntitiesConfig), InspecioConfig.configEntry(FilledMapConfig.CODEC, "filled_map", FilledMapConfig::defaultConfig, InspecioConfig::getFilledMapConfig), InspecioConfig.configEntry(FoodConfig.CODEC, "food", FoodConfig::defaultConfig, InspecioConfig::getFoodConfig), InspecioConfig.configEntry(JukeboxTooltipMode.CODEC, "jukebox", () -> DEFAULT_JUKEBOX_TOOLTIP_MODE, InspecioConfig::getJukeboxTooltipMode), InspecioConfig.configEntry(SignTooltipMode.CODEC, "sign", () -> DEFAULT_SIGN_TOOLTIP_MODE, InspecioConfig::getSignTooltipMode), InspecioConfig.configEntry(AdvancedTooltipsConfig.CODEC, "advanced_tooltips", AdvancedTooltipsConfig::defaultConfig, InspecioConfig::getAdvancedTooltipsConfig)).apply((Applicative)instance, InspecioConfig::new));
    static boolean shouldSaveConfigAfterLoad = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private boolean armor;
    private boolean bannerPattern;
    private boolean painting;
    private final ContainersConfig containersConfig;
    private final EffectsConfig effectsConfig;
    private final EntitiesConfig entitiesConfig;
    private final FilledMapConfig filledMapConfig;
    private final FoodConfig foodConfig;
    private JukeboxTooltipMode jukeboxTooltipMode;
    private SignTooltipMode signTooltipMode;
    private final AdvancedTooltipsConfig advancedTooltipsConfig;

    private static <C> RecordCodecBuilder<C, Boolean> configEntry(String path, boolean defaultValue, Function<C, Boolean> getter) {
        String[] parts = path.split("/");
        return Codec.BOOL.fieldOf(parts[parts.length - 1]).orElse(Inspecio.onConfigError(path), (Object)defaultValue).forGetter(getter);
    }

    private static <C, E> RecordCodecBuilder<C, E> configEntry(Codec<E> codec, String path, Supplier<E> defaultGetter, Function<C, E> getter) {
        String[] parts = path.split("/");
        return codec.fieldOf(parts[parts.length - 1]).orElseGet(Inspecio.onConfigError(path), defaultGetter).forGetter(getter);
    }

    public InspecioConfig(boolean armor, boolean bannerPattern, boolean painting, ContainersConfig containersConfig, EffectsConfig effectsConfig, EntitiesConfig entitiesConfig, FilledMapConfig filledMapConfig, FoodConfig foodConfig, JukeboxTooltipMode jukeboxTooltipMode, SignTooltipMode signTooltipMode, AdvancedTooltipsConfig advancedTooltipsConfig) {
        this.armor = armor;
        this.bannerPattern = bannerPattern;
        this.painting = painting;
        this.containersConfig = containersConfig;
        this.effectsConfig = effectsConfig;
        this.entitiesConfig = entitiesConfig;
        this.filledMapConfig = filledMapConfig;
        this.foodConfig = foodConfig;
        this.jukeboxTooltipMode = jukeboxTooltipMode;
        this.signTooltipMode = signTooltipMode;
        this.advancedTooltipsConfig = advancedTooltipsConfig;
    }

    public boolean hasArmor() {
        return this.armor;
    }

    public void setArmor(boolean armor) {
        this.armor = armor;
    }

    public boolean hasBannerPattern() {
        return this.bannerPattern;
    }

    public void setBannerPattern(boolean bannerPattern) {
        this.bannerPattern = bannerPattern;
    }

    public boolean hasPainting() {
        return this.painting;
    }

    public void setPainting(boolean painting) {
        this.painting = painting;
    }

    public ContainersConfig getContainersConfig() {
        return this.containersConfig;
    }

    public EffectsConfig getEffectsConfig() {
        return this.effectsConfig;
    }

    public EntitiesConfig getEntitiesConfig() {
        return this.entitiesConfig;
    }

    public FilledMapConfig getFilledMapConfig() {
        return this.filledMapConfig;
    }

    public FoodConfig getFoodConfig() {
        return this.foodConfig;
    }

    public JukeboxTooltipMode getJukeboxTooltipMode() {
        return this.jukeboxTooltipMode;
    }

    public void setJukeboxTooltipMode(JukeboxTooltipMode jukeboxTooltipMode) {
        this.jukeboxTooltipMode = jukeboxTooltipMode;
    }

    public SignTooltipMode getSignTooltipMode() {
        return this.signTooltipMode;
    }

    public void setSignTooltipMode(SignTooltipMode signTooltipMode) {
        this.signTooltipMode = signTooltipMode;
    }

    public AdvancedTooltipsConfig getAdvancedTooltipsConfig() {
        return this.advancedTooltipsConfig;
    }

    public InspecioConfig save() {
        Inspecio.log("Saving configuration...");
        if (!InspecioConfig.createConfigDirectoryIfNeeded()) {
            return this;
        }
        Optional config = CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).result();
        if (config.isEmpty()) {
            Inspecio.warn("Failed to serialize configuration.");
            return this;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            JsonWriter jsonWriter = GSON.newJsonWriter((Writer)writer);
            GSON.toJson((JsonElement)((JsonElement)config.get()).getAsJsonObject(), jsonWriter);
        }
        catch (IOException e) {
            Inspecio.warn("Failed to save configuration.", e);
        }
        return this;
    }

    private static boolean createConfigDirectoryIfNeeded() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectory(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            return true;
        }
        catch (IOException e) {
            Inspecio.warn("Could not create missing \"config\" directory.", e);
            return false;
        }
    }

    private static boolean createConfigBackupDirectoryIfNeeded() {
        try {
            if (!Files.exists(CONFIG_BACKUP_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectory(CONFIG_BACKUP_PATH.getParent(), new FileAttribute[0]);
            }
            return true;
        }
        catch (IOException e) {
            Inspecio.warn("Could not create missing \"config/backup\" directory.", e);
            return false;
        }
    }

    private static InspecioConfig backupAndRestore(InspecioConfig config) {
        try {
            if (InspecioConfig.createConfigBackupDirectoryIfNeeded()) {
                Files.copy(CONFIG_PATH, CONFIG_BACKUP_PATH, StandardCopyOption.REPLACE_EXISTING);
            }
            config.save();
        }
        catch (IOException e) {
            Inspecio.warn("Could not backup existing configuration.", e);
        }
        return config;
    }

    public static InspecioConfig load() {
        InspecioConfig inspecioConfig;
        block11: {
            Inspecio.log("Loading configuration...");
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                if (!InspecioConfig.createConfigDirectoryIfNeeded()) {
                    return InspecioConfig.defaultConfig();
                }
                return InspecioConfig.defaultConfig().save();
            }
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).map(Pair::getFirst);
                InspecioConfig config = result.result().orElseGet(() -> {
                    Inspecio.warn("Could not load configuration, using default configuration instead.");
                    shouldSaveConfigAfterLoad = false;
                    return InspecioConfig.backupAndRestore(InspecioConfig.defaultConfig());
                });
                if (shouldSaveConfigAfterLoad) {
                    InspecioConfig.backupAndRestore(config);
                    shouldSaveConfigAfterLoad = false;
                }
                inspecioConfig = config;
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Inspecio.warn("Could not load configuration file.", e);
                    return InspecioConfig.backupAndRestore(InspecioConfig.defaultConfig());
                }
            }
            reader.close();
        }
        return inspecioConfig;
    }

    public static InspecioConfig defaultConfig() {
        return new InspecioConfig(true, true, true, ContainersConfig.defaultConfig(), EffectsConfig.defaultConfig(), EntitiesConfig.defaultConfig(), FilledMapConfig.defaultConfig(), FoodConfig.defaultConfig(), DEFAULT_JUKEBOX_TOOLTIP_MODE, DEFAULT_SIGN_TOOLTIP_MODE, AdvancedTooltipsConfig.defaultConfig());
    }

    public static class ContainersConfig {
        public static final boolean DEFAULT_CAMPFIRE = true;
        public static final Codec<ContainersConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("containers/campfire", true, ContainersConfig::isCampfireEnabled), InspecioConfig.configEntry(StorageContainerConfig.CODEC, "containers/storage", StorageContainerConfig::defaultConfig, ContainersConfig::getStorageConfig), InspecioConfig.configEntry(ShulkerBoxConfig.CODEC, "containers/shulker_box", ShulkerBoxConfig::defaultConfig, ContainersConfig::getShulkerBoxConfig), InspecioConfig.configEntry(ChiseledBookshelfConfig.CODEC, "containers/chiseled_bookshelf", ChiseledBookshelfConfig::defaultConfig, ContainersConfig::getChiseledBookshelfConfig)).apply((Applicative)instance, ContainersConfig::new));
        private boolean campfire;
        private final StorageContainerConfig storageContainerConfig;
        private final ShulkerBoxConfig shulkerBoxConfig;
        private final ChiseledBookshelfConfig chiseledBookshelfConfig;

        public ContainersConfig(boolean campfire, StorageContainerConfig storageContainerConfig, ShulkerBoxConfig shulkerBoxConfig, ChiseledBookshelfConfig chiseledBookshelfConfig) {
            this.campfire = campfire;
            this.storageContainerConfig = storageContainerConfig;
            this.shulkerBoxConfig = shulkerBoxConfig;
            this.chiseledBookshelfConfig = chiseledBookshelfConfig;
        }

        public boolean isCampfireEnabled() {
            return this.campfire;
        }

        public void setCampfire(boolean enabled) {
            this.campfire = enabled;
        }

        public StorageContainerConfig getStorageConfig() {
            return this.storageContainerConfig;
        }

        public ShulkerBoxConfig getShulkerBoxConfig() {
            return this.shulkerBoxConfig;
        }

        public ChiseledBookshelfConfig getChiseledBookshelfConfig() {
            return this.chiseledBookshelfConfig;
        }

        @Nullable
        public StorageContainerConfig forBlock(class_2248 block) {
            StorageContainerConfig config = null;
            if (block instanceof class_2281 || block instanceof class_3708 || block instanceof class_2315 || block instanceof class_2377) {
                config = this.getStorageConfig();
            } else if (block instanceof class_2480) {
                config = this.getShulkerBoxConfig();
            }
            return config;
        }

        public static ContainersConfig defaultConfig() {
            return new ContainersConfig(true, StorageContainerConfig.defaultConfig(), ShulkerBoxConfig.defaultConfig(), ChiseledBookshelfConfig.defaultConfig());
        }
    }

    public static class EffectsConfig {
        public static boolean DEFAULT_POTIONS = true;
        public static boolean DEFAULT_TIPPED_ARROWS = true;
        public static boolean DEFAULT_SPECTRAL_ARROW = true;
        public static boolean DEFAULT_FOOD = true;
        public static boolean DEFAULT_HIDDEN_MOTION = true;
        public static boolean DEFAULT_BEACON = true;
        public static HiddenEffectMode DEFAULT_HIDDEN_EFFECTS_MODE = HiddenEffectMode.ENCHANTMENT;
        public static final Codec<EffectsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("effects/potions", DEFAULT_POTIONS, EffectsConfig::hasPotions), InspecioConfig.configEntry("effects/tipped_arrows", DEFAULT_TIPPED_ARROWS, EffectsConfig::hasTippedArrows), InspecioConfig.configEntry("effects/spectral_arrow", DEFAULT_SPECTRAL_ARROW, EffectsConfig::hasSpectralArrow), InspecioConfig.configEntry("effects/food", DEFAULT_FOOD, EffectsConfig::hasFood), InspecioConfig.configEntry("effects/hidden_motion", DEFAULT_HIDDEN_MOTION, EffectsConfig::hasHiddenMotion), InspecioConfig.configEntry(HiddenEffectMode.CODEC, "effects/hidden_effect_mode", () -> DEFAULT_HIDDEN_EFFECTS_MODE, EffectsConfig::getHiddenEffectMode), InspecioConfig.configEntry("effects/beacon", DEFAULT_BEACON, EffectsConfig::hasBeacon)).apply((Applicative)instance, EffectsConfig::new));
        private boolean potions;
        private boolean tippedArrows;
        private boolean spectralArrow;
        private boolean food;
        private boolean hiddenMotion;
        private HiddenEffectMode hiddenEffectMode;
        private boolean beacon;

        public EffectsConfig(boolean potions, boolean tippedArrows, boolean spectralArrow, boolean food, boolean hiddenMotion, HiddenEffectMode hiddenEffectMode, boolean beacon) {
            this.potions = potions;
            this.tippedArrows = tippedArrows;
            this.spectralArrow = spectralArrow;
            this.food = food;
            this.hiddenMotion = hiddenMotion;
            this.hiddenEffectMode = hiddenEffectMode;
            this.beacon = beacon;
        }

        public boolean hasPotions() {
            return this.potions;
        }

        public void setPotions(boolean potions) {
            this.potions = potions;
        }

        public boolean hasTippedArrows() {
            return this.tippedArrows;
        }

        public void setTippedArrows(boolean tippedArrows) {
            this.tippedArrows = tippedArrows;
        }

        public boolean hasSpectralArrow() {
            return this.spectralArrow;
        }

        public void setSpectralArrow(boolean spectralArrow) {
            this.spectralArrow = spectralArrow;
        }

        public boolean hasFood() {
            return this.food;
        }

        public void setFood(boolean food) {
            this.food = food;
        }

        public boolean hasHiddenMotion() {
            return this.hiddenMotion;
        }

        public void setHiddenMotion(boolean hiddenMotion) {
            this.hiddenMotion = hiddenMotion;
        }

        public HiddenEffectMode getHiddenEffectMode() {
            return this.hiddenEffectMode;
        }

        public void setHiddenEffectMode(HiddenEffectMode hiddenEffectMode) {
            this.hiddenEffectMode = hiddenEffectMode;
        }

        public boolean hasBeacon() {
            return this.beacon;
        }

        public void setBeacon(boolean beacon) {
            this.beacon = beacon;
        }

        public static EffectsConfig defaultConfig() {
            return new EffectsConfig(DEFAULT_POTIONS, DEFAULT_TIPPED_ARROWS, DEFAULT_SPECTRAL_ARROW, DEFAULT_FOOD, DEFAULT_HIDDEN_MOTION, DEFAULT_HIDDEN_EFFECTS_MODE, DEFAULT_BEACON);
        }
    }

    public static class EntitiesConfig {
        public static final int DEFAULT_PUFF_STATE = 2;
        public static final Codec<EntitiesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry(EntityConfig.CODEC, "entities/armor_stand", EntityConfig::defaultConfig, EntitiesConfig::getArmorStandConfig), InspecioConfig.configEntry(BeeEntityConfig.CODEC, "entities/bee", BeeEntityConfig::defaultConfig, EntitiesConfig::getBeeConfig), InspecioConfig.configEntry(EntityConfig.CODEC, "entities/fish_bucket", EntityConfig::defaultConfig, EntitiesConfig::getFishBucketConfig), InspecioConfig.configEntry(EntityConfig.CODEC, "entities/spawn_egg", EntityConfig::defaultConfig, EntitiesConfig::getSpawnEggConfig), InspecioConfig.configEntry(EntityConfig.CODEC, "entities/mob_spawner", EntityConfig::defaultConfig, EntitiesConfig::getMobSpawnerConfig), (App)Codec.INT.fieldOf("pufferfish_puff_state").orElse((Object)2).forGetter(EntitiesConfig::getPufferFishPuffState)).apply((Applicative)instance, EntitiesConfig::new));
        private final EntityConfig armorStandConfig;
        private final BeeEntityConfig beeConfig;
        private final EntityConfig fishBucketConfig;
        private final EntityConfig spawnEggConfig;
        private final EntityConfig mobSpawnerConfig;
        private int pufferFishPuffState;

        public EntitiesConfig(EntityConfig armorStandConfig, BeeEntityConfig beeConfig, EntityConfig fishBucketConfig, EntityConfig spawnEggConfig, EntityConfig mobSpawnerConfig, int pufferFishPuffState) {
            this.armorStandConfig = armorStandConfig;
            this.beeConfig = beeConfig;
            this.fishBucketConfig = fishBucketConfig;
            this.spawnEggConfig = spawnEggConfig;
            this.mobSpawnerConfig = mobSpawnerConfig;
            this.setPufferFishPuffState(pufferFishPuffState);
        }

        public EntityConfig getArmorStandConfig() {
            return this.armorStandConfig;
        }

        public BeeEntityConfig getBeeConfig() {
            return this.beeConfig;
        }

        public EntityConfig getFishBucketConfig() {
            return this.fishBucketConfig;
        }

        public EntityConfig getSpawnEggConfig() {
            return this.spawnEggConfig;
        }

        public EntityConfig getMobSpawnerConfig() {
            return this.mobSpawnerConfig;
        }

        public int getPufferFishPuffState() {
            return this.pufferFishPuffState;
        }

        public void setPufferFishPuffState(int pufferFishPuffState) {
            this.pufferFishPuffState = class_3532.method_15340((int)pufferFishPuffState, (int)0, (int)2);
        }

        public static EntitiesConfig defaultConfig() {
            return new EntitiesConfig(EntityConfig.defaultConfig(), BeeEntityConfig.defaultConfig(), EntityConfig.defaultConfig(), EntityConfig.defaultConfig(), EntityConfig.defaultConfig(), 2);
        }
    }

    public static class FilledMapConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final boolean DEFAULT_SHOW_PLAYER_ICON = false;
        public static final Codec<FilledMapConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("filled_map/enabled", true, FilledMapConfig::isEnabled), InspecioConfig.configEntry("filled_map/show_player_icon", false, FilledMapConfig::shouldShowPlayerIcon)).apply((Applicative)instance, FilledMapConfig::new));
        private boolean enabled;
        private boolean showPlayerIcon;

        public FilledMapConfig(boolean enabled, boolean showPlayerIcon) {
            this.enabled = enabled;
            this.showPlayerIcon = showPlayerIcon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean shouldShowPlayerIcon() {
            return this.showPlayerIcon;
        }

        public void setShowPlayerIcon(boolean showPlayerIcon) {
            this.showPlayerIcon = showPlayerIcon;
        }

        public static FilledMapConfig defaultConfig() {
            return new FilledMapConfig(true, false);
        }
    }

    public static class FoodConfig {
        public static final boolean DEFAULT_HUNGER = true;
        public static final SaturationTooltipMode DEFAULT_SATURATION_TOOLTIP_MODE = SaturationTooltipMode.MERGED;
        public static final Codec<FoodConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("food/hunger", true, FoodConfig::hasHunger), InspecioConfig.configEntry(SaturationTooltipMode.CODEC, "food/saturation", () -> DEFAULT_SATURATION_TOOLTIP_MODE, FoodConfig::getSaturationMode)).apply((Applicative)instance, FoodConfig::new));
        private boolean hunger;
        private SaturationTooltipMode saturationMode;

        public FoodConfig(boolean hunger, SaturationTooltipMode saturationMode) {
            this.hunger = hunger;
            this.saturationMode = saturationMode;
        }

        public boolean hasHunger() {
            return this.hunger;
        }

        public void setHunger(boolean hunger) {
            this.hunger = hunger;
        }

        public SaturationTooltipMode getSaturationMode() {
            return this.saturationMode;
        }

        public void setSaturationMode(SaturationTooltipMode saturationMode) {
            this.saturationMode = saturationMode;
        }

        public boolean isEnabled() {
            return this.hunger || this.saturationMode.isEnabled();
        }

        public static FoodConfig defaultConfig() {
            return new FoodConfig(true, DEFAULT_SATURATION_TOOLTIP_MODE);
        }
    }

    public static class AdvancedTooltipsConfig {
        public static boolean DEFAULT_REPAIR_COST = true;
        public static boolean DEFAULT_LODESTONE_COORDS = false;
        public static final Codec<AdvancedTooltipsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("advanced_tooltips/repair_cost", DEFAULT_REPAIR_COST, AdvancedTooltipsConfig::hasRepairCost), InspecioConfig.configEntry("advanced_tooltips/lodestone_coords", DEFAULT_LODESTONE_COORDS, AdvancedTooltipsConfig::hasLodestoneCoords)).apply((Applicative)instance, AdvancedTooltipsConfig::new));
        private boolean repairCost;
        private boolean lodestoneCoords;

        public AdvancedTooltipsConfig(boolean repairCost, boolean lodestoneCoords) {
            this.repairCost = repairCost;
            this.lodestoneCoords = lodestoneCoords;
        }

        public boolean hasRepairCost() {
            return this.repairCost;
        }

        public void setRepairCost(boolean repairCost) {
            this.repairCost = repairCost;
        }

        public boolean hasLodestoneCoords() {
            return this.lodestoneCoords;
        }

        public void setLodestoneCoords(boolean lodestoneCoords) {
            this.lodestoneCoords = lodestoneCoords;
        }

        public static AdvancedTooltipsConfig defaultConfig() {
            return new AdvancedTooltipsConfig(DEFAULT_REPAIR_COST, DEFAULT_LODESTONE_COORDS);
        }
    }

    public static class BeeEntityConfig
    extends EntityConfig {
        public static final boolean DEFAULT_SHOW_HONEY_LEVEL = true;
        public static final Codec<BeeEntityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").orElse((Object)true).forGetter(EntityConfig::isEnabled), (App)Codec.BOOL.fieldOf("always_show_name").orElse((Object)false).forGetter(EntityConfig::shouldAlwaysShowName), (App)Codec.BOOL.fieldOf("spin").orElse((Object)true).forGetter(EntityConfig::shouldSpin), (App)Codec.BOOL.fieldOf("show_honey_level").orElse((Object)true).forGetter(BeeEntityConfig::shouldShowHoney)).apply((Applicative)instance, BeeEntityConfig::new));
        private boolean showHoneyLevel;

        public BeeEntityConfig(boolean enabled, boolean alwaysShowName, boolean spin, boolean showHoneyLevel) {
            super(enabled, alwaysShowName, spin);
            this.showHoneyLevel = showHoneyLevel;
        }

        public boolean shouldShowHoney() {
            return this.showHoneyLevel;
        }

        public void setShowHoneyLevel(boolean showHoneyLevel) {
            this.showHoneyLevel = showHoneyLevel;
        }

        public static BeeEntityConfig defaultConfig() {
            return new BeeEntityConfig(true, false, true, true);
        }
    }

    public static class EntityConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final boolean DEFAULT_ALWAYS_SHOW_NAME = false;
        public static final boolean DEFAULT_SPIN = true;
        public static final Codec<EntityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").orElse((Object)true).forGetter(EntityConfig::isEnabled), (App)Codec.BOOL.fieldOf("always_show_name").orElse((Object)false).forGetter(EntityConfig::shouldAlwaysShowName), (App)Codec.BOOL.fieldOf("spin").orElse((Object)true).forGetter(EntityConfig::shouldSpin)).apply((Applicative)instance, EntityConfig::new));
        private boolean enabled;
        private boolean alwaysShowName;
        private boolean spin;

        public EntityConfig(boolean enabled, boolean alwaysShowName, boolean spin) {
            this.enabled = enabled;
            this.alwaysShowName = alwaysShowName;
            this.spin = spin;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean shouldAlwaysShowName() {
            return this.alwaysShowName;
        }

        public void setAlwaysShowName(boolean alwaysShowName) {
            this.alwaysShowName = alwaysShowName;
        }

        public boolean shouldSpin() {
            return this.spin;
        }

        public void setSpin(boolean spin) {
            this.spin = spin;
        }

        public static EntityConfig defaultConfig() {
            return new EntityConfig(true, false, true);
        }
    }

    public static class ChiseledBookshelfConfig
    extends StorageContainerConfig {
        public static final boolean DEFAULT_BLOCK_RENDER = true;
        public static final Codec<ChiseledBookshelfConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("containers/chiseled_bookshelf/enabled", true, StorageContainerConfig::isEnabled), InspecioConfig.configEntry("containers/chiseled_bookshelf/compact", false, StorageContainerConfig::isCompact), InspecioConfig.configEntry("containers/chiseled_bookshelf/loot_table", true, StorageContainerConfig::hasLootTable), InspecioConfig.configEntry("containers/chiseled_bookshelf/block_render", true, ChiseledBookshelfConfig::hasBlockRender)).apply((Applicative)instance, ChiseledBookshelfConfig::new));
        private boolean blockRender;

        public ChiseledBookshelfConfig(boolean enabled, boolean compact, boolean lootTable, boolean blockRender) {
            super(enabled, compact, lootTable);
            this.blockRender = blockRender;
        }

        public boolean hasBlockRender() {
            return this.blockRender;
        }

        public void setBlockRender(boolean blockRender) {
            this.blockRender = blockRender;
        }

        public static ChiseledBookshelfConfig defaultConfig() {
            return new ChiseledBookshelfConfig(true, false, true, true);
        }
    }

    public static class ShulkerBoxConfig
    extends StorageContainerConfig {
        public static final boolean DEFAULT_COLOR = true;
        public static final Codec<ShulkerBoxConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("containers/shulker_box/enabled", true, StorageContainerConfig::isEnabled), InspecioConfig.configEntry("containers/shulker_box/compact", false, StorageContainerConfig::isCompact), InspecioConfig.configEntry("containers/shulker_box/loot_table", true, StorageContainerConfig::hasLootTable), InspecioConfig.configEntry("containers/shulker_box/color", true, ShulkerBoxConfig::hasColor)).apply((Applicative)instance, ShulkerBoxConfig::new));
        private boolean color;

        public ShulkerBoxConfig(boolean enabled, boolean compact, boolean lootTable, boolean color) {
            super(enabled, compact, lootTable);
            this.color = color;
        }

        public boolean hasColor() {
            return this.color;
        }

        public void setColor(boolean color) {
            this.color = color;
        }

        public static ShulkerBoxConfig defaultConfig() {
            return new ShulkerBoxConfig(true, false, true, true);
        }
    }

    public static class StorageContainerConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final boolean DEFAULT_COMPACT = false;
        public static final boolean DEFAULT_LOOT_TABLE = true;
        public static final Codec<StorageContainerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(InspecioConfig.configEntry("containers/storage/enabled", true, StorageContainerConfig::isEnabled), InspecioConfig.configEntry("containers/storage/compact", false, StorageContainerConfig::isCompact), InspecioConfig.configEntry("containers/storage/loot_table", true, StorageContainerConfig::hasLootTable)).apply((Applicative)instance, StorageContainerConfig::new));
        private boolean enabled;
        private boolean compact;
        private boolean lootTable;

        public StorageContainerConfig(boolean enabled, boolean compact, boolean lootTable) {
            this.enabled = enabled;
            this.compact = compact;
            this.lootTable = lootTable;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public void setCompact(boolean compact) {
            this.compact = compact;
        }

        public boolean hasLootTable() {
            return this.lootTable;
        }

        public void setLootTable(boolean lootTable) {
            this.lootTable = lootTable;
        }

        public static StorageContainerConfig defaultConfig() {
            return new StorageContainerConfig(true, false, true);
        }
    }
}

