/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public enum JukeboxTooltipMode {
    DISABLED,
    FAST,
    FANCY;

    public static final PrimitiveCodec<JukeboxTooltipMode> CODEC;

    public boolean isEnabled() {
        return this != DISABLED;
    }

    public JukeboxTooltipMode next() {
        JukeboxTooltipMode[] v = JukeboxTooltipMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<JukeboxTooltipMode> byId(@NotNull String id) {
        return Arrays.stream(JukeboxTooltipMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    static {
        CODEC = new PrimitiveCodec<JukeboxTooltipMode>(){

            public <T> DataResult<JukeboxTooltipMode> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(id -> JukeboxTooltipMode.byId(id).orElse(DISABLED));
            }

            public <T> T write(DynamicOps<T> ops, JukeboxTooltipMode value) {
                return (T)ops.createString(value.getName());
            }

            public String toString() {
                return "JukeboxTooltipMode";
            }
        };
    }

    public static class JukeboxArgumentType
    implements ArgumentType<JukeboxTooltipMode> {
        private static final SimpleCommandExceptionType UNKNOWN_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"inspecio.command.error.unknown_jukebox_tooltip_mode"));
        private static final List<JukeboxTooltipMode> VALUES = List.of(JukeboxTooltipMode.values());

        private JukeboxArgumentType() {
        }

        public static JukeboxArgumentType jukeboxTooltipMode() {
            return new JukeboxArgumentType();
        }

        public static JukeboxTooltipMode getJukeboxTooltipMode(CommandContext<?> context, String name) {
            return (JukeboxTooltipMode)((Object)context.getArgument(name, JukeboxTooltipMode.class));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            VALUES.stream().map(JukeboxTooltipMode::getName).filter(s -> s.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return VALUES.stream().map(JukeboxTooltipMode::getName).collect(Collectors.toList());
        }

        public JukeboxTooltipMode parse(StringReader reader) throws CommandSyntaxException {
            String value = reader.readString();
            return VALUES.stream().filter(s -> s.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> UNKNOWN_VALUE.createWithContext((ImmutableStringReader)reader));
        }
    }
}

