/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public enum SaturationTooltipMode {
    DISABLED,
    MERGED,
    SEPARATED;

    public static final PrimitiveCodec<SaturationTooltipMode> CODEC;

    public boolean isEnabled() {
        return this != DISABLED;
    }

    public SaturationTooltipMode next() {
        SaturationTooltipMode[] v = SaturationTooltipMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<SaturationTooltipMode> byId(@NotNull String id) {
        return Arrays.stream(SaturationTooltipMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    static {
        CODEC = new PrimitiveCodec<SaturationTooltipMode>(){

            public <T> DataResult<SaturationTooltipMode> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(id -> SaturationTooltipMode.byId(id).orElse(DISABLED));
            }

            public <T> T write(DynamicOps<T> ops, SaturationTooltipMode value) {
                return (T)ops.createString(value.getName());
            }

            public String toString() {
                return "SaturationTooltipMode";
            }
        };
    }

    public static class SaturationArgumentType
    implements ArgumentType<SaturationTooltipMode> {
        private static final SimpleCommandExceptionType UNKNOWN_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"inspecio.command.error.unknown_saturation_tooltip_mode"));
        private static final List<SaturationTooltipMode> VALUES = List.of(SaturationTooltipMode.values());

        private SaturationArgumentType() {
        }

        public static SaturationArgumentType saturationTooltipMode() {
            return new SaturationArgumentType();
        }

        public static SaturationTooltipMode getSaturationTooltipMode(CommandContext<?> context, String name) {
            return (SaturationTooltipMode)((Object)context.getArgument(name, SaturationTooltipMode.class));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            VALUES.stream().map(SaturationTooltipMode::getName).filter(s -> s.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return VALUES.stream().map(SaturationTooltipMode::getName).collect(Collectors.toList());
        }

        public SaturationTooltipMode parse(StringReader reader) throws CommandSyntaxException {
            String value = reader.readString();
            return VALUES.stream().filter(s -> s.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> UNKNOWN_VALUE.createWithContext((ImmutableStringReader)reader));
        }
    }
}

