/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public enum SignTooltipMode {
    DISABLED,
    FAST,
    FANCY;

    public static final PrimitiveCodec<SignTooltipMode> CODEC;

    public boolean isEnabled() {
        return this != DISABLED;
    }

    public SignTooltipMode next() {
        SignTooltipMode[] v = SignTooltipMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<SignTooltipMode> byId(@NotNull String id) {
        return Arrays.stream(SignTooltipMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }

    static {
        CODEC = new PrimitiveCodec<SignTooltipMode>(){

            public <T> DataResult<SignTooltipMode> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(id -> SignTooltipMode.byId(id).orElse(DISABLED));
            }

            public <T> T write(DynamicOps<T> ops, SignTooltipMode value) {
                return (T)ops.createString(value.getName());
            }

            public String toString() {
                return "SignTooltipMode";
            }
        };
    }

    public static class SignArgumentType
    implements ArgumentType<SignTooltipMode> {
        private static final SimpleCommandExceptionType UNKNOWN_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"inspecio.command.error.unknown_sign_tooltip_mode"));
        private static final List<SignTooltipMode> VALUES = List.of(SignTooltipMode.values());

        private SignArgumentType() {
        }

        public static SignArgumentType signTooltipMode() {
            return new SignArgumentType();
        }

        public static SignTooltipMode getSignTooltipMode(CommandContext<?> context, String name) {
            return (SignTooltipMode)((Object)context.getArgument(name, SignTooltipMode.class));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            VALUES.stream().map(SignTooltipMode::getName).filter(s -> s.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return VALUES.stream().map(SignTooltipMode::getName).collect(Collectors.toList());
        }

        public SignTooltipMode parse(StringReader reader) throws CommandSyntaxException {
            String value = reader.readString();
            return VALUES.stream().filter(s -> s.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> UNKNOWN_VALUE.createWithContext((ImmutableStringReader)reader));
        }
    }
}

