/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.api;

import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.api.InventoryProviderManager;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.minecraft.ClientOnly;

@FunctionalInterface
@ClientOnly
public interface InventoryProvider {
    @Nullable
    public Context getInventoryContext(class_1799 var1, @Nullable InspecioConfig.StorageContainerConfig var2);

    @Nullable
    public static Context searchInventoryContextOf(class_1799 stack, @Nullable InspecioConfig.StorageContainerConfig config) {
        return InventoryProviderManager.getInventoryContext(stack, config);
    }

    public static void register(InventoryProvider provider, class_1792 ... items) {
        if (items.length != 0) {
            for (class_1792 item : items) {
                InventoryProviderManager.MAPPED_PROVIDERS.put(item, provider);
            }
        } else {
            InventoryProviderManager.PROVIDERS.add(provider);
        }
    }

    public record Context(List<class_1799> inventory, int columns, @Nullable class_1767 color) {
        public Context(List<class_1799> inventory, int columns) {
            this(inventory, columns, null);
        }

        public Context(List<class_1799> inventory, @Nullable class_1767 color) {
            this(inventory, Context.getColumns(inventory), color);
        }

        static int getColumns(List<class_1799> inventory) {
            return inventory.size() % 3 == 0 ? inventory.size() / 3 : inventory.size();
        }
    }
}

