/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.api;

import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.api.InventoryProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.minecraft.ClientOnly;

@ClientOnly
@ApiStatus.Internal
final class InventoryProviderManager {
    static final Map<class_1792, InventoryProvider> MAPPED_PROVIDERS = new Object2ObjectOpenHashMap();
    static final List<InventoryProvider> PROVIDERS = new ArrayList<InventoryProvider>();

    InventoryProviderManager() {
    }

    @Nullable
    static InventoryProvider.Context getInventoryContext(class_1799 stack, @Nullable InspecioConfig.StorageContainerConfig config) {
        InventoryProvider.Context context;
        InventoryProvider mappedProvider = MAPPED_PROVIDERS.get(stack.method_7909());
        if (mappedProvider != null && (context = mappedProvider.getInventoryContext(stack, config)) != null) {
            return context;
        }
        context = null;
        for (InventoryProvider provider : PROVIDERS) {
            InventoryProvider.Context currentContext = provider.getInventoryContext(stack, config);
            if (currentContext == null || context != null && currentContext.inventory().size() <= context.inventory().size()) continue;
            context = currentContext;
        }
        return context;
    }
}

