/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.mixin;

import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.api.InventoryProvider;
import io.github.queerbric.inspecio.tooltip.BeesTooltipComponent;
import io.github.queerbric.inspecio.tooltip.CampfireTooltipComponent;
import io.github.queerbric.inspecio.tooltip.ChiseledBookshelfTooltipComponent;
import io.github.queerbric.inspecio.tooltip.InventoryTooltipComponent;
import io.github.queerbric.inspecio.tooltip.JukeboxTooltipComponent;
import io.github.queerbric.inspecio.tooltip.SpawnEntityTooltipComponent;
import io.github.queerbric.inspecio.tooltip.StatusEffectTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2238;
import net.minecraft.class_2248;
import net.minecraft.class_2387;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2561;
import net.minecraft.class_3922;
import net.minecraft.class_437;
import net.minecraft.class_4481;
import net.minecraft.class_5632;
import net.minecraft.class_7714;
import org.quiltmc.loader.api.minecraft.ClientOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@ClientOnly
@Mixin(value={class_1747.class})
public abstract class BlockItemMixin
extends class_1792 {
    @Shadow
    public abstract class_2248 method_7711();

    public BlockItemMixin(class_1792.class_1793 settings) {
        super(settings);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        InspecioConfig inspecioConfig = Inspecio.getConfig();
        InspecioConfig.ContainersConfig containersConfig = inspecioConfig.getContainersConfig();
        InspecioConfig.EffectsConfig effectsConfig = inspecioConfig.getEffectsConfig();
        if (effectsConfig.hasBeacon() && this.method_7711() instanceof class_2238) {
            class_2487 blockEntityTag = class_1747.method_38072((class_1799)stack);
            ArrayList<class_1293> effectsList = new ArrayList<class_1293>();
            class_1293 primary = Inspecio.getRawEffectFromTag(blockEntityTag, "Primary");
            class_1293 secondary = Inspecio.getRawEffectFromTag(blockEntityTag, "Secondary");
            if (primary != null && primary.equals((Object)secondary)) {
                primary = new class_1293(primary.method_5579(), 200, 1);
                secondary = null;
            }
            if (primary != null) {
                effectsList.add(primary);
            }
            if (secondary != null) {
                effectsList.add(secondary);
            }
            return Optional.of(new StatusEffectTooltipComponent(effectsList, 1.0f));
        }
        if (this.method_7711() instanceof class_4481) {
            Optional<class_5632> data = BeesTooltipComponent.of(stack);
            if (data.isPresent()) {
                return data;
            }
        } else if (this.method_7711() instanceof class_3922) {
            Optional<class_5632> data = CampfireTooltipComponent.of(stack);
            if (data.isPresent()) {
                return data;
            }
        } else if (this.method_7711() instanceof class_2387) {
            Optional<class_5632> data = JukeboxTooltipComponent.of(stack);
            if (data.isPresent()) {
                return data;
            }
        } else if (this.method_7711() instanceof class_2496) {
            Optional<class_5632> data = SpawnEntityTooltipComponent.ofMobSpawner(stack);
            if (data.isPresent()) {
                return data;
            }
        } else if (this.method_7711() instanceof class_7714) {
            Optional<class_5632> data = ChiseledBookshelfTooltipComponent.of(stack);
            if (data.isPresent()) {
                return data;
            }
        } else {
            InspecioConfig.StorageContainerConfig config = containersConfig.forBlock(this.method_7711());
            InventoryProvider.Context context = InventoryProvider.searchInventoryContextOf(stack, config);
            if (config == null) {
                config = containersConfig.getStorageConfig();
            }
            if (context != null) {
                return InventoryTooltipComponent.of(stack, config.isCompact(), context);
            }
        }
        return super.method_32346(stack);
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAppendTooltip(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context, CallbackInfo ci) {
        if (this.method_7711() instanceof class_2480 && !class_437.method_25441()) {
            Inspecio.appendBlockItemTooltip(stack, this.method_7711(), tooltip);
            ci.cancel();
        }
    }

    @Inject(method={"appendTooltip"}, at={@At(value="TAIL")})
    private void onAppendTooltipEnd(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context, CallbackInfo ci) {
        Inspecio.appendBlockItemTooltip(stack, this.method_7711(), tooltip);
    }
}

