/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.mixin;

import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.mixin.SuspiciousStewItemAccessor;
import io.github.queerbric.inspecio.tooltip.ArmorTooltipComponent;
import io.github.queerbric.inspecio.tooltip.CompoundTooltipComponent;
import io.github.queerbric.inspecio.tooltip.FoodTooltipComponent;
import io.github.queerbric.inspecio.tooltip.PaintingTooltipComponent;
import io.github.queerbric.inspecio.tooltip.StatusEffectTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1759;
import net.minecraft.class_1790;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1830;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.minecraft.ClientOnly;
import org.quiltmc.qsl.tooltip.api.client.TooltipComponentCallback;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@ClientOnly
@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Unique
    private final ThreadLocal<List<class_2561>> inspecio$tooltipList = new ThreadLocal();

    @Shadow
    public abstract int method_7928();

    @Shadow
    public abstract class_1792 method_7909();

    @Shadow
    @Nullable
    public abstract class_2487 method_7969();

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasCustomName()Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGetTooltipBeing(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> list) {
        this.inspecio$tooltipList.set(list);
    }

    @Inject(method={"getTooltip"}, at={@At(value="RETURN")})
    private void onGetTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        int repairCost;
        List<class_2561> tooltip = this.inspecio$tooltipList.get();
        InspecioConfig.AdvancedTooltipsConfig advancedTooltipsConfig = Inspecio.getConfig().getAdvancedTooltipsConfig();
        if (advancedTooltipsConfig.hasLodestoneCoords() && this.method_7909() instanceof class_1759 && class_1759.method_26365((class_1799)((class_1799)this))) {
            class_2487 nbt = this.method_7969();
            assert (nbt != null);
            class_4208 globalPos = class_1759.method_43124((class_2487)nbt);
            if (globalPos != null) {
                class_2338 pos = globalPos.method_19446();
                class_5250 posText = class_2561.method_43470((String)String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(class_124.field_1065);
                tooltip.add((class_2561)class_2561.method_43469((String)"inspecio.tooltip.lodestone_compass.target", (Object[])new Object[]{posText}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"inspecio.tooltip.lodestone_compass.dimension", (Object[])new Object[]{class_2561.method_43470((String)globalPos.method_19442().method_29177().toString()).method_27692(class_124.field_1065)}).method_27692(class_124.field_1080));
            }
        }
        if (advancedTooltipsConfig.hasRepairCost() && (repairCost = this.method_7928()) != 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"inspecio.tooltip.repair_cost", (Object[])new Object[]{repairCost}).method_27692(class_124.field_1080));
        }
    }

    @Inject(method={"getTooltipData"}, at={@At(value="RETURN")}, cancellable=true)
    private void getTooltipData(CallbackInfoReturnable<Optional<class_5632>> info) {
        Object comp;
        ArrayList<Object> datas = new ArrayList<Object>();
        ((Optional)info.getReturnValue()).ifPresent(datas::add);
        InspecioConfig config = Inspecio.getConfig();
        class_1799 stack = (class_1799)this;
        if (stack.method_19267()) {
            comp = stack.method_7909().method_19264();
            if (config.getFoodConfig().isEnabled()) {
                datas.add(new FoodTooltipComponent((class_4174)comp));
            }
            if (config.getEffectsConfig().hasPotions()) {
                if (stack.method_31573(Inspecio.HIDDEN_EFFECTS_TAG)) {
                    datas.add(new StatusEffectTooltipComponent());
                } else if (comp.method_19235().size() > 0) {
                    datas.add(new StatusEffectTooltipComponent(comp.method_19235()));
                } else if (stack.method_7909() instanceof class_1830) {
                    ArrayList<class_1293> effects = new ArrayList<class_1293>();
                    SuspiciousStewItemAccessor.invokeConsumeStatusEffects(stack, effects::add);
                    if (effects.size() != 0) {
                        datas.add(new StatusEffectTooltipComponent(effects, 1.0f));
                    }
                } else {
                    datas.add(new StatusEffectTooltipComponent(class_1844.method_8067((class_1799)stack), 1.0f));
                }
            }
        }
        if (stack.method_7909() instanceof class_1738) {
            ArmorTooltipComponent.of(stack).ifPresent(datas::add);
        }
        if (stack.method_7909() instanceof class_1790) {
            PaintingTooltipComponent.of(stack).ifPresent(datas::add);
        }
        if (datas.size() == 1) {
            info.setReturnValue(Optional.of((class_5632)datas.get(0)));
        } else if (datas.size() > 1) {
            comp = new CompoundTooltipComponent();
            for (class_5632 class_56322 : datas) {
                class_5684 component = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(class_56322);
                if (component == null) continue;
                ((CompoundTooltipComponent)comp).addComponent(component);
            }
            info.setReturnValue(Optional.of(comp));
        }
    }
}

