/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.tooltip.EntityTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4481;
import net.minecraft.class_4587;
import net.minecraft.class_5632;

public class BeesTooltipComponent
extends EntityTooltipComponent<InspecioConfig.BeeEntityConfig> {
    private static final class_2960 HONEY_LEVEL_TEXTURE = new class_2960("inspecio", "textures/tooltips/honey_level.png");
    private final List<Bee> bees = new ArrayList<Bee>();
    private final int honeyLevel;

    public BeesTooltipComponent(InspecioConfig.BeeEntityConfig config, int honeyLevel, class_2499 bees) {
        super(config);
        this.honeyLevel = honeyLevel;
        bees.stream().map(nbt -> (class_2487)nbt).forEach(nbt -> {
            class_2487 bee = nbt.method_10562("EntityData");
            bee.method_10551("UUID");
            bee.method_10551("Passengers");
            bee.method_10551("Leash");
            class_1297 entity = class_1299.method_17842((class_2487)bee, (class_1937)this.client.field_1687, Function.identity());
            if (entity != null) {
                this.bees.add(new Bee(nbt.method_10550("TicksInHive"), entity));
            }
        });
    }

    public static Optional<class_5632> of(class_1799 stack) {
        class_2499 bees;
        class_2487 nbt;
        InspecioConfig.BeeEntityConfig config = Inspecio.getConfig().getEntitiesConfig().getBeeConfig();
        if (!config.isEnabled() && !config.shouldShowHoney()) {
            return Optional.empty();
        }
        int honeyLevel = 0;
        class_2487 stateNbt = stack.method_7941("BlockStateTag");
        if (stateNbt != null) {
            class_2520 honeyLevelNbt = stateNbt.method_10580(class_4481.field_20420.method_11899());
            if (honeyLevelNbt instanceof class_2497) {
                class_2497 nbtInt = (class_2497)honeyLevelNbt;
                honeyLevel = nbtInt.method_10701();
            } else if (honeyLevelNbt instanceof class_2519) {
                class_2519 nbtString = (class_2519)honeyLevelNbt;
                try {
                    honeyLevel = Integer.parseInt(nbtString.method_10714());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!((nbt = class_1747.method_38072((class_1799)stack)) != null && nbt.method_10573("Bees", 9) || config.shouldShowHoney())) {
            return Optional.empty();
        }
        class_2499 class_24992 = bees = nbt == null || !config.isEnabled() ? new class_2499() : nbt.method_10554("Bees", 10);
        if (!bees.isEmpty() || config.shouldShowHoney()) {
            return Optional.of(new BeesTooltipComponent(config, honeyLevel, bees));
        }
        return Optional.empty();
    }

    @Override
    public int method_32661() {
        if (this.bees.isEmpty()) {
            return ((InspecioConfig.BeeEntityConfig)this.config).shouldShowHoney() ? 12 : 0;
        }
        return (this.shouldRenderCustomNames() ? 32 : 24) + (((InspecioConfig.BeeEntityConfig)this.config).shouldShowHoney() ? 16 : 0);
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        return Math.max(this.bees.size() * 26, ((InspecioConfig.BeeEntityConfig)this.config).shouldShowHoney() ? 52 : 0);
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 graphics) {
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        if (!this.bees.isEmpty()) {
            matrices.method_46416(2.0f, 4.0f, 0.0f);
            int xOffset = x;
            for (Bee bee : this.bees) {
                this.renderEntity(matrices, xOffset, y + (this.shouldRenderCustomNames() ? 8 : 0), bee.bee(), bee.ticksInHive(), ((InspecioConfig.BeeEntityConfig)this.config).shouldSpin(), true);
                xOffset += 26;
            }
        }
        if (((InspecioConfig.BeeEntityConfig)this.config).shouldShowHoney()) {
            matrices.method_46416((float)x, (float)(y + (this.bees.isEmpty() ? 0 : (this.shouldRenderCustomNames() ? 32 : 24))), 0.0f);
            matrices.method_22905(2.0f, 2.0f, 1.0f);
            graphics.method_25291(HONEY_LEVEL_TEXTURE, 0, 0, 0, 0.0f, 0.0f, 26, 5, 32, 16);
            if (this.honeyLevel != 0) {
                graphics.method_25291(HONEY_LEVEL_TEXTURE, 0, 0, 0, 0.0f, 5.0f, Math.min(25, this.honeyLevel * 5 + 1), 6, 32, 16);
            }
        }
        matrices.method_22909();
    }

    @Override
    protected boolean shouldRender() {
        return !this.bees.isEmpty();
    }

    @Override
    protected boolean shouldRenderCustomNames() {
        return this.bees.stream().map(bee -> bee.bee().method_16914()).reduce(false, (first, second) -> first != false || second != false) != false && (((InspecioConfig.BeeEntityConfig)this.config).shouldAlwaysShowName() || class_437.method_25441());
    }

    record Bee(int ticksInHive, class_1297 bee) {
    }
}

