/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.mixin.CameraAccessor;
import io.github.queerbric.inspecio.mixin.EntityAccessor;
import io.github.queerbric.inspecio.mixin.ItemEntityAccessor;
import io.github.queerbric.inspecio.mixin.TropicalFishEntityAccessor;
import io.github.queerbric.inspecio.mixin.WitherEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1454;
import net.minecraft.class_1477;
import net.minecraft.class_1511;
import net.minecraft.class_1542;
import net.minecraft.class_2487;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import net.minecraft.class_5761;
import net.minecraft.class_6053;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.quiltmc.qsl.tooltip.api.ConvertibleTooltipData;

public abstract class EntityTooltipComponent<C extends InspecioConfig.EntityConfig>
implements ConvertibleTooltipData,
class_5684 {
    protected final class_310 client = class_310.method_1551();
    protected final C config;

    protected EntityTooltipComponent(C config) {
        this.config = config;
    }

    public class_5684 toComponent() {
        return this;
    }

    public int method_32661() {
        return !this.shouldRender() ? 0 : (this.shouldRenderCustomNames() ? 32 : 24);
    }

    public int method_32664(class_327 textRenderer) {
        return this.shouldRender() ? 24 : 0;
    }

    protected void renderEntity(class_4587 matrices, int x, int y, class_1297 entity, int ageOffset, boolean spin, boolean allowCustomName) {
        this.renderEntity(matrices, x, y, entity, ageOffset, spin, allowCustomName, 180.0f);
    }

    protected void renderEntity(class_4587 matrices, int x, int y, class_1297 entity, int ageOffset, boolean spin, boolean allowCustomName, float defaultYaw) {
        class_1309 living;
        float size = 24.0f;
        if ((double)Math.max(entity.method_17681(), entity.method_17682()) > 1.0) {
            size /= Math.max(entity.method_17681(), entity.method_17682());
        }
        class_308.method_24210();
        matrices.method_22903();
        int yOffset = 16;
        if (entity instanceof class_1477) {
            size = 16.0f;
            yOffset = 2;
        } else if (entity instanceof class_1542) {
            size = 48.0f;
            yOffset = 28;
        }
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_6109()) {
            size = (float)((double)size / 1.7);
        }
        matrices.method_46416((float)(x + 10), (float)(y + yOffset), 1050.0f);
        matrices.method_22905(1.0f, 1.0f, -1.0f);
        matrices.method_46416(0.0f, 0.0f, 1000.0f);
        matrices.method_22905(size, size, size);
        Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf quaternion2 = class_7833.field_40714.rotationDegrees(-10.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        matrices.method_22907(quaternion);
        if (this.client.field_1719 != null) {
            entity.method_23327(this.client.field_1719.method_23317(), this.client.field_1719.method_23318(), this.client.field_1719.method_23321());
        }
        this.setupAngles(entity, this.client.field_1724.field_6012, ageOffset, spin, defaultYaw);
        class_898 entityRenderDispatcher = this.client.method_1561();
        quaternion2.conjugate();
        ((CameraAccessor)entityRenderDispatcher.field_4686).setYaw(0.0f);
        entity.method_20803(((EntityAccessor)entity).getHasVisualFire() ? 1 : entity.method_20802());
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = this.client.method_22940().method_23000();
        entity.method_5880(allowCustomName && entity.method_16914() && (((InspecioConfig.EntityConfig)this.config).shouldAlwaysShowName() || class_437.method_25441()));
        entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, (class_4597)immediate, 0xF000F0);
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        matrices.method_22909();
        class_308.method_24211();
    }

    protected void setupAngles(class_1297 entity, int age, int ageOffset, boolean spin, float defaultYaw) {
        entity.field_6012 = age + ageOffset;
        float yaw = spin ? (float)((System.currentTimeMillis() / 10L + (long)ageOffset) % 360L) : defaultYaw;
        entity.method_36456(yaw);
        entity.method_5847(yaw);
        entity.method_36457(0.0f);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living instanceof class_6053) {
                living.field_6241 = yaw;
            } else if (living instanceof WitherEntityAccessor) {
                WitherEntityAccessor wither = (WitherEntityAccessor)living;
                float f = yaw;
                wither.getSideHeadYaws()[1] = f;
                wither.getSideHeadYaws()[0] = f;
            }
            living.field_6283 = yaw;
        } else if (entity instanceof ItemEntityAccessor) {
            ItemEntityAccessor itemEntity = (ItemEntityAccessor)entity;
            itemEntity.setItemAge(entity.field_6012);
            itemEntity.setUniqueOffset(0.0f);
        } else if (entity instanceof class_1511) {
            class_1511 endCrystal = (class_1511)entity;
            endCrystal.field_7034 = endCrystal.field_6012;
        }
    }

    protected abstract boolean shouldRender();

    protected abstract boolean shouldRenderCustomNames();

    protected static void adjustEntity(class_1297 entity, class_2487 itemNbt, InspecioConfig.EntitiesConfig config) {
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            bucketable.method_35170(itemNbt);
            if (entity instanceof class_1454) {
                class_1454 pufferfish = (class_1454)entity;
                pufferfish.method_6596(config.getPufferFishPuffState());
            } else if (entity instanceof TropicalFishEntityAccessor) {
                TropicalFishEntityAccessor tropicalFish = (TropicalFishEntityAccessor)entity;
                if (itemNbt.method_10573("BucketVariantTag", 3)) {
                    tropicalFish.invokeSetVariantId(itemNbt.method_10550("BucketVariantTag"));
                }
            }
        }
    }
}

