/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.SaturationTooltipMode;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5684;
import org.quiltmc.qsl.tooltip.api.ConvertibleTooltipData;

public record FoodTooltipComponent(int hunger, float saturation) implements ConvertibleTooltipData,
class_5684
{
    private static final int COLUMNS = 16;

    public FoodTooltipComponent(class_4174 component) {
        this(component.method_19230(), (float)component.method_19230() * component.method_19231());
    }

    public class_5684 toComponent() {
        return this;
    }

    public int method_32661() {
        InspecioConfig.FoodConfig foodConfig = Inspecio.getConfig().getFoodConfig();
        int height = Math.max(11 * this.getLines(this.getHungerChunks()), 11 * this.getLines(class_3532.method_15386((float)this.saturation)));
        if (foodConfig.hasHunger() && foodConfig.getSaturationMode() == SaturationTooltipMode.SEPARATED) {
            height += 11 * this.getLines(this.getSaturationChunks());
        }
        return height;
    }

    public int method_32664(class_327 textRenderer) {
        return Math.min(Math.max(this.hunger / 2 * 9, (int)this.saturation * 9), 144);
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 graphics) {
        int i;
        InspecioConfig.FoodConfig foodConfig = Inspecio.getConfig().getFoodConfig();
        int saturationY = y;
        if (foodConfig.getSaturationMode() == SaturationTooltipMode.SEPARATED && foodConfig.hasHunger()) {
            saturationY += 11 * this.getLines(this.getHungerChunks());
        }
        ChunkPos pos = new ChunkPos(x, y);
        if (foodConfig.hasHunger()) {
            for (i = 0; i < (this.hunger + 1) / 2; ++i) {
                pos.wrap(i);
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 16.0f, 27.0f, 9, 9, 256, 256);
                pos.moveForward();
            }
        }
        if (foodConfig.getSaturationMode().isEnabled()) {
            RenderSystem.setShaderColor((float)0.62352943f, (float)0.5254902f, (float)0.03529412f, (float)1.0f);
            pos.reset(x, saturationY);
            i = 0;
            while ((float)i < this.saturation) {
                pos.wrap(i);
                int width = 9;
                if (this.saturation - (float)i < 1.0f) {
                    width = Math.round((float)width * (this.saturation - (float)i));
                }
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 25.0f, 27.0f, width, 9, 256, 256);
                pos.moveForward();
                ++i;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (foodConfig.hasHunger()) {
            pos.reset(x, y);
            for (i = 0; i < this.hunger / 2; ++i) {
                pos.wrap(i);
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 52.0f, 27.0f, 9, 9, 256, 256);
                pos.moveForward();
            }
            if (this.hunger % 2 == 1) {
                pos.wrap(this.hunger / 2);
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 61.0f, 27.0f, 9, 9, 256, 256);
            }
        }
        if (foodConfig.getSaturationMode() == SaturationTooltipMode.SEPARATED || !foodConfig.hasHunger()) {
            RenderSystem.setShaderColor((float)0.8980392f, (float)0.8f, (float)0.81960785f, (float)1.0f);
            pos.reset(x, saturationY);
            int intSaturation = Math.max(1, this.getSaturation());
            if ((double)(this.saturation * 2.0f - (float)intSaturation) > 0.2) {
                ++intSaturation;
            }
            for (int i2 = 0; i2 < intSaturation / 2; ++i2) {
                pos.wrap(i2);
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 52.0f, 27.0f, 9, 9, 256, 256);
                pos.moveForward();
            }
            if (intSaturation % 2 == 1) {
                pos.wrap(intSaturation / 2);
                graphics.method_25290(Inspecio.GUI_ICONS_TEXTURE, pos.x, pos.y, 61.0f, 27.0f, 9, 9, 256, 256);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private int getHungerChunks() {
        return this.hunger / 2 + this.hunger % 2;
    }

    private int getSaturation() {
        return (int)(this.saturation * 2.0f);
    }

    private int getSaturationChunks() {
        int intSaturation = this.getSaturation();
        if ((double)(this.saturation * 2.0f - (float)intSaturation) > 0.2) {
            return (int)(this.saturation + 1.0f);
        }
        return (int)this.saturation;
    }

    private int getLines(int chunks) {
        return chunks / 16 + (chunks % 16 > 0 ? 1 : 0);
    }

    private static class ChunkPos {
        private final int originalX;
        private int x;
        private int y;

        public ChunkPos(int x, int y) {
            this.originalX = this.x = x;
            this.y = y;
        }

        public void moveForward() {
            this.x += 9;
        }

        public void wrap(int progress) {
            if (progress != 0 && progress % 16 == 0) {
                this.x = this.originalX;
                this.y += 11;
            }
        }

        public void reset(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

