/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.queerbric.inspecio.api.InventoryProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.tooltip.api.ConvertibleTooltipData;

public class InventoryTooltipComponent
implements ConvertibleTooltipData,
class_5684 {
    private static final class_2960 STATS_ICONS_TEXTURE = new class_2960("textures/gui/container/stats_icons.png");
    private final List<class_1799> inventory;
    private final int columns;
    private final class_1767 color;

    public InventoryTooltipComponent(List<class_1799> inventory, int columns, @Nullable class_1767 color) {
        this.inventory = inventory;
        this.columns = columns == 0 ? inventory.size() / 3 : columns;
        this.color = color;
    }

    public static Optional<class_5632> of(class_1799 stack, boolean compact, @Nullable InventoryProvider.Context context) {
        if (context == null) {
            return Optional.empty();
        }
        List<class_1799> inventory = context.inventory();
        class_2487 blockEntityNbt = class_1747.method_38072((class_1799)stack);
        if (blockEntityNbt == null) {
            return Optional.empty();
        }
        if (inventory.stream().allMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        int columns = Math.min(context.columns(), 9);
        if (compact) {
            ArrayList<class_1799> compactedInventory = new ArrayList<class_1799>();
            inventory.forEach(invStack -> {
                if (invStack.method_7960()) {
                    return;
                }
                compactedInventory.stream().filter(other -> class_1799.method_31577((class_1799)other, (class_1799)invStack)).findFirst().ifPresentOrElse(s -> s.method_7933(invStack.method_7947()), () -> compactedInventory.add((class_1799)invStack));
            });
            inventory = compactedInventory;
            columns = 9;
        }
        return Optional.of(new InventoryTooltipComponent(inventory, columns, context.color()));
    }

    public class_5684 toComponent() {
        return this;
    }

    public int method_32661() {
        int rows = this.inventory.size() / this.getColumns();
        if (this.inventory.size() % this.getColumns() != 0) {
            ++rows;
        }
        return 18 * rows + 3;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getColumns() * 18;
    }

    public void method_32666(class_327 textRenderer, int xOffset, int yOffset, class_332 graphics) {
        int x = 1;
        int y = 1;
        int lines = this.getColumns();
        for (class_1799 stack : this.inventory) {
            InventoryTooltipComponent.drawSlot(graphics, x + xOffset - 1, y + yOffset - 1, 0, this.color == null ? null : this.color.method_7787());
            graphics.method_51427(stack, xOffset + x, yOffset + y);
            graphics.method_51431(textRenderer, stack, xOffset + x, yOffset + y);
            if ((x += 18) < 18 * lines) continue;
            x = 1;
            y += 18;
        }
    }

    public static void drawSlot(class_332 graphics, int x, int y, int z, float[] color) {
        if (color == null) {
            color = new float[]{1.0f, 1.0f, 1.0f};
        }
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        graphics.method_25291(STATS_ICONS_TEXTURE, x, y, z, 0.0f, 0.0f, 18, 18, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getColumns() {
        return this.columns;
    }
}

