/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.SignTooltipMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3879;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5481;
import net.minecraft.class_5599;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7707;
import net.minecraft.class_7761;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_837;
import org.joml.Matrix4f;
import org.quiltmc.qsl.tooltip.api.ConvertibleTooltipData;

public abstract class SignTooltipComponent<M extends class_3879>
implements ConvertibleTooltipData,
class_5684 {
    protected static final class_310 CLIENT = class_310.method_1551();
    private final SignTooltipMode tooltipMode = Inspecio.getConfig().getSignTooltipMode();
    protected final class_4719 type;
    private final class_8242 front;
    private final class_8242 back;
    protected final M model;

    public SignTooltipComponent(class_4719 type, class_8242 front, class_8242 back, M model) {
        this.type = type;
        this.front = front;
        this.back = back;
        this.model = model;
    }

    public static Optional<class_5632> fromItemStack(class_1799 stack) {
        if (!Inspecio.getConfig().getSignTooltipMode().isEnabled()) {
            return Optional.empty();
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_7707) {
            class_7707 signItem = (class_7707)class_17922;
            block = signItem.method_7711();
            class_2487 nbt = class_1747.method_38072((class_1799)stack);
            if (nbt != null) {
                return Optional.ofNullable(SignTooltipComponent.fromTag(class_2478.method_45459((class_2248)block), nbt, true));
            }
        } else {
            block = stack.method_7909();
            if (block instanceof class_1822) {
                class_1822 signItem = (class_1822)block;
                block = signItem.method_7711();
                class_2487 nbt = class_1747.method_38072((class_1799)stack);
                if (nbt != null) {
                    return Optional.ofNullable(SignTooltipComponent.fromTag(class_2478.method_45459((class_2248)block), nbt, false));
                }
            }
        }
        return Optional.empty();
    }

    public static SignTooltipComponent<?> fromTag(class_4719 type, class_2487 nbt, boolean hanging) {
        Optional<Object> front = Optional.empty();
        Optional<Object> back = Optional.empty();
        if (nbt.method_10545("front_text")) {
            front = class_8242.field_43298.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("front_text")).resultOrPartial(s -> {}).map(SignTooltipComponent::parseLines);
        }
        if (nbt.method_10545("back_text")) {
            back = class_8242.field_43298.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("back_text")).resultOrPartial(s -> {}).map(SignTooltipComponent::parseLines);
        }
        if (front.isEmpty() && back.isEmpty()) {
            return null;
        }
        if (hanging) {
            return new HangingSign(type, front.orElse(null), back.orElse(null));
        }
        return new Sign(type, front.orElse(null), back.orElse(null));
    }

    private static class_8242 parseLines(class_8242 text) {
        for (int line = 0; line < 4; ++line) {
            class_2561 unfilteredMessage = text.method_49859(line, false);
            class_2561 filteredMessage = text.method_49859(line, true);
            text = text.method_49858(line, unfilteredMessage, filteredMessage);
        }
        return text;
    }

    public class_5684 toComponent() {
        return this;
    }

    protected boolean shouldShowBack() {
        return this.front == null || this.back != null && class_437.method_25441();
    }

    private class_8242 getText() {
        if (this.shouldShowBack()) {
            return this.back;
        }
        return this.front;
    }

    private class_2561[] getMessages() {
        return this.getText().method_49877(class_310.method_1551().method_33883());
    }

    private class_5481[] getOrderedMessages() {
        return this.getText().method_49868(class_310.method_1551().method_33883(), class_2561::method_30937);
    }

    public int method_32661() {
        if (this.tooltipMode == SignTooltipMode.FANCY) {
            return this.getFancyHeight();
        }
        return this.getMessages().length * 10;
    }

    protected abstract int getFancyHeight();

    public int method_32664(class_327 textRenderer) {
        if (this.tooltipMode == SignTooltipMode.FANCY) {
            return this.getFancyWidth();
        }
        return Arrays.stream(this.getMessages()).map(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).max(Comparator.naturalOrder()).orElse(94);
    }

    protected abstract int getFancyWidth();

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix4f, class_4597.class_4598 immediate) {
        if (this.tooltipMode != SignTooltipMode.FAST) {
            return;
        }
        this.drawTextAt(textRenderer, x, y, matrix4f, immediate, false);
    }

    public void drawTextAt(class_327 textRenderer, int x, int y, Matrix4f matrix4f, class_4597.class_4598 immediate, boolean center) {
        int signColor = this.getText().method_49872().method_16357();
        class_5481[] messages = this.getOrderedMessages();
        if (this.getText().method_49856()) {
            int outlineColor;
            if (this.getText().method_49872() == class_1767.field_7963) {
                outlineColor = -988212;
            } else {
                int r = (int)((double)(signColor >> 24 & 0xFF) * 0.4);
                int g = (int)((double)(signColor >> 16 & 0xFF) * 0.4);
                int b = (int)((double)(signColor >> 8 & 0xFF) * 0.4);
                outlineColor = b >> 8 | g >> 16 | r >> 24;
            }
            for (int i = 0; i < messages.length; ++i) {
                class_5481 text = messages[i];
                float textX = center ? 45.0f - (float)textRenderer.method_30880(text) / 2.0f : (float)x;
                textRenderer.method_37296(text, textX, (float)(y + i * 10), signColor, outlineColor, matrix4f, (class_4597)immediate, 0xF000F0);
            }
        } else {
            if (!center && this.getText().method_49872() == class_1767.field_7963) {
                signColor = -1;
            }
            for (int i = 0; i < messages.length; ++i) {
                class_5481 text = messages[i];
                float textX = center ? 45.0f - (float)textRenderer.method_30880(text) / 2.0f : (float)x;
                textRenderer.method_22942(text, textX, (float)(y + i * 10), signColor, false, matrix4f, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
            }
        }
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 graphics) {
        if (this.tooltipMode != SignTooltipMode.FANCY) {
            return;
        }
        class_308.method_24210();
        class_4587 matrices = graphics.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(x + 2), (float)y, 0.0f);
        matrices.method_22903();
        class_4597.class_4598 immediate = CLIENT.method_22940().method_23000();
        class_4730 spriteIdentifier = this.getSignTextureId();
        class_4588 vertexConsumer = spriteIdentifier != null ? spriteIdentifier.method_24145((class_4597)immediate, arg_0 -> this.model.method_23500(arg_0)) : null;
        this.renderModel(graphics, vertexConsumer);
        immediate.method_22993();
        matrices.method_22909();
        matrices.method_46416(0.0f, (float)this.getTextOffset(), 10.0f);
        class_5481[] messages = this.getOrderedMessages();
        for (int i = 0; i < messages.length; ++i) {
            class_5481 text = messages[i];
            graphics.method_51430(textRenderer, text, (int)(45.0f - (float)textRenderer.method_30880(text) / 2.0f), i * 10, this.getText().method_49872().method_16357(), false);
        }
        matrices.method_22909();
        class_308.method_24211();
    }

    public abstract class_4730 getSignTextureId();

    public abstract void renderModel(class_332 var1, class_4588 var2);

    protected abstract int getTextOffset();

    public static class HangingSign
    extends SignTooltipComponent<class_7761.class_7762> {
        private final class_2960 textureId;

        public HangingSign(class_4719 type, class_8242 front, class_8242 back) {
            super(type, front, back, null);
            this.textureId = new class_2960("textures/gui/hanging_signs/" + this.type.comp_1299() + ".png");
        }

        @Override
        protected int getFancyHeight() {
            return 68;
        }

        @Override
        protected int getFancyWidth() {
            return 94;
        }

        @Override
        public class_4730 getSignTextureId() {
            return null;
        }

        @Override
        public void renderModel(class_332 graphics, class_4588 vertexConsumer) {
            graphics.method_51448().method_22904(44.5, 32.0, 0.0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_51448().method_22905(4.0f, 4.0f, 1.0f);
            graphics.method_25290(this.textureId, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        @Override
        protected int getTextOffset() {
            return 26;
        }
    }

    public static class Sign
    extends SignTooltipComponent<class_837.class_4702> {
        public Sign(class_4719 type, class_8242 front, class_8242 back) {
            super(type, front, back, class_837.method_32157((class_5599)CLIENT.method_31974(), (class_4719)type));
        }

        @Override
        protected int getFancyHeight() {
            return 52;
        }

        @Override
        protected int getFancyWidth() {
            return 94;
        }

        @Override
        public class_4730 getSignTextureId() {
            return class_4722.method_33082((class_4719)this.type);
        }

        @Override
        public void renderModel(class_332 graphics, class_4588 vertexConsumer) {
            graphics.method_51448().method_46416(45.0f, 56.0f, 0.0f);
            if (this.shouldShowBack()) {
                graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            }
            graphics.method_51448().method_22905(65.0f, 65.0f, -65.0f);
            ((class_837.class_4702)this.model).field_21531.field_3665 = false;
            ((class_837.class_4702)this.model).field_27756.field_3665 = true;
            ((class_837.class_4702)this.model).field_27756.method_22698(graphics.method_51448(), vertexConsumer, 0xF000F0, class_4608.field_21444);
        }

        @Override
        protected int getTextOffset() {
            return 4;
        }
    }
}

