/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import io.github.queerbric.inspecio.mixin.EntityAccessor;
import io.github.queerbric.inspecio.tooltip.EntityTooltipComponent;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5632;

public class SpawnEntityTooltipComponent
extends EntityTooltipComponent<InspecioConfig.EntityConfig> {
    private final class_1297 entity;

    public SpawnEntityTooltipComponent(InspecioConfig.EntityConfig config, class_1297 entity) {
        super(config);
        this.entity = entity;
    }

    public static Optional<class_5632> of(class_1299<?> entityType, class_2487 itemNbt) {
        InspecioConfig.EntitiesConfig entitiesConfig = Inspecio.getConfig().getEntitiesConfig();
        if (!entitiesConfig.getSpawnEggConfig().isEnabled() || entityType == null) {
            return Optional.empty();
        }
        class_310 client = class_310.method_1551();
        class_1297 entity = entityType.method_5883((class_1937)client.field_1687);
        if (entity != null) {
            SpawnEntityTooltipComponent.adjustEntity(entity, itemNbt, entitiesConfig);
            class_2487 itemEntityNbt = itemNbt.method_10562("EntityTag").method_10553();
            if (!itemEntityNbt.method_10545("VillagerData")) {
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("profession", "minecraft:none");
                villagerData.method_10569("level", 1);
                villagerData.method_10582("type", "minecraft:plains");
                itemEntityNbt.method_10566("VillagerData", (class_2520)villagerData);
            }
            if (itemEntityNbt.method_10573("id", 8)) {
                String id = itemEntityNbt.method_10558("id");
                if (id.startsWith("minecraft:")) {
                    id = id.substring(10);
                }
                if (id.replaceAll("[^a-z0-9/._-]", "").matches(id)) {
                    class_1297 actualEntity;
                    itemEntityNbt.method_10582("id", id);
                    Optional specifiedEntityType = class_1299.method_17684((class_2487)itemEntityNbt);
                    if (specifiedEntityType.isPresent() && (actualEntity = ((class_1299)specifiedEntityType.get()).method_5883((class_1937)client.field_1687)) != null) {
                        entity = actualEntity;
                        SpawnEntityTooltipComponent.adjustEntity(entity, itemNbt, entitiesConfig);
                    }
                }
            }
            class_2487 entityTag = entity.method_5647(new class_2487());
            UUID uuid = entity.method_5667();
            entityTag.method_10543(itemEntityNbt);
            entity.method_5826(uuid);
            entity.method_5651(entityTag);
            return Optional.of(new SpawnEntityTooltipComponent(entitiesConfig.getSpawnEggConfig(), entity));
        }
        return Optional.empty();
    }

    public static Optional<class_5632> ofMobSpawner(class_1799 stack) {
        InspecioConfig.EntitiesConfig entitiesConfig = Inspecio.getConfig().getEntitiesConfig();
        if (!entitiesConfig.getMobSpawnerConfig().isEnabled()) {
            return Optional.empty();
        }
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null) {
            return Optional.empty();
        }
        class_310 client = class_310.method_1551();
        class_1917 logic = new class_1917(){

            public void method_8273(class_1937 world, class_2338 pos, int eventType) {
            }
        };
        logic.method_8280((class_1937)client.field_1687, client.field_1724.method_24515(), nbt);
        class_1297 entity = logic.method_8283((class_1937)client.field_1687, Inspecio.COMMON_RANDOM, client.field_1724.method_24515());
        if (entity != null) {
            return Optional.of(new SpawnEntityTooltipComponent(entitiesConfig.getMobSpawnerConfig(), entity));
        }
        return Optional.empty();
    }

    @Override
    public int method_32661() {
        return super.method_32661() + 36;
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        return 128;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 graphics) {
        if (this.shouldRender()) {
            class_4587 matrices = graphics.method_51448();
            matrices.method_22903();
            matrices.method_46416(30.0f, 0.0f, 0.0f);
            ((EntityAccessor)this.entity).setTouchingWater(true);
            this.entity.method_18800(1.0, 1.0, 1.0);
            this.renderEntity(matrices, x + 20, y + 20, this.entity, 0, this.config.shouldSpin(), true, 90.0f);
            matrices.method_22909();
        }
    }

    @Override
    protected boolean shouldRender() {
        return this.entity != null;
    }

    @Override
    protected boolean shouldRenderCustomNames() {
        return this.entity.method_16914() && (this.config.shouldAlwaysShowName() || class_437.method_25441());
    }
}

