/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.inspecio.tooltip;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.queerbric.inspecio.HiddenEffectMode;
import io.github.queerbric.inspecio.Inspecio;
import io.github.queerbric.inspecio.InspecioConfig;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.joml.Matrix4f;
import org.quiltmc.qsl.tooltip.api.ConvertibleTooltipData;

public class StatusEffectTooltipComponent
implements ConvertibleTooltipData,
class_5684 {
    private static final class_2960 MYSTERY_TEXTURE = new class_2960("inspecio", "textures/mob_effects/mystery.png");
    private List<class_1293> list = Lists.newArrayList();
    private final FloatList chances = new FloatArrayList();
    private boolean hidden = false;
    private float multiplier;

    public StatusEffectTooltipComponent(List<class_1293> list, float multiplier) {
        this.list = list;
        this.multiplier = multiplier;
    }

    public StatusEffectTooltipComponent(List<Pair<class_1293, Float>> list) {
        for (Pair<class_1293, Float> pair : list) {
            this.list.add((class_1293)pair.getFirst());
            this.chances.add(((Float)pair.getSecond()).floatValue());
        }
        this.multiplier = 1.0f;
    }

    public StatusEffectTooltipComponent() {
        this.hidden = true;
    }

    private class_2561 getHiddenText() {
        InspecioConfig.EffectsConfig effectsConfig = Inspecio.getConfig().getEffectsConfig();
        boolean hiddenMotion = effectsConfig.hasHiddenMotion();
        HiddenEffectMode hiddenEffectMode = effectsConfig.getHiddenEffectMode();
        return hiddenEffectMode.stylize(class_2561.method_43470((String)hiddenEffectMode.getText(true, hiddenMotion)), hiddenMotion);
    }

    private class_2561 getHiddenTime() {
        InspecioConfig.EffectsConfig effectsConfig = Inspecio.getConfig().getEffectsConfig();
        boolean hiddenMotion = effectsConfig.hasHiddenMotion();
        HiddenEffectMode hiddenEffectMode = effectsConfig.getHiddenEffectMode();
        String timeColon = hiddenEffectMode == HiddenEffectMode.ENCHANTMENT && hiddenMotion ? "i" : ":";
        class_5250 minutes = hiddenEffectMode.stylize(class_2561.method_43470((String)hiddenEffectMode.getText(false, hiddenMotion)), hiddenMotion);
        class_5250 seconds = minutes.method_27661();
        return class_2561.method_43473().method_10852((class_2561)minutes).method_10852((class_2561)hiddenEffectMode.stylize(class_2561.method_43470((String)timeColon), false)).method_10852((class_2561)seconds);
    }

    public class_5684 toComponent() {
        return this;
    }

    public int method_32661() {
        if (this.hidden) {
            return 20;
        }
        return this.list.size() * 20;
    }

    public int method_32664(class_327 textRenderer) {
        if (this.hidden) {
            return 26 + textRenderer.method_27525((class_5348)this.getHiddenText());
        }
        int max = 64;
        for (int i = 0; i < this.list.size(); ++i) {
            class_1293 statusEffectInstance = this.list.get(i);
            String statusEffectName = this.getStatusEffectName(statusEffectInstance);
            if (statusEffectInstance.method_5584() > 1) {
                class_2561 duration = this.getDuration(i, statusEffectInstance);
                max = Math.max(max, 26 + textRenderer.method_27525((class_5348)duration));
            } else if (this.chances.size() > i && this.chances.getFloat(i) < 1.0f) {
                String string2 = (int)(this.chances.getFloat(i) * 100.0f) + "%";
                max = Math.max(max, 26 + textRenderer.method_1727(string2));
            }
            max = Math.max(max, 26 + textRenderer.method_1727(statusEffectName));
        }
        return max;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 graphics) {
        if (this.hidden) {
            graphics.method_25290(MYSTERY_TEXTURE, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
        } else {
            class_310 client = class_310.method_1551();
            class_4074 statusEffectSpriteManager = client.method_18505();
            for (int i = 0; i < this.list.size(); ++i) {
                class_1293 statusEffectInstance = this.list.get(i);
                class_1291 statusEffect = statusEffectInstance.method_5579();
                class_1058 sprite = statusEffectSpriteManager.method_18663(statusEffect);
                graphics.method_25298(x, y + i * 20, 0, 18, 18, sprite);
            }
        }
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f model, class_4597.class_4598 immediate) {
        if (this.hidden) {
            textRenderer.method_30882(this.getHiddenText(), (float)(x + 24), (float)y, 0x7F7F7F, true, model, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
            textRenderer.method_30882(this.getHiddenTime(), (float)(x + 24), (float)(y + 10), 0x7F7F7F, true, model, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                class_1293 statusEffectInstance = this.list.get(i);
                String statusEffectName = this.getStatusEffectName(statusEffectInstance);
                int off = 0;
                if (statusEffectInstance.method_5584() <= 1) {
                    off += 5;
                }
                Integer color = statusEffectInstance.method_5579().method_18792().method_18793().method_532();
                textRenderer.method_27521(statusEffectName, (float)(x + 24), (float)(y + i * 20 + off), color != null ? color : 0xFFFFFF, true, model, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
                if (statusEffectInstance.method_5584() > 1) {
                    class_2561 duration = this.getDuration(i, statusEffectInstance);
                    textRenderer.method_30882(duration, (float)(x + 24), (float)(y + i * 20 + 10), 0x7F7F7F, true, model, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
                    continue;
                }
                if (this.chances.size() <= i || !(this.chances.getFloat(i) < 1.0f)) continue;
                String chance = (int)(this.chances.getFloat(i) * 100.0f) + "%";
                textRenderer.method_27521(chance, (float)(x + 24), (float)(y + i * 20 + 10), 0x7F7F7F, true, model, (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
            }
        }
    }

    private String getStatusEffectName(class_1293 statusEffectInstance) {
        Object statusEffectName = class_1074.method_4662((String)statusEffectInstance.method_5579().method_5567(), (Object[])new Object[0]);
        if (statusEffectInstance.method_5578() >= 1 && statusEffectInstance.method_5578() <= 9) {
            statusEffectName = (String)statusEffectName + " " + class_1074.method_4662((String)("enchantment.level." + (statusEffectInstance.method_5578() + 1)), (Object[])new Object[0]);
        }
        return statusEffectName;
    }

    private class_2561 getDuration(int index, class_1293 statusEffect) {
        class_2561 duration = class_1292.method_5577((class_1293)statusEffect, (float)this.multiplier);
        if (this.chances.size() > index && this.chances.getFloat(index) < 1.0f) {
            duration = duration.method_27661().method_27693(" - " + (int)(this.chances.getFloat(index) * 100.0f) + "%");
        }
        return duration;
    }
}

