/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Point;
import me.shedaniel.slightguimodifications.config.Cts;
import me.shedaniel.slightguimodifications.config.SlightGuiModificationsConfig;
import me.shedaniel.slightguimodifications.gui.MenuEntry;
import me.shedaniel.slightguimodifications.gui.MenuWidget;
import me.shedaniel.slightguimodifications.gui.TextMenuEntry;
import me.shedaniel.slightguimodifications.gui.cts.CtsRegistry;
import me.shedaniel.slightguimodifications.listener.AnimationListener;
import me.shedaniel.slightguimodifications.listener.MenuWidgetListener;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_443;
import net.minecraft.class_446;
import net.minecraft.class_458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlightGuiModifications
implements ClientModInitializer {
    public static float backgroundTint = 0.0f;
    public static final class_2960 TEXT_FIELD_TEXTURE = new class_2960("textures/gui/text_field.png");
    public static float lastAlpha = -1.0f;
    public static boolean prettyScreenshots = false;
    public static class_1043 prettyScreenshotTexture = null;
    public static class_1043 lastPrettyScreenshotTexture = null;
    public static class_2960 prettyScreenshotTextureId = null;
    public static class_2960 lastPrettyScreenshotTextureId = null;
    public static long prettyScreenshotTime = -1L;
    public static long backgroundTime = -1L;
    public static final Logger LOGGER = LogManager.getLogger((String)"SlightGuiModifications");
    public static final LazyResettable<Cts> CTS = new LazyResettable(Cts::new);
    private static boolean configInitialized = false;

    public static float[] getColorObj() {
        return RenderSystem.getShaderColor();
    }

    public static float getColorRed(float[] colorObj) {
        return colorObj[0];
    }

    public static float getColorGreen(float[] colorObj) {
        return colorObj[1];
    }

    public static float getColorBlue(float[] colorObj) {
        return colorObj[2];
    }

    public static float getColorAlpha(float[] colorObj) {
        return colorObj[3];
    }

    public static void setAlpha(float alpha) {
        if (lastAlpha >= 0.0f) {
            new IllegalStateException().printStackTrace();
        }
        float[] colorObj = SlightGuiModifications.getColorObj();
        float colorRed = SlightGuiModifications.getColorRed(colorObj);
        float colorGreen = SlightGuiModifications.getColorGreen(colorObj);
        float colorBlue = SlightGuiModifications.getColorBlue(colorObj);
        float colorAlpha = SlightGuiModifications.getColorAlpha(colorObj);
        lastAlpha = colorAlpha == -1.0f ? 1.0f : class_3532.method_15363((float)colorAlpha, (float)0.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)(colorRed == -1.0f ? 1.0f : colorRed), (float)(colorGreen == -1.0f ? 1.0f : colorGreen), (float)(colorBlue == -1.0f ? 1.0f : colorBlue), (float)(lastAlpha * alpha));
    }

    public static void restoreAlpha() {
        if (lastAlpha < 0.0f) {
            return;
        }
        float[] colorObj = SlightGuiModifications.getColorObj();
        float colorRed = SlightGuiModifications.getColorRed(colorObj);
        float colorGreen = SlightGuiModifications.getColorGreen(colorObj);
        float colorBlue = SlightGuiModifications.getColorBlue(colorObj);
        RenderSystem.setShaderColor((float)(colorRed == -1.0f ? 1.0f : colorRed), (float)(colorGreen == -1.0f ? 1.0f : colorGreen), (float)(colorBlue == -1.0f ? 1.0f : colorBlue), (float)lastAlpha);
        lastAlpha = -1.0f;
    }

    public static float ease(float t) {
        return (float)(1.0 * (-Math.pow(2.0, -10.0f * t / 1.0f) + 1.0));
    }

    public static int reverseYAnimation(int y) {
        return y - SlightGuiModifications.applyYAnimation(y) + y;
    }

    public static int applyYAnimation(int y) {
        float alpha;
        if (!RenderSystem.isOnRenderThread()) {
            return y;
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof AnimationListener && (alpha = ((AnimationListener)screen).slightguimodifications_getEasedYOffset()) >= 0.0f) {
            return y + (int)((1.0f - alpha) * (float)screen.field_22790 / 2.0f);
        }
        return y;
    }

    public static int applyMouseYAnimation(int y) {
        float alpha;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof AnimationListener && (alpha = ((AnimationListener)screen).slightguimodifications_getEasedMouseY()) >= 0.0f) {
            return y - (int)((1.0f - alpha) * (float)screen.field_22790 / 2.0f);
        }
        return y;
    }

    public static double reverseYAnimation(double y) {
        return y - SlightGuiModifications.applyYAnimation(y) + y;
    }

    public static double applyYAnimation(double y) {
        float alpha;
        if (!RenderSystem.isOnRenderThread()) {
            return y;
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof AnimationListener && (alpha = ((AnimationListener)screen).slightguimodifications_getEasedYOffset()) >= 0.0f) {
            return y + (double)((int)((1.0f - alpha) * (float)screen.field_22790 / 2.0f));
        }
        return y;
    }

    public static int applyAlphaAnimation(int alpha) {
        float animatedAlpha;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof AnimationListener && (animatedAlpha = ((AnimationListener)screen).slightguimodifications_getAlpha()) >= 0.0f) {
            return (int)(animatedAlpha * (float)alpha);
        }
        return alpha;
    }

    public static void startPrettyScreenshot(class_1011 cloneImage) {
        if (prettyScreenshotTexture != null) {
            lastPrettyScreenshotTexture = prettyScreenshotTexture;
            lastPrettyScreenshotTextureId = prettyScreenshotTextureId;
        }
        prettyScreenshotTexture = null;
        prettyScreenshotTextureId = null;
        prettyScreenshotTime = -1L;
        if (cloneImage != null) {
            prettyScreenshotTexture = new class_1043(cloneImage);
            prettyScreenshotTextureId = class_310.method_1551().method_1531().method_4617("slight-gui-modifications-pretty-screenshots", prettyScreenshotTexture);
        }
    }

    public void onInitializeClient() {
        SlightGuiModifications.getGuiConfig();
        AutoConfig.getGuiRegistry(SlightGuiModificationsConfig.class).registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ConfigEntryBuilder.create().startIntSlider((class_2561)class_2561.method_43471((String)i13n), (int)(Math.max(1.0, (Double)Utils.getUnsafely((Field)field, (Object)config, (Object)0.0)) * 100.0), 100, (class_310.method_1551().method_22683().method_4476(0, false) + 4) * 100).setDefaultValue(0).setTextGetter(integer -> {
            if (integer <= 100) {
                return class_2561.method_43471((String)(i13n + ".text.disabled"));
            }
            return class_2561.method_43469((String)(i13n + ".text"), (Object[])new Object[]{(double)integer.intValue() / 100.0});
        }).setSaveConsumer(integer -> Utils.setUnsafely((Field)field, (Object)config, (Object)((double)integer.intValue() / 100.0))).build()), new Class[]{SlightGuiModificationsConfig.Gui.ScaleSlider.class});
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register((client, screen, mouseX, mouseY, mouseButton) -> {
            Optional<class_4068> optionsButton;
            if (((MenuWidgetListener)screen).getMenu() != null) {
                if (!((MenuWidgetListener)screen).getMenu().method_25402(mouseX, mouseY, mouseButton)) {
                    ((MenuWidgetListener)screen).removeMenu();
                }
                return EventResult.interruptTrue();
            }
            if (SlightGuiModifications.getGuiConfig().rightClickActions && mouseButton == 1 && (screen instanceof class_433 || screen instanceof class_442) && (optionsButton = ScreenHooks.getRenderables((class_437)screen).stream().filter(button -> {
                class_339 widget;
                return button instanceof class_339 && (widget = (class_339)button).method_25369().getString().equals(class_1074.method_4662((String)"menu.options", (Object[])new Object[0]));
            }).findFirst()).isPresent() && ((class_339)optionsButton.get()).method_25405(mouseX, mouseY)) {
                ((MenuWidgetListener)screen).applyMenu(new MenuWidget(new Point(mouseX + 2.0, mouseY + 2.0), (Collection<MenuEntry>)ImmutableList.of((Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"options.video", (Object[])new Object[0]).replace("...", ""), () -> {
                    ((MenuWidgetListener)screen).removeMenu();
                    client.method_1507((class_437)new class_446(screen, client.field_1690));
                })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"options.controls", (Object[])new Object[0]).replace("...", ""), () -> {
                    ((MenuWidgetListener)screen).removeMenu();
                    client.method_1507((class_437)new class_458(screen, client.field_1690));
                })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"options.sounds", (Object[])new Object[0]).replace("...", ""), () -> {
                    ((MenuWidgetListener)screen).removeMenu();
                    client.method_1507((class_437)new class_443(screen, client.field_1690));
                })))));
            }
            return EventResult.pass();
        });
        SlightGuiModifications.reloadCtsAsync();
        RRPCallback.AFTER_VANILLA.register(packs -> {
            Path sliderHovered;
            Path slider;
            Path textField;
            RuntimeResourcePack pack = RuntimeResourcePack.create((String)"slightguimodifications:cts_textures");
            Path buttons = FabricLoader.getInstance().getConfigDir().resolve("slightguimodifications/buttons.png");
            if (Files.exists(buttons, new LinkOption[0])) {
                try {
                    pack.addAsset(new class_2960("minecraft:textures/gui/widgets.png"), Files.readAllBytes(buttons));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(textField = FabricLoader.getInstance().getConfigDir().resolve("slightguimodifications/text_field.png"), new LinkOption[0])) {
                try {
                    pack.addAsset(new class_2960("minecraft:textures/gui/text_field.png"), Files.readAllBytes(textField));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(slider = FabricLoader.getInstance().getConfigDir().resolve("slightguimodifications/slider.png"), new LinkOption[0])) {
                try {
                    pack.addAsset(new class_2960("slightguimodifications:textures/gui/slider.png"), Files.readAllBytes(slider));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(sliderHovered = FabricLoader.getInstance().getConfigDir().resolve("slightguimodifications/slider_hovered.png"), new LinkOption[0])) {
                try {
                    pack.addAsset(new class_2960("slightguimodifications:textures/gui/slider_hovered.png"), Files.readAllBytes(sliderHovered));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            packs.add(pack);
        });
    }

    public static void reloadCtsAsync() {
        CtsRegistry.loadScriptsAsync();
    }

    public static void reloadCts() {
        CtsRegistry.loadScripts();
    }

    public static void openModMenu() {
        if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            try {
                Class.forName("me.shedaniel.slightguimodifications.gui.cts.ModMenuCompat").getDeclaredMethod("openModMenu", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getModMenuText() {
        try {
            return (String)Class.forName("me.shedaniel.slightguimodifications.gui.cts.ModMenuCompat").getDeclaredMethod("getModMenuText", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static double bezierEase(double value, double[] points) {
        return SlightGuiModifications.bezierEase(value, points[0], points[1], points[2], points[3]);
    }

    public static float bezierEase(float value, double[] points) {
        return (float)SlightGuiModifications.bezierEase(value, points[0], points[1], points[2], points[3]);
    }

    private static double bezierEase(double value, double point1, double point2, double point3, double point4) {
        return point1 * Math.pow(1.0 - value, 3.0) + 3.0 * point2 * Math.pow(1.0 - value, 2.0) * value + 3.0 * point2 * (1.0 - value) * Math.pow(value, 2.0) + point4 * Math.pow(value, 3.0);
    }

    public static SlightGuiModificationsConfig.Gui getGuiConfig() {
        if (!configInitialized) {
            AutoConfig.register(SlightGuiModificationsConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
            configInitialized = true;
        }
        return ((SlightGuiModificationsConfig)AutoConfig.getConfigHolder(SlightGuiModificationsConfig.class).getConfig()).gui;
    }

    public static Cts getCtsConfig() {
        return (Cts)CTS.get();
    }

    public static void resetCts() {
        CTS.reset();
    }

    public static float getSpeed() {
        return SlightGuiModifications.getGuiConfig().openingAnimation.fluidAnimationDuration;
    }

    public static class_437 getConfigScreen(class_437 parent) {
        ConfigScreenProvider supplier = (ConfigScreenProvider)AutoConfig.getConfigScreen(SlightGuiModificationsConfig.class, (class_437)parent);
        supplier.setBuildFunction(builder -> {
            Runnable runnable = builder.getSavingRunnable();
            builder.setSavingRunnable(() -> {
                runnable.run();
                class_310.method_1551().method_15993();
            });
            builder.setAfterInitConsumer(screen -> ScreenHooks.addRenderableWidget((class_437)screen, (class_339)new class_4185(screen.field_22789 - 104, 4, 100, 20, (class_2561)class_2561.method_43471((String)"text.slightguimodifications.reloadCts"), button -> {
                SlightGuiModifications.resetCts();
                SlightGuiModifications.reloadCts();
            }, Supplier::get){}));
            return builder.build();
        });
        return supplier.get();
    }
}

