/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications.config;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.slightguimodifications.SlightGuiModifications;
import me.shedaniel.slightguimodifications.gui.cts.elements.WidgetElement;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;

public class Cts {
    @Comment(value="Whether this category is enabled.")
    public boolean enabled = false;
    @ConfigEntry.Gui.CollapsibleObject
    public SplashText splashText = new SplashText();
    public boolean removeMinecraftEditionTexture = false;
    public boolean removeMinecraftLogoTexture = false;
    public boolean clearAllButtons = false;
    public boolean clearAllLabels = false;
    public List<WidgetElement> widgetElements = new CopyOnWriteArrayList<WidgetElement>();
    public List<BackgroundInfo> backgroundInfos = new ArrayList<DefaultBackgroundInfo>(Collections.singletonList(new DefaultBackgroundInfo()));
    public long backgroundStayLength = 10000L;
    public long backgroundFadeLength = 1000L;
    public boolean renderGradientShade = true;

    public static class SplashText {
        @Comment(value="Whether this module is enabled.")
        public boolean enabled = false;
        public boolean removeSplashes = false;
        public boolean customSplashesEnabled = false;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public CustomSplashesApplyMode customSplashesApplyMode = CustomSplashesApplyMode.OVERRIDE;
        public List<String> customSplashes = Lists.newArrayList();

        public static enum CustomSplashesApplyMode implements SelectionListEntry.Translatable
        {
            APPEND,
            OVERRIDE;


            @NotNull
            public String getKey() {
                return "text.autoconfig.slightguimodifications.option.cts.splashText.customSplashesApplyMode." + this.name().toLowerCase(Locale.ROOT);
            }
        }
    }

    public static class DefaultBackgroundInfo
    extends BackgroundInfo {
        @Override
        public void render(class_332 graphics, class_442 screen, float delta, float alpha) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_442.field_17775);
            screen.field_2585.method_3317(delta, class_3532.method_15363((float)(alpha * this.getAlpha()), (float)0.0f, (float)1.0f));
        }
    }

    public static interface TextureProvider {
        public class_2960 provide();
    }

    public static class TextureProvidedBackgroundInfo
    extends BackgroundInfo {
        private final Supplier<class_2960> provider = Suppliers.memoize(provider::provide);

        public TextureProvidedBackgroundInfo(TextureProvider provider) {
        }

        @Override
        public void render(class_332 graphics, class_442 screen, float delta, float alpha) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
            graphics.method_25293(this.provider.get(), 0, 0, screen.field_22789, screen.field_22790, 0.0f, 0.0f, 16, 128, 16, 128);
        }
    }

    public static abstract class BackgroundInfo {
        public final int index() {
            return SlightGuiModifications.getCtsConfig().backgroundInfos.indexOf(this);
        }

        public final float getAlpha() {
            Cts ctsConfig = SlightGuiModifications.getCtsConfig();
            if (ctsConfig.backgroundInfos.size() == 1) {
                return 1.0f;
            }
            int index = this.index();
            long fullIterationLength = ctsConfig.backgroundStayLength * (long)ctsConfig.backgroundInfos.size();
            long timePast = (class_156.method_658() - SlightGuiModifications.backgroundTime) % fullIterationLength;
            if (timePast >= (long)index * ctsConfig.backgroundStayLength && timePast < (long)(index + 1) * ctsConfig.backgroundStayLength) {
                return 1.0f;
            }
            if (timePast >= (long)(index + 1) * ctsConfig.backgroundStayLength && timePast < (long)(index + 1) * ctsConfig.backgroundStayLength + ctsConfig.backgroundFadeLength) {
                return class_3532.method_15363((float)((float)((long)(index + 1) * ctsConfig.backgroundStayLength + ctsConfig.backgroundFadeLength - timePast) / (float)ctsConfig.backgroundFadeLength), (float)0.0f, (float)1.0f);
            }
            if (index == ctsConfig.backgroundInfos.size() - 1 && timePast <= ctsConfig.backgroundFadeLength) {
                return class_3532.method_15363((float)((float)(ctsConfig.backgroundFadeLength - timePast) / (float)ctsConfig.backgroundFadeLength), (float)0.0f, (float)1.0f);
            }
            return 0.0f;
        }

        public abstract void render(class_332 var1, class_442 var2, float var3, float var4);
    }
}

