/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications.gui;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.slightguimodifications.gui.MenuEntry;
import me.shedaniel.slightguimodifications.gui.SubMenuEntry;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.jetbrains.annotations.NotNull;

public class MenuWidget
extends class_362
implements class_4068 {
    public final Point menuStartPoint;
    private final List<MenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (MenuEntry entry : MenuWidget.this.method_25396()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return MenuWidget.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return MenuWidget.this.hasScrollBar();
        }
    };

    public MenuWidget(Point menuStartPoint, Collection<MenuEntry> entries) {
        this.buildEntries(entries);
        if (menuStartPoint.y + this.scrolling.getMaxScrollHeight() >= class_310.method_1551().field_1755.field_22790 - 5) {
            menuStartPoint.y -= this.scrolling.getMaxScrollHeight();
        }
        this.menuStartPoint = menuStartPoint;
    }

    private void buildEntries(Collection<MenuEntry> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        for (MenuEntry entry : this.entries) {
            entry.parent = this;
        }
    }

    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight() + 2);
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.menuStartPoint.x + 1, this.menuStartPoint.y + 1, this.getMaxEntryWidth() + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight());
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight();
    }

    public int getInnerHeight() {
        return Math.min(this.scrolling.getMaxScrollHeight(), class_310.method_1551().field_1755.field_22790 - 5 - this.menuStartPoint.y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (MenuEntry entry : this.method_25396()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        graphics.method_25294(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -6250336);
        graphics.method_25294(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), -16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        MenuEntry focused = this.method_25399() instanceof MenuEntry ? (MenuEntry)this.method_25399() : null;
        int currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        for (MenuEntry child : this.method_25396()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.scrolling.getScissorBounds()));
        for (MenuEntry child : this.method_25396()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.method_25394(graphics, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.method_25395((class_364)focused);
        this.scrolling.renderScrollBar(graphics);
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (MenuEntry child : this.method_25396()) {
            if (!(child instanceof SubMenuEntry) || !child.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public List<MenuEntry> method_25396() {
        return this.entries;
    }
}

