/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.slightguimodifications.mixin.rei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.shedaniel.clothconfig2.api.TickableWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.slightguimodifications.SlightGuiModifications;
import me.shedaniel.slightguimodifications.config.SlightGuiModificationsConfig;
import me.shedaniel.slightguimodifications.gui.MenuEntry;
import me.shedaniel.slightguimodifications.gui.MenuWidget;
import me.shedaniel.slightguimodifications.gui.TextMenuEntry;
import me.shedaniel.slightguimodifications.listener.MenuWidgetListener;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextFieldWidget.class})
public abstract class MixinREITextFieldWidget
extends WidgetWithBounds
implements TickableWidget {
    @Shadow(remap=false)
    private Rectangle bounds;
    @Shadow(remap=false)
    protected boolean editable;
    @Shadow(remap=false)
    protected int cursorPos;
    @Shadow(remap=false)
    protected int highlightPos;
    @Shadow(remap=false)
    private boolean focusUnlocked;

    @Shadow(remap=false)
    public abstract boolean hasBorder();

    @Shadow(remap=false)
    public abstract boolean isVisible();

    @Shadow(remap=false)
    public abstract boolean method_25370();

    @Shadow(remap=false)
    public abstract void moveCursorToEnd();

    @Shadow(remap=false)
    public abstract void setHighlightPos(int var1);

    @Shadow(remap=false)
    public abstract void addText(String var1);

    @Shadow(remap=false)
    public abstract String getSelectedText();

    @Shadow(remap=false)
    public abstract void method_25365(boolean var1);

    @Shadow(remap=false)
    public abstract void setText(String var1);

    @Inject(method={"renderBorder"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void renderBorder(class_332 graphics, CallbackInfo ci) {
        boolean border = this.hasBorder();
        if (border && SlightGuiModifications.getGuiConfig().textFieldModifications.enabled && SlightGuiModifications.getGuiConfig().textFieldModifications.backgroundMode == SlightGuiModificationsConfig.Gui.TextFieldModifications.BackgroundMode.TEXTURE) {
            this.renderTextureBorder(graphics);
            ci.cancel();
        }
    }

    @Unique
    private void renderTextureBorder(class_332 graphics) {
        class_2960 texture = SlightGuiModifications.TEXT_FIELD_TEXTURE;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        graphics.method_25291(texture, x - 1, y - 1, 0, 0.0f, 0.0f, 8, 8, 256, 256);
        graphics.method_25291(texture, x + width - 7, y - 1, 0, 248.0f, 0.0f, 8, 8, 256, 256);
        graphics.method_25291(texture, x - 1, y + height - 7, 0, 0.0f, 248.0f, 8, 8, 256, 256);
        graphics.method_25291(texture, x + width - 7, y + height - 7, 0, 248.0f, 248.0f, 8, 8, 256, 256);
        graphics.method_25295(texture, x + 7, x + width - 7, y - 1, y + 7, 0, 0.03125f, 0.96875f, 0.0f, 0.03125f);
        graphics.method_25295(texture, x + 7, x + width - 7, y + height - 7, y + height + 1, 0, 0.03125f, 0.96875f, 0.96875f, 1.0f);
        graphics.method_25295(texture, x - 1, x + 7, y + 7, y + height - 7, 0, 0.0f, 0.03125f, 0.03125f, 0.96875f);
        graphics.method_25295(texture, x + width - 7, x + width + 1, y + 7, y + height - 7, 0, 0.96875f, 1.0f, 0.03125f, 0.96875f);
        graphics.method_25295(texture, x + 7, x + width - 7, y + 7, y + height - 7, 0, 0.03125f, 0.96875f, 0.03125f, 0.96875f);
    }

    @ModifyArg(method={"renderBorder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=1), index=4)
    private int modifyBorderColor(int color) {
        return SlightGuiModifications.getGuiConfig().textFieldModifications.enabled ? SlightGuiModifications.getGuiConfig().textFieldModifications.borderColor | 0xFF000000 : color;
    }

    @ModifyArg(method={"renderBorder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0), index=4)
    private int modifyBackgroundColor(int color) {
        return SlightGuiModifications.getGuiConfig().textFieldModifications.enabled ? SlightGuiModifications.getGuiConfig().textFieldModifications.backgroundColor | 0xFF000000 : color;
    }

    @ModifyArg(method={"renderBorder"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=2), index=4)
    private int modifyBackgroundColor2(int color) {
        return SlightGuiModifications.getGuiConfig().textFieldModifications.enabled ? SlightGuiModifications.getGuiConfig().textFieldModifications.backgroundColor | 0xFF000000 : color;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void preMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.getBounds().contains(mouseX, mouseY) && this.isVisible() && SlightGuiModifications.getGuiConfig().textFieldModifications.rightClickActions && button == 1 && !(this instanceof OverlaySearchField)) {
            boolean boolean_1;
            if (this.editable) {
                if (this.cursorPos - this.highlightPos != 0) {
                    ((MenuWidgetListener)class_310.method_1551().field_1755).applyMenu(new MenuWidget(new Point(mouseX + 2.0, mouseY + 2.0), this.createSelectingMenu()));
                } else {
                    ((MenuWidgetListener)class_310.method_1551().field_1755).applyMenu(new MenuWidget(new Point(mouseX + 2.0, mouseY + 2.0), this.createNonSelectingMenu()));
                }
            } else if (this.cursorPos - this.highlightPos != 0) {
                ((MenuWidgetListener)class_310.method_1551().field_1755).applyMenu(new MenuWidget(new Point(mouseX + 2.0, mouseY + 2.0), this.createSelectingNotEditableMenu()));
            } else {
                ((MenuWidgetListener)class_310.method_1551().field_1755).applyMenu(new MenuWidget(new Point(mouseX + 2.0, mouseY + 2.0), this.createNonSelectingNotEditableMenu()));
            }
            cir.setReturnValue((Object)true);
            boolean bl = boolean_1 = mouseX >= (double)this.bounds.x && mouseX < (double)(this.bounds.x + this.bounds.width) && mouseY >= (double)this.bounds.y && mouseY < (double)(this.bounds.y + this.bounds.height);
            if (this.focusUnlocked) {
                this.method_25365(boolean_1);
            }
        }
    }

    @Unique
    private void removeSelfMenu() {
        ((MenuWidgetListener)class_310.method_1551().field_1755).removeMenu();
    }

    @Unique
    private List<MenuEntry> createNonSelectingNotEditableMenu() {
        return ImmutableList.of((Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.selectAll", (Object[])new Object[0]), () -> {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            this.removeSelfMenu();
        })));
    }

    @Unique
    private List<MenuEntry> createNonSelectingMenu() {
        return ImmutableList.of((Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.paste", (Object[])new Object[0]), () -> {
            if (this.editable) {
                this.addText(class_310.method_1551().field_1774.method_1460());
            }
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.selectAll", (Object[])new Object[0]), () -> {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.clearAll", (Object[])new Object[0]), () -> {
            this.setText("");
            this.removeSelfMenu();
        })));
    }

    @Unique
    private List<MenuEntry> createSelectingNotEditableMenu() {
        return ImmutableList.of((Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.copy", (Object[])new Object[0]), () -> {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.selectAll", (Object[])new Object[0]), () -> {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            this.removeSelfMenu();
        })));
    }

    @Unique
    private List<MenuEntry> createSelectingMenu() {
        return ImmutableList.of((Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.copy", (Object[])new Object[0]), () -> {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.cut", (Object[])new Object[0]), () -> {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            if (this.editable) {
                this.addText("");
            }
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.paste", (Object[])new Object[0]), () -> {
            if (this.editable) {
                this.addText(class_310.method_1551().field_1774.method_1460());
            }
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.selectAll", (Object[])new Object[0]), () -> {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            this.removeSelfMenu();
        })), (Object)((Object)new TextMenuEntry(class_1074.method_4662((String)"text.slightguimodifications.clearAll", (Object[])new Object[0]), () -> {
            this.setText("");
            this.removeSelfMenu();
        })));
    }
}

