/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.metadata.WidgetSize;
import org.quiltmc.config.api.Config;
import org.quiltmc.config.api.WrappedConfig;
import org.quiltmc.config.api.annotations.Comment;
import org.quiltmc.config.api.annotations.FloatRange;
import org.quiltmc.config.api.annotations.IntegerRange;

public class OkZoomerConfig
extends WrappedConfig {
    @Comment(value={"Contains the main zoom features."})
    public final FeaturesConfig features = new FeaturesConfig();
    @Comment(value={"Contains precise configuration of the zoom."})
    public final ValuesConfig values = new ValuesConfig();
    @Comment(value={"Contains options that are unlikely to be changed from the defaults."})
    public final TweaksConfig tweaks = new TweaksConfig();

    public class FeaturesConfig
    implements Config.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Defines the cinematic camera while zooming.\n\"OFF\" disables the cinematic camera.\n\"VANILLA\" uses Vanilla's cinematic camera.\n\"MULTIPLIED\" is a multiplied variant of \"VANILLA\".\n"})
        public final ConfigEnums.CinematicCameraOptions cinematic_camera = ConfigEnums.CinematicCameraOptions.OFF;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Reduces the mouse sensitivity when zooming."})
        public final boolean reduce_sensitivity = true;
        @WidgetSize(value=WidgetSize.Size.FULL)
        @Comment(value={"Adds transitions between zooms.\n\"OFF\" disables transitions.\n\"SMOOTH\" replicates Vanilla's dynamic FOV.\n\"LINEAR\" removes the smoothiness.\n"})
        public final ConfigEnums.ZoomTransitionOptions zoom_transition = ConfigEnums.ZoomTransitionOptions.SMOOTH;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The behavior of the zoom key.\n\"HOLD\" needs the zoom key to be hold.\n\"TOGGLE\" has the zoom key toggle the zoom.\n\"PERSISTENT\" makes the zoom permanent.\n"})
        public final ConfigEnums.ZoomModes zoom_mode = ConfigEnums.ZoomModes.HOLD;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows to increase or decrease zoom by scrolling."})
        public final boolean zoom_scrolling = true;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds zoom manipulation keys along with the zoom key."})
        public final boolean extra_key_binds = true;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds an overlay in the screen during zoom.\n\"VIGNETTE\" uses a vignette as the overlay.\n\"SPYGLASS\" uses the spyglass overlay with the vignette texture.\nThe vignette texture can be found at: assets/ok_zoomer/textures/misc/zoom_overlay.png\n"})
        public final ConfigEnums.ZoomOverlays zoom_overlay = ConfigEnums.ZoomOverlays.OFF;
        @WidgetSize(value=WidgetSize.Size.FULL)
        @Comment(value={"Determines how the zoom will depend on the spyglass.\n\"REQUIRE_ITEM\" will make zooming require a spyglass.\n\"REPLACE_ZOOM\" will replace spyglass's zoom with Ok Zoomer's zoom.\n\"BOTH\" will apply both options at the same time.\nThe \"REQUIRE_ITEM\" option is configurable through the ok_zoomer:zoom_dependencies item tag.\n"})
        public final ConfigEnums.SpyglassDependency spyglass_dependency = ConfigEnums.SpyglassDependency.OFF;
    }

    public class ValuesConfig
    implements Config.Section {
        @WidgetSize(value=WidgetSize.Size.FULL)
        @Comment(value={"The divisor applied to the FOV when zooming."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final double zoom_divisor = 4.0;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The minimum value that you can scroll down."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final double minimum_zoom_divisor = 1.0;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The maximum value that you can scroll down."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final double maximum_zoom_divisor = 50.0;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The number of steps between the zoom divisor and the maximum zoom divisor.\nUsed by zoom scrolling.\n"})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        public final int upper_scroll_steps = 10;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The number of steps between the zoom divisor and the minimum zoom divisor.\nUsed by zoom scrolling.\n"})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        public final int lower_scroll_steps = 5;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The multiplier used for smooth transitions."})
        @FloatRange(min=2.2250738585072014E-308, max=1.0)
        public final double smooth_multiplier = 0.75;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The multiplier used for the multiplied cinematic camera."})
        @FloatRange(min=2.2250738585072014E-308, max=32.0)
        public final double cinematic_multiplier = 4.0;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The minimum value which the linear transition step can reach."})
        @FloatRange(min=0.0, max=1.7976931348623157E308)
        public final double minimum_linear_step = 0.125;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The maximum value which the linear transition step can reach."})
        @FloatRange(min=0.0, max=1.7976931348623157E308)
        public final double maximum_linear_step = 0.25;
    }

    public class TweaksConfig
    implements Config.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows for resetting the zoom with the middle mouse button."})
        public final boolean reset_zoom_with_mouse = true;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the current zoom divisor is forgotten once zooming is done."})
        public final boolean forget_zoom_divisor = true;
        @WidgetSize(value=WidgetSize.Size.FULL)
        @Comment(value={"If pressed, the \"Save Toolbar Activator\" keybind will be unbound if there's a conflict with the zoom key."})
        public final boolean unbind_conflicting_key = true;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the spyglass overlay texture is used instead of Ok Zoomer's overlay texture."})
        public final boolean use_spyglass_texture = false;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the zoom will use spyglass sounds on zooming in and out."})
        public final boolean use_spyglass_sounds = false;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Shows toasts when the server imposes a restriction."})
        public final boolean show_restriction_toasts = true;
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Prints a random owo in the console when the game starts. Enabled by default until full release."})
        public final boolean print_owo_on_start = true;
    }
}

