/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config;

import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ContainingMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.overlays.SpyglassZoomOverlay;
import io.github.ennuil.libzoomer.api.transitions.InstantTransitionMode;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfig;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import io.github.ennuil.ok_zoomer.zoom.LinearTransitionMode;
import io.github.ennuil.ok_zoomer.zoom.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.ZoomerZoomOverlay;
import java.util.List;
import net.minecraft.class_2960;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.loader.api.config.QuiltConfig;

public class OkZoomerConfigManager {
    public static final OkZoomerConfig CONFIG = (OkZoomerConfig)QuiltConfig.create((String)"ok_zoomer", (String)"config", OkZoomerConfig.class);
    public static final TrackedValue<ConfigEnums.CinematicCameraOptions> CINEMATIC_CAMERA = CONFIG.getValue(List.of("features", "cinematic_camera"));
    public static final TrackedValue<Boolean> REDUCE_SENSITIVITY = CONFIG.getValue(List.of("features", "reduce_sensitivity"));
    public static final TrackedValue<ConfigEnums.ZoomTransitionOptions> ZOOM_TRANSITION = CONFIG.getValue(List.of("features", "zoom_transition"));
    public static final TrackedValue<ConfigEnums.ZoomModes> ZOOM_MODE = CONFIG.getValue(List.of("features", "zoom_mode"));
    public static final TrackedValue<Boolean> ZOOM_SCROLLING = CONFIG.getValue(List.of("features", "zoom_scrolling"));
    public static final TrackedValue<Boolean> EXTRA_KEY_BINDS = CONFIG.getValue(List.of("features", "extra_key_binds"));
    public static final TrackedValue<ConfigEnums.ZoomOverlays> ZOOM_OVERLAY = CONFIG.getValue(List.of("features", "zoom_overlay"));
    public static final TrackedValue<ConfigEnums.SpyglassDependency> SPYGLASS_DEPENDENCY = CONFIG.getValue(List.of("features", "spyglass_dependency"));
    public static final TrackedValue<Double> ZOOM_DIVISOR = CONFIG.getValue(List.of("values", "zoom_divisor"));
    public static final TrackedValue<Double> MINIMUM_ZOOM_DIVISOR = CONFIG.getValue(List.of("values", "minimum_zoom_divisor"));
    public static final TrackedValue<Double> MAXIMUM_ZOOM_DIVISOR = CONFIG.getValue(List.of("values", "maximum_zoom_divisor"));
    public static final TrackedValue<Integer> UPPER_SCROLL_STEPS = CONFIG.getValue(List.of("values", "upper_scroll_steps"));
    public static final TrackedValue<Integer> LOWER_SCROLL_STEPS = CONFIG.getValue(List.of("values", "lower_scroll_steps"));
    public static final TrackedValue<Double> SMOOTH_MULTIPLIER = CONFIG.getValue(List.of("values", "smooth_multiplier"));
    public static final TrackedValue<Double> CINEMATIC_MULTIPLIER = CONFIG.getValue(List.of("values", "cinematic_multiplier"));
    public static final TrackedValue<Double> MINIMUM_LINEAR_STEP = CONFIG.getValue(List.of("values", "minimum_linear_step"));
    public static final TrackedValue<Double> MAXIMUM_LINEAR_STEP = CONFIG.getValue(List.of("values", "maximum_linear_step"));
    public static final TrackedValue<Boolean> RESET_ZOOM_WITH_MOUSE = CONFIG.getValue(List.of("tweaks", "reset_zoom_with_mouse"));
    public static final TrackedValue<Boolean> FORGET_ZOOM_DIVISOR = CONFIG.getValue(List.of("tweaks", "forget_zoom_divisor"));
    public static final TrackedValue<Boolean> UNBIND_CONFLICTING_KEY = CONFIG.getValue(List.of("tweaks", "unbind_conflicting_key"));
    public static final TrackedValue<Boolean> USE_SPYGLASS_TEXTURE = CONFIG.getValue(List.of("tweaks", "use_spyglass_texture"));
    public static final TrackedValue<Boolean> USE_SPYGLASS_SOUNDS = CONFIG.getValue(List.of("tweaks", "use_spyglass_sounds"));
    public static final TrackedValue<Boolean> SHOW_RESTRICTION_TOASTS = CONFIG.getValue(List.of("tweaks", "show_restriction_toasts"));
    public static final TrackedValue<Boolean> PRINT_OWO_ON_START = CONFIG.getValue(List.of("tweaks", "print_owo_on_start"));

    public OkZoomerConfigManager() {
        OkZoomerConfigManager.configureZoomInstance();
        CONFIG.registerCallback(config -> OkZoomerConfigManager.configureZoomInstance());
    }

    public static void configureZoomInstance() {
        ZoomUtils.ZOOMER_ZOOM.setTransitionMode((TransitionMode)(switch ((ConfigEnums.ZoomTransitionOptions)ZOOM_TRANSITION.value()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode(((Double)SMOOTH_MULTIPLIER.value()).floatValue());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode((Double)MINIMUM_LINEAR_STEP.value(), (Double)MAXIMUM_LINEAR_STEP.value());
            default -> new InstantTransitionMode();
        }));
        ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor(((Double)ZOOM_DIVISOR.value()).doubleValue());
        OkZoomerConfigManager.configureZoomModifier();
        class_2960 overlayTextureId = new class_2960((Boolean)USE_SPYGLASS_TEXTURE.value() != false ? "textures/misc/spyglass_scope.png" : "ok_zoomer:textures/misc/zoom_overlay.png");
        ZoomUtils.ZOOMER_ZOOM.setZoomOverlay((ZoomOverlay)(switch ((ConfigEnums.ZoomOverlays)ZOOM_OVERLAY.value()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        }));
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = (ConfigEnums.CinematicCameraOptions)CINEMATIC_CAMERA.value();
        boolean reduceSensitivity = (Boolean)REDUCE_SENSITIVITY.value();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            Object cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier((Double)CINEMATIC_MULTIPLIER.value());
                default -> null;
            };
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ContainingMouseModifier(new MouseModifier[]{cinematicModifier, new ZoomDivisorMouseModifier()}) : cinematicModifier));
        } else {
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ZoomDivisorMouseModifier() : null));
        }
    }
}

