/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.option.SpruceBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.config.metadata.WidgetSize;
import io.github.ennuil.ok_zoomer.config.screen.widgets.CustomTextureBackground;
import io.github.ennuil.ok_zoomer.config.screen.widgets.SpruceBoundedDoubleInputOption;
import io.github.ennuil.ok_zoomer.config.screen.widgets.SpruceBoundedIntegerInputOption;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueTreeNode;

public class OkZoomerConfigScreen
extends SpruceScreen {
    private static final CustomTextureBackground NORMAL_BACKGROUND = new CustomTextureBackground(new class_2960("minecraft:textures/block/yellow_terracotta.png"), 0.25f, 0.25f, 0.25f, 1.0f);
    private static final CustomTextureBackground DARKENED_BACKGROUND = new CustomTextureBackground(new class_2960("minecraft:textures/block/yellow_terracotta.png"), 0.125f, 0.125f, 0.125f, 1.0f);
    private SpruceOptionListWidget list;
    private final class_437 parent;
    private ConfigEnums.ZoomPresets preset;
    private Map<TrackedValue<Object>, Object> newValues;
    private SpruceOption optionBuffer;

    public OkZoomerConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"config.ok_zoomer.title"));
        this.parent = parent;
        this.preset = ConfigEnums.ZoomPresets.DEFAULT;
        this.newValues = new Reference2ObjectArrayMap();
        this.optionBuffer = null;
    }

    private static class_2561 getCyclingOptionText(String text, class_2561 prefix) {
        return class_2561.method_43469((String)"spruceui.options.generic", (Object[])new Object[]{prefix, text != null ? class_2561.method_43471((String)text) : class_2561.method_43470((String)"Error")});
    }

    protected void method_25426() {
        super.method_25426();
        this.list = new SpruceOptionListWidget(Position.of((int)0, (int)22), this.field_22789, this.field_22790 - 36 - 22);
        this.list.setBackground((Background)DARKENED_BACKGROUND);
        this.initializeOptionList(this.list);
        this.appendPresetSection(this.list);
        this.method_37063((class_364)this.list);
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.field_22789 / 2 - 154), (int)(this.field_22790 - 28)), 150, 20, (class_2561)class_2561.method_43471((String)"config.ok_zoomer.discard_changes"), btn -> {
            this.resetNewValues();
            this.refresh();
        }).asVanilla());
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.field_22789 / 2 + 4), (int)(this.field_22790 - 28)), 150, 20, SpruceTexts.GUI_DONE, btn -> {
            this.newValues.forEach((trackedValue, newValue) -> {
                if (trackedValue.value() != null) {
                    trackedValue.setValue(newValue, false);
                }
            });
            OkZoomerConfigManager.CONFIG.save();
            this.field_22787.method_1507(this.parent);
        }).asVanilla());
    }

    public void renderTitle(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
    }

    public void method_25434(class_332 graphics) {
        NORMAL_BACKGROUND.render(graphics, (class_437)this);
    }

    public void method_25432() {
        this.newValues.forEach((trackedValue, newValue) -> trackedValue.setValue(newValue, false));
        OkZoomerConfigManager.CONFIG.save();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void resetNewValues() {
        this.newValues = new Reference2ObjectArrayMap();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            if (trackedValue.getRealValue() == null) continue;
            this.newValues.put((TrackedValue<Object>)trackedValue, trackedValue.getRealValue());
        }
    }

    private void initializeOptionList(SpruceOptionListWidget options) {
        for (ValueTreeNode node : OkZoomerConfigManager.CONFIG.nodes()) {
            if (!(node instanceof ValueTreeNode.Section)) continue;
            ValueTreeNode.Section section = (ValueTreeNode.Section)node;
            SpruceSeparatorOption separator = new SpruceSeparatorOption(String.format("config.ok_zoomer.%s", section.key()), true, (class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.%s.tooltip", section.key())));
            this.addOptionToList(options, (SpruceOption)separator, WidgetSize.Size.FULL);
            for (ValueTreeNode subNode : section) {
                TrackedValue trackedValue;
                WidgetSize.Size size = (WidgetSize.Size)((Object)subNode.metadata(WidgetSize.TYPE));
                if (!(subNode instanceof TrackedValue)) continue;
                TrackedValue trackie = trackedValue = (TrackedValue)subNode;
                this.newValues.putIfAbsent((TrackedValue<Object>)trackie, trackedValue.getRealValue());
                if (trackedValue.value() instanceof Boolean) {
                    Object option = !trackedValue.equals(OkZoomerConfigManager.UNBIND_CONFLICTING_KEY) ? new SpruceBooleanOption(String.format("config.ok_zoomer.%s", trackedValue.key()), () -> (Boolean)this.newValues.get(trackie), value -> this.newValues.replace((TrackedValue<Object>)trackie, value), (class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.%s.tooltip", trackedValue.key()))) : SpruceSimpleActionOption.of((String)"config.ok_zoomer.tweaks.unbind_conflicting_key", button -> ZoomUtils.unbindConflictingKey(this.field_22787, true), (class_2561)class_2561.method_43471((String)"config.ok_zoomer.tweaks.unbind_conflicting_key.tooltip"));
                    this.addOptionToList(options, (SpruceOption)option, size);
                    continue;
                }
                if (trackedValue.value() instanceof Double) {
                    double minimum = Double.MIN_VALUE;
                    double maximum = Double.MAX_VALUE;
                    for (Constraint constraint : trackedValue.constraints()) {
                        if (!(constraint instanceof Constraint.Range)) continue;
                        try {
                            Field minField = Constraint.Range.class.getDeclaredField("min");
                            Field maxField = Constraint.Range.class.getDeclaredField("max");
                            minField.setAccessible(true);
                            maxField.setAccessible(true);
                            minimum = Math.max((Double)minField.get(constraint), minimum);
                            maximum = Math.min((Double)maxField.get(constraint), maximum);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                            e.printStackTrace();
                        }
                    }
                    SpruceBoundedDoubleInputOption option = new SpruceBoundedDoubleInputOption(String.format("config.ok_zoomer.%s", trackedValue.key()), minimum, maximum, () -> (Double)this.newValues.get(trackie), value -> this.newValues.replace((TrackedValue<Object>)trackie, value), (class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.%s.tooltip", trackedValue.key())));
                    this.addOptionToList(options, option, size);
                    continue;
                }
                if (trackedValue.value() instanceof Integer) {
                    int minimum = Integer.MIN_VALUE;
                    int maximum = Integer.MAX_VALUE;
                    for (Constraint constraint : trackedValue.constraints()) {
                        if (!(constraint instanceof Constraint.Range)) continue;
                        try {
                            Field minField = Constraint.Range.class.getDeclaredField("min");
                            Field maxField = Constraint.Range.class.getDeclaredField("max");
                            minField.setAccessible(true);
                            maxField.setAccessible(true);
                            minimum = Math.max((Integer)minField.get(constraint), minimum);
                            maximum = Math.min((Integer)maxField.get(constraint), maximum);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                            e.printStackTrace();
                        }
                    }
                    SpruceBoundedIntegerInputOption option = new SpruceBoundedIntegerInputOption(String.format("config.ok_zoomer.%s", trackedValue.key()), minimum, maximum, () -> (Integer)this.newValues.get(trackie), value -> this.newValues.replace((TrackedValue<Object>)trackie, value), (class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.%s.tooltip", trackedValue.key())));
                    this.addOptionToList(options, option, size);
                    continue;
                }
                if (!(trackedValue.value() instanceof ConfigEnums.ConfigEnum)) continue;
                SpruceCyclingOption option = new SpruceCyclingOption(String.format("config.ok_zoomer.%s", trackedValue.key()), amount -> this.newValues.replace((TrackedValue<Object>)trackie, ((ConfigEnums.ConfigEnum)this.newValues.get(trackie)).next()), option2 -> OkZoomerConfigScreen.getCyclingOptionText(String.format("config.ok_zoomer.%s.%s", trackedValue.key(), this.newValues.get(trackie).toString().toLowerCase()), option2.getPrefix()), (class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.%s.tooltip", trackedValue.key())));
                this.addOptionToList(options, (SpruceOption)option, size);
            }
        }
        if (this.optionBuffer != null) {
            this.list.addOptionEntry(this.optionBuffer, null);
            this.optionBuffer = null;
        }
    }

    private void appendPresetSection(SpruceOptionListWidget options) {
        SpruceSeparatorOption resetSeparator = new SpruceSeparatorOption("config.ok_zoomer.reset", true, (class_2561)class_2561.method_43471((String)"config.ok_zoomer.reset.tooltip"));
        SpruceCyclingOption presetOption = new SpruceCyclingOption("config.ok_zoomer.reset.preset", amount -> {
            this.preset = (ConfigEnums.ZoomPresets)this.preset.next();
        }, option -> OkZoomerConfigScreen.getCyclingOptionText(String.format("config.ok_zoomer.reset.preset.%s", this.preset.toString().toLowerCase()), option.getPrefix()), (class_2561)class_2561.method_43471((String)"config.ok_zoomer.reset.preset.tooltip"));
        SpruceSimpleActionOption resetSettingsOption = SpruceSimpleActionOption.of((String)"config.ok_zoomer.reset.reset_settings", button -> this.resetToPreset(this.preset), (class_2561)class_2561.method_43471((String)"config.ok_zoomer.reset.reset_settings.tooltip"));
        options.addSingleOptionEntry((SpruceOption)resetSeparator);
        options.addOptionEntry((SpruceOption)presetOption, (SpruceOption)resetSettingsOption);
    }

    private void addOptionToList(SpruceOptionListWidget options, SpruceOption option, WidgetSize.Size size) {
        if (size == WidgetSize.Size.HALF) {
            if (this.optionBuffer == null) {
                this.optionBuffer = option;
            } else {
                this.list.addOptionEntry(this.optionBuffer, option);
                this.optionBuffer = null;
            }
        } else {
            if (this.optionBuffer != null) {
                this.list.addOptionEntry(this.optionBuffer, null);
                this.optionBuffer = null;
            }
            this.list.addSingleOptionEntry(option);
        }
    }

    private void refresh() {
        double scrollAmount = this.list.getScrollAmount();
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        this.list.setScrollAmount(scrollAmount);
    }

    public void resetToPreset(ConfigEnums.ZoomPresets preset) {
        Map.Entry[] entryArray = new Map.Entry[24];
        entryArray[0] = Map.entry(OkZoomerConfigManager.CINEMATIC_CAMERA, preset == ConfigEnums.ZoomPresets.CLASSIC ? ConfigEnums.CinematicCameraOptions.VANILLA : ConfigEnums.CinematicCameraOptions.OFF);
        entryArray[1] = Map.entry(OkZoomerConfigManager.REDUCE_SENSITIVITY, preset != ConfigEnums.ZoomPresets.CLASSIC);
        entryArray[2] = Map.entry(OkZoomerConfigManager.ZOOM_TRANSITION, preset == ConfigEnums.ZoomPresets.CLASSIC ? ConfigEnums.ZoomTransitionOptions.OFF : ConfigEnums.ZoomTransitionOptions.SMOOTH);
        entryArray[3] = Map.entry(OkZoomerConfigManager.ZOOM_MODE, preset == ConfigEnums.ZoomPresets.PERSISTENT ? ConfigEnums.ZoomModes.PERSISTENT : ConfigEnums.ZoomModes.HOLD);
        entryArray[4] = Map.entry(OkZoomerConfigManager.ZOOM_SCROLLING, switch (preset) {
            case ConfigEnums.ZoomPresets.CLASSIC -> false;
            case ConfigEnums.ZoomPresets.SPYGLASS -> false;
            default -> true;
        });
        entryArray[5] = Map.entry(OkZoomerConfigManager.EXTRA_KEY_BINDS, preset != ConfigEnums.ZoomPresets.CLASSIC);
        entryArray[6] = Map.entry(OkZoomerConfigManager.ZOOM_OVERLAY, preset == ConfigEnums.ZoomPresets.SPYGLASS ? ConfigEnums.ZoomOverlays.SPYGLASS : ConfigEnums.ZoomOverlays.OFF);
        entryArray[7] = Map.entry(OkZoomerConfigManager.SPYGLASS_DEPENDENCY, preset == ConfigEnums.ZoomPresets.SPYGLASS ? ConfigEnums.SpyglassDependency.BOTH : ConfigEnums.SpyglassDependency.OFF);
        entryArray[8] = Map.entry(OkZoomerConfigManager.ZOOM_DIVISOR, switch (preset) {
            case ConfigEnums.ZoomPresets.PERSISTENT -> 1.0;
            case ConfigEnums.ZoomPresets.SPYGLASS -> 10.0;
            default -> 4.0;
        });
        entryArray[9] = Map.entry(OkZoomerConfigManager.MINIMUM_ZOOM_DIVISOR, 1.0);
        entryArray[10] = Map.entry(OkZoomerConfigManager.MAXIMUM_ZOOM_DIVISOR, 50.0);
        entryArray[11] = Map.entry(OkZoomerConfigManager.UPPER_SCROLL_STEPS, preset == ConfigEnums.ZoomPresets.SPYGLASS ? 16 : 20);
        entryArray[12] = Map.entry(OkZoomerConfigManager.LOWER_SCROLL_STEPS, preset == ConfigEnums.ZoomPresets.SPYGLASS ? 8 : 4);
        entryArray[13] = Map.entry(OkZoomerConfigManager.SMOOTH_MULTIPLIER, preset == ConfigEnums.ZoomPresets.SPYGLASS ? 0.5 : 0.75);
        entryArray[14] = Map.entry(OkZoomerConfigManager.CINEMATIC_MULTIPLIER, 4.0);
        entryArray[15] = Map.entry(OkZoomerConfigManager.MINIMUM_LINEAR_STEP, 0.125);
        entryArray[16] = Map.entry(OkZoomerConfigManager.MAXIMUM_LINEAR_STEP, 0.25);
        entryArray[17] = Map.entry(OkZoomerConfigManager.RESET_ZOOM_WITH_MOUSE, preset != ConfigEnums.ZoomPresets.CLASSIC);
        entryArray[18] = Map.entry(OkZoomerConfigManager.FORGET_ZOOM_DIVISOR, true);
        entryArray[19] = Map.entry(OkZoomerConfigManager.UNBIND_CONFLICTING_KEY, false);
        entryArray[20] = Map.entry(OkZoomerConfigManager.USE_SPYGLASS_TEXTURE, preset == ConfigEnums.ZoomPresets.SPYGLASS);
        entryArray[21] = Map.entry(OkZoomerConfigManager.USE_SPYGLASS_SOUNDS, preset == ConfigEnums.ZoomPresets.SPYGLASS);
        entryArray[22] = Map.entry(OkZoomerConfigManager.SHOW_RESTRICTION_TOASTS, true);
        entryArray[23] = Map.entry(OkZoomerConfigManager.PRINT_OWO_ON_START, preset != ConfigEnums.ZoomPresets.CLASSIC);
        Map presets = Map.ofEntries(entryArray);
        this.newValues = new Reference2ObjectArrayMap();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            this.newValues.put((TrackedValue<Object>)trackedValue, presets.get(trackedValue));
        }
        this.refresh();
    }
}

