/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen.widgets;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class SpruceBoundedIntegerInputOption
extends SpruceOption {
    private final Supplier<Integer> getter;
    private final Consumer<Integer> setter;
    private final class_2561 tooltip;
    private final Integer minimum;
    private final Integer maximum;

    public SpruceBoundedIntegerInputOption(String key, Integer minimum, Integer maximum, Supplier<Integer> getter, Consumer<Integer> setter, @Nullable class_2561 tooltip) {
        super(key);
        this.minimum = minimum;
        this.maximum = maximum;
        this.getter = getter;
        this.setter = setter;
        this.tooltip = tooltip;
    }

    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.INTEGER_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            textField.setTooltip((class_2561)class_2561.method_43473());
            class_5250 tooltipText = class_2561.method_43473().method_10852(this.tooltip);
            class_2583 tooltipStyle = class_2583.field_24360;
            try {
                int value = Integer.parseInt(textField.getText());
                Optional<Boolean> bound = this.boundCheck(value);
                if (bound.isPresent()) {
                    tooltipStyle = tooltipStyle.method_10977(class_124.field_1061);
                    if (!bound.get().booleanValue()) {
                        tooltipText.method_27693("\n");
                        tooltipText.method_10852((class_2561)(this.minimum == Integer.MIN_VALUE ? class_2561.method_43471((String)"config.ok_zoomer.widget.bounded_integer.below_legal").method_10862(tooltipStyle) : class_2561.method_48321((String)"config.ok_zoomer.widget.bounded_integer.below_range", (String)this.minimum.toString()).method_10862(tooltipStyle)));
                    } else {
                        tooltipText.method_27693("\n");
                        tooltipText.method_10852((class_2561)(this.maximum == Integer.MAX_VALUE ? class_2561.method_43471((String)"config.ok_zoomer.widget.bounded_integer.above_legal").method_10862(tooltipStyle) : class_2561.method_48321((String)"config.ok_zoomer.widget.bounded_integer.above_range", (String)this.maximum.toString()).method_10862(tooltipStyle)));
                    }
                }
                textField.setTooltip((class_2561)tooltipText);
                return class_5481.method_30747((String)displayedText, (class_2583)tooltipStyle);
            }
            catch (NumberFormatException e) {
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
        });
        textField.setChangedListener(input -> {
            try {
                this.set(Integer.parseInt(input));
            }
            catch (NumberFormatException e) {
                this.set(null);
            }
        });
        this.setTooltip(this.tooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(Integer value) {
        this.setter.accept(value);
    }

    public Integer get() {
        return this.getter.get();
    }

    private Optional<Boolean> boundCheck(int value) {
        if (value < this.minimum) {
            return Optional.of(false);
        }
        if (value > this.maximum) {
            return Optional.of(true);
        }
        return Optional.empty();
    }
}

