/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.packets;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.quiltmc.qsl.networking.api.client.ClientPlayConnectionEvents;
import org.quiltmc.qsl.networking.api.client.ClientPlayNetworking;

public class ZoomPackets {
    public static final class_2960 DISABLE_ZOOM_PACKET_ID = new class_2960("ok_zoomer", "disable_zoom");
    public static final class_2960 DISABLE_ZOOM_SCROLLING_PACKET_ID = new class_2960("ok_zoomer", "disable_zoom_scrolling");
    public static final class_2960 FORCE_CLASSIC_MODE_PACKET_ID = new class_2960("ok_zoomer", "force_classic_mode");
    public static final class_2960 FORCE_ZOOM_DIVISOR_PACKET_ID = new class_2960("ok_zoomer", "force_zoom_divisor");
    public static final class_2960 ACKNOWLEDGE_MOD_PACKET_ID = new class_2960("ok_zoomer", "acknowledge_mod");
    public static final class_2960 FORCE_SPYGLASS_PACKET_ID = new class_2960("ok_zoomer", "force_spyglass");
    public static final class_2960 FORCE_SPYGLASS_OVERLAY_PACKET_ID = new class_2960("ok_zoomer", "force_spyglass_overlay");
    private static boolean hasRestrictions = false;
    private static boolean disableZoom = false;
    private static boolean disableZoomScrolling = false;
    private static boolean forceClassicMode = false;
    private static boolean forceZoomDivisors = false;
    private static Acknowledgement acknowledgement = Acknowledgement.NONE;
    private static double maximumZoomDivisor = 0.0;
    private static double minimumZoomDivisor = 0.0;
    private static boolean spyglassDependency = false;
    private static boolean spyglassOverlay = false;
    private static class_2561 toastTitle = class_2561.method_43471((String)"toast.ok_zoomer.title");

    private static void sendToast(class_310 client, class_2561 description) {
        if (((Boolean)OkZoomerConfigManager.SHOW_RESTRICTION_TOASTS.value()).booleanValue()) {
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)toastTitle, (class_2561)description));
        }
    }

    public static void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_ZOOM_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has disabled zooming");
            disableZoom = true;
            ZoomPackets.checkRestrictions();
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_ZOOM_SCROLLING_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has disabled zoom scrolling");
            ZoomPackets.applyDisableZoomScrolling();
            disableZoomScrolling = true;
            ZoomPackets.checkRestrictions();
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_CLASSIC_MODE_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has imposed classic mode");
            disableZoomScrolling = true;
            forceClassicMode = true;
            ZoomPackets.applyDisableZoomScrolling();
            ZoomPackets.applyClassicMode();
            OkZoomerConfigManager.configureZoomInstance();
            ZoomPackets.checkRestrictions();
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_ZOOM_DIVISOR_PACKET_ID, (client, handler, buf, sender) -> {
            int readableBytes = buf.readableBytes();
            if (readableBytes == 8 || readableBytes == 16) {
                double maxDouble = buf.readDouble();
                double minDouble = readableBytes == 16 ? buf.readDouble() : maxDouble;
                client.execute(() -> {
                    if (minDouble <= 0.0 || maxDouble <= 0.0 || minDouble > maxDouble) {
                        ZoomUtils.LOGGER.info(String.format("[Ok Zoomer] This server has attempted to set invalid divisor values! (min %s, max %s)", minDouble, maxDouble));
                    } else {
                        ZoomUtils.LOGGER.info(String.format("[Ok Zoomer] This server has set the zoom divisors to minimum %s and maximum %s", minDouble, maxDouble));
                        maximumZoomDivisor = maxDouble;
                        minimumZoomDivisor = minDouble;
                        forceZoomDivisors = true;
                        OkZoomerConfigManager.configureZoomInstance();
                        ZoomPackets.checkRestrictions();
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ACKNOWLEDGE_MOD_PACKET_ID, (client, handler, buf, sender) -> {
            boolean restricting = !buf.readBoolean();
            client.execute(() -> {
                ZoomPackets.checkRestrictions();
                if (restricting) {
                    if (ZoomPackets.getAcknowledgement().equals((Object)Acknowledgement.HAS_RESTRICTIONS)) {
                        ZoomUtils.LOGGER.info("[Ok Zoomer] This server acknowledges the mod and has established some restrictions");
                        ZoomPackets.sendToast(client, (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.acknowledge_mod_restrictions"));
                    }
                } else if (ZoomPackets.getAcknowledgement().equals((Object)Acknowledgement.HAS_NO_RESTRICTIONS)) {
                    ZoomUtils.LOGGER.info("[Ok Zoomer] This server acknowledges the mod and establishes no restrictions");
                    ZoomPackets.sendToast(client, (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.acknowledge_mod"));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_SPYGLASS_PACKET_ID, (client, handler, buf, sender) -> {
            boolean requireItem = buf.readBoolean();
            boolean replaceZoom = buf.readBoolean();
            client.execute(() -> {
                ZoomUtils.LOGGER.info(String.format("[Ok Zoomer] This server has the following spyglass restrictions: Require Item: %s, Replace Zoom: %s", requireItem, replaceZoom));
                OkZoomerConfigManager.SPYGLASS_DEPENDENCY.setOverride((Object)(requireItem ? (replaceZoom ? ConfigEnums.SpyglassDependency.BOTH : ConfigEnums.SpyglassDependency.REQUIRE_ITEM) : (replaceZoom ? ConfigEnums.SpyglassDependency.REPLACE_ZOOM : null)));
                spyglassDependency = true;
                ZoomPackets.checkRestrictions();
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_SPYGLASS_OVERLAY_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info(String.format("[Ok Zoomer] This server has imposed a spyglass overlay on the zoom", new Object[0]));
            OkZoomerConfigManager.ZOOM_OVERLAY.setOverride((Object)ConfigEnums.ZoomOverlays.SPYGLASS);
            spyglassOverlay = true;
            ZoomPackets.checkRestrictions();
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (hasRestrictions) {
                ZoomPackets.resetPacketSignals();
            }
        });
    }

    public static boolean getHasRestrictions() {
        return hasRestrictions;
    }

    private static void checkRestrictions() {
        boolean hasRestrictions;
        ZoomPackets.hasRestrictions = hasRestrictions = disableZoom || disableZoomScrolling || forceClassicMode || forceZoomDivisors || spyglassDependency || spyglassOverlay;
        acknowledgement = hasRestrictions ? Acknowledgement.HAS_RESTRICTIONS : Acknowledgement.HAS_NO_RESTRICTIONS;
    }

    public static boolean getDisableZoom() {
        return disableZoom;
    }

    public static boolean getDisableZoomScrolling() {
        return disableZoomScrolling;
    }

    public static boolean getForceClassicMode() {
        return forceClassicMode;
    }

    public static boolean getForceZoomDivisors() {
        return forceZoomDivisors;
    }

    public static Acknowledgement getAcknowledgement() {
        return acknowledgement;
    }

    public static double getMaximumZoomDivisor() {
        return maximumZoomDivisor;
    }

    public static double getMinimumZoomDivisor() {
        return minimumZoomDivisor;
    }

    public static boolean getSpyglassDependency() {
        return spyglassDependency;
    }

    public static boolean getSpyglassOverlay() {
        return spyglassOverlay;
    }

    private static void applyDisableZoomScrolling() {
        OkZoomerConfigManager.ZOOM_SCROLLING.setOverride((Object)false);
        OkZoomerConfigManager.EXTRA_KEY_BINDS.setOverride((Object)false);
    }

    private static void applyClassicMode() {
        OkZoomerConfigManager.CINEMATIC_CAMERA.setOverride((Object)ConfigEnums.CinematicCameraOptions.VANILLA);
        OkZoomerConfigManager.REDUCE_SENSITIVITY.setOverride((Object)false);
        OkZoomerConfigManager.ZOOM_DIVISOR.setOverride((Object)4.0);
    }

    private static void resetPacketSignals() {
        hasRestrictions = false;
        disableZoom = false;
        disableZoomScrolling = false;
        OkZoomerConfigManager.ZOOM_SCROLLING.removeOverride();
        OkZoomerConfigManager.EXTRA_KEY_BINDS.removeOverride();
        forceClassicMode = false;
        OkZoomerConfigManager.CINEMATIC_CAMERA.removeOverride();
        OkZoomerConfigManager.REDUCE_SENSITIVITY.removeOverride();
        OkZoomerConfigManager.ZOOM_DIVISOR.removeOverride();
        forceZoomDivisors = false;
        maximumZoomDivisor = 0.0;
        minimumZoomDivisor = 0.0;
        acknowledgement = Acknowledgement.NONE;
        spyglassDependency = false;
        OkZoomerConfigManager.SPYGLASS_DEPENDENCY.removeOverride();
        spyglassOverlay = false;
        OkZoomerConfigManager.ZOOM_OVERLAY.removeOverride();
    }

    public static enum Acknowledgement {
        NONE,
        HAS_RESTRICTIONS,
        HAS_NO_RESTRICTIONS;

    }
}

