/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.zoom;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ZoomerZoomOverlay
implements ZoomOverlay {
    private static final class_2960 OVERLAY_ID = new class_2960("ok_zoomer:zoom_overlay");
    private final class_2960 textureId;
    private boolean active;
    private final class_310 client;
    public float zoomOverlayAlpha = 0.0f;
    public float lastZoomOverlayAlpha = 0.0f;

    public ZoomerZoomOverlay(class_2960 textureId) {
        this.textureId = textureId;
        this.active = false;
        this.client = class_310.method_1551();
    }

    public class_2960 getIdentifier() {
        return OVERLAY_ID;
    }

    public boolean getActive() {
        return this.active;
    }

    public void renderOverlay(class_332 graphics) {
        int scaledWidth = this.client.method_22683().method_4486();
        int scaledHeight = this.client.method_22683().method_4502();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        float lerpedOverlayAlpha = class_3532.method_16439((float)this.client.method_1488(), (float)this.lastZoomOverlayAlpha, (float)this.zoomOverlayAlpha);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)lerpedOverlayAlpha);
        graphics.method_25291(this.textureId, 0, 0, -90, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void tick(boolean active, double divisor, double transitionMultiplier) {
        if (active || this.zoomOverlayAlpha == 0.0f) {
            this.active = active;
        }
        float zoomMultiplier = active ? 1.0f : 0.0f;
        this.lastZoomOverlayAlpha = this.zoomOverlayAlpha;
        if (((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.ZOOM_TRANSITION.value()).equals(ConfigEnums.ZoomTransitionOptions.SMOOTH)) {
            this.zoomOverlayAlpha = (float)((double)this.zoomOverlayAlpha + (double)(zoomMultiplier - this.zoomOverlayAlpha) * (Double)OkZoomerConfigManager.SMOOTH_MULTIPLIER.value());
        } else if (((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.ZOOM_TRANSITION.value()).equals(ConfigEnums.ZoomTransitionOptions.LINEAR)) {
            double linearStep = class_3532.method_15350((double)(1.0 / divisor), (double)((Double)OkZoomerConfigManager.MINIMUM_LINEAR_STEP.value()), (double)((Double)OkZoomerConfigManager.MAXIMUM_LINEAR_STEP.value()));
            this.zoomOverlayAlpha = class_3532.method_15348((float)this.zoomOverlayAlpha, (float)zoomMultiplier, (float)((float)linearStep));
        }
    }
}

