/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.mixin;

import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.util.NetworkUtil;
import dev.tr7zw.itemswapper.util.ShulkerHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2817;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public class ServerGamePacketListenerImplMixin {
    private static final Logger network_logger = LogManager.getLogger((String)"ItemSwapper-Network");
    private static final ConfigManager configManager = ConfigManager.getInstance();
    @Shadow
    public class_3222 field_14140;

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    public void handleCustomPayload(class_2817 serverboundCustomPayloadPacket, CallbackInfo ci) {
        if (NetworkUtil.swapMessage.equals((Object)serverboundCustomPayloadPacket.method_36169()) && !ServerGamePacketListenerImplMixin.configManager.getConfig().serverPreventModUsage) {
            this.swapItem(serverboundCustomPayloadPacket);
        }
        if (NetworkUtil.refillMessage.equals((Object)serverboundCustomPayloadPacket.method_36169()) && !ServerGamePacketListenerImplMixin.configManager.getConfig().serverPreventModUsage) {
            this.refillSlot(serverboundCustomPayloadPacket);
        }
    }

    private void swapItem(class_2817 serverboundCustomPayloadPacket) {
        try {
            class_2540 buf = serverboundCustomPayloadPacket.method_36170();
            int inventory = buf.readInt();
            int slot = buf.readInt();
            class_1799 shulker = (class_1799)this.field_14140.method_31548().field_7547.get(inventory);
            class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
            if (content != null) {
                class_1799 tmp = (class_1799)content.get(slot);
                content.set(slot, (Object)this.field_14140.method_31548().method_7391());
                this.field_14140.method_31548().method_5447(this.field_14140.method_31548().field_7545, tmp);
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }

    private void refillSlot(class_2817 serverboundCustomPayloadPacket) {
        try {
            class_2540 buf = serverboundCustomPayloadPacket.method_36170();
            int targetSlot = buf.readInt();
            class_1799 target = this.field_14140.method_31548().method_5438(targetSlot);
            if (target == null || target.method_7960()) {
                return;
            }
            int space = target.method_7914() - target.method_7947();
            if (space <= 0) {
                return;
            }
            for (int i = 0; i < this.field_14140.method_31548().field_7547.size(); ++i) {
                class_1799 shulker = (class_1799)this.field_14140.method_31548().field_7547.get(i);
                class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
                if (content == null) continue;
                boolean boxChanged = false;
                for (int entry = 0; entry < content.size(); ++entry) {
                    class_1799 boxItem = (class_1799)content.get(entry);
                    if (!class_1799.method_31577((class_1799)boxItem, (class_1799)target)) continue;
                    int amount = Math.min(space, boxItem.method_7947());
                    target.method_7939(target.method_7947() + amount);
                    boxItem.method_7939(boxItem.method_7947() - amount);
                    boxChanged = true;
                    if ((space -= amount) <= 0) break;
                }
                if (!boxChanged) continue;
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }
}

