/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.server;

import dev.tr7zw.itemswapper.packets.RefillItemPayload;
import dev.tr7zw.itemswapper.packets.SwapItemPayload;
import dev.tr7zw.itemswapper.util.ShulkerHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerItemHandler {
    private static final Logger network_logger = LogManager.getLogger((String)"ItemSwapper-Network");

    public void swapItem(class_3222 player, SwapItemPayload payload) {
        try {
            if (ShulkerHelper.isShulker(player.method_31548().method_7391().method_7909())) {
                return;
            }
            class_1799 shulker = (class_1799)player.method_31548().field_7547.get(payload.inventorySlot());
            class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
            if (content != null) {
                class_1799 tmp = (class_1799)content.get(payload.slot());
                content.set(payload.slot(), (Object)player.method_31548().method_7391());
                player.method_31548().method_5447(player.method_31548().field_7545, tmp);
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }

    public void refillSlot(class_3222 player, RefillItemPayload payload) {
        try {
            class_1799 target = player.method_31548().method_5438(payload.slot());
            if (target == null || target.method_7960()) {
                return;
            }
            int space = target.method_7914() - target.method_7947();
            if (space <= 0) {
                return;
            }
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 shulker = (class_1799)player.method_31548().field_7547.get(i);
                class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
                if (content == null) continue;
                boolean boxChanged = false;
                for (int entry = 0; entry < content.size(); ++entry) {
                    class_1799 boxItem = (class_1799)content.get(entry);
                    if (!class_1799.method_31577((class_1799)boxItem, (class_1799)target)) continue;
                    int amount = Math.min(space, boxItem.method_7947());
                    target.method_7939(target.method_7947() + amount);
                    boxItem.method_7939(boxItem.method_7947() - amount);
                    boxChanged = true;
                    if ((space -= amount) <= 0) break;
                }
                if (!boxChanged) continue;
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }
}

