/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.registry;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lol.bai.badpackets.api.config.ClientConfigPacketReceiver;
import lol.bai.badpackets.api.config.ServerConfigPacketReceiver;
import lol.bai.badpackets.api.play.ClientPlayPacketReceiver;
import lol.bai.badpackets.api.play.ServerPlayPacketReceiver;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.mixin.AccessServerboundCustomPayloadPacket;
import lol.bai.badpackets.impl.mixin.client.AccessClientboundCustomPayloadPacket;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class ChannelRegistry<T> {
    private static final Set<class_2960> RESERVED_CHANNELS = Set.of(Constants.CHANNEL_SYNC, Constants.MC_REGISTER_CHANNEL, Constants.MC_UNREGISTER_CHANNEL);
    private static final Supplier<ReaderMapHolder> C2S_READERS = Suppliers.memoize(() -> new ReaderMapHolder(AccessServerboundCustomPayloadPacket::badpackets_getPacketReaders, AccessServerboundCustomPayloadPacket::badpackets_setPacketReaders));
    private static final Supplier<ReaderMapHolder> S2C_READERS = Suppliers.memoize(() -> new ReaderMapHolder(AccessClientboundCustomPayloadPacket::badpackets_getPacketReaders, AccessClientboundCustomPayloadPacket::badpackets_setPacketReaders));
    public static final ChannelRegistry<ClientConfigPacketReceiver<class_8710>> CONFIG_S2C = new ChannelRegistry(RESERVED_CHANNELS, S2C_READERS);
    public static final ChannelRegistry<ServerConfigPacketReceiver<class_8710>> CONFIG_C2S = new ChannelRegistry(RESERVED_CHANNELS, C2S_READERS);
    public static final ChannelRegistry<ClientPlayPacketReceiver<class_8710>> PLAY_S2C = new ChannelRegistry(RESERVED_CHANNELS, S2C_READERS);
    public static final ChannelRegistry<ServerPlayPacketReceiver<class_8710>> PLAY_C2S = new ChannelRegistry(RESERVED_CHANNELS, C2S_READERS);
    private final Map<class_2960, T> channels = new HashMap<class_2960, T>();
    private final Set<class_2960> reservedChannels;
    private final Set<AbstractPacketHandler<T>> handlers = new HashSet<AbstractPacketHandler<T>>();
    private final Supplier<ReaderMapHolder> readersHolder;
    private final ReentrantReadWriteLock locks = new ReentrantReadWriteLock();

    private ChannelRegistry(Set<class_2960> reservedChannels, Supplier<ReaderMapHolder> readersHolder) {
        this.reservedChannels = reservedChannels;
        this.readersHolder = readersHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(class_2960 id, class_2540.class_7461<? extends class_8710> reader, T receiver) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (this.reservedChannels.contains(id)) {
                throw new IllegalArgumentException("Reserved channel id " + id);
            }
            Map<class_2960, class_2540.class_7461<? extends class_8710>> readers = this.readersHolder.get().getter.get();
            if (!(readers instanceof HashMap)) {
                readers = new HashMap<class_2960, class_2540.class_7461<? extends class_8710>>(readers);
                this.readersHolder.get().setter.accept(readers);
            }
            readers.put(id, reader);
            this.channels.put(id, receiver);
            for (AbstractPacketHandler<T> handler : this.handlers) {
                handler.onRegister(id);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(class_2960 id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            boolean bl = this.channels.containsKey(id);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(class_2960 id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            T t = this.channels.get(id);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<class_2960> getChannels() {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            HashSet<class_2960> hashSet = new HashSet<class_2960>(this.channels.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void addHandler(AbstractPacketHandler<T> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.add(handler);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeHandler(AbstractPacketHandler<T> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.remove(handler);
        }
        finally {
            lock.unlock();
        }
    }

    private record ReaderMapHolder(Supplier<Map<class_2960, class_2540.class_7461<? extends class_8710>>> getter, Consumer<Map<class_2960, class_2540.class_7461<? extends class_8710>>> setter) {
    }
}

