/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.networking.eventloops;

import com.ishland.vmp.common.networking.eventloops.VMPEventLoops;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2535.class})
public class MixinClientConnection {
    @Shadow
    private Channel field_11651;
    @Shadow
    @Nullable
    private volatile class_2547 field_11652;
    @Unique
    private boolean isReregistering = false;
    @Unique
    private EventLoopGroup pendingReregistration = null;

    @Inject(method={"setPacketListener"}, at={@At(value="FIELD", target="Lnet/minecraft/network/ClientConnection;packetListener:Lnet/minecraft/network/listener/PacketListener;", opcode=181)})
    private void onSetState(class_2547 packetListener, CallbackInfo ci) {
        EventLoopGroup group = VMPEventLoops.getEventLoopGroup(this.field_11651, packetListener.method_52280());
        if (group != null) {
            this.reregister(group);
        }
    }

    private synchronized void reregister(EventLoopGroup group) {
        if (this.isReregistering) {
            this.pendingReregistration = group;
            return;
        }
        ChannelPromise promise = this.field_11651.newPromise();
        this.field_11651.config().setAutoRead(false);
        this.isReregistering = true;
        this.field_11651.deregister().addListener(future -> {
            if (future.isSuccess()) {
                group.register(promise);
            } else {
                promise.setFailure((Throwable)new RuntimeException("Failed to deregister channel", future.cause()));
            }
        });
        promise.addListener(future -> {
            this.isReregistering = false;
            if (future.isSuccess()) {
                this.field_11651.config().setAutoRead(true);
            } else {
                this.field_11651.pipeline().fireExceptionCaught(future.cause());
            }
            if (this.pendingReregistration != null) {
                this.reregister(this.pendingReregistration);
                this.pendingReregistration = null;
            }
        });
    }
}

