/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.config.PickBlockOverrides;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.InventoryManager;
import io.github.sjouwer.pickblockpro.util.NbtUtil;
import io.github.sjouwer.pickblockpro.util.RaycastUtil;
import java.util.Optional;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockApplyCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5915;
import net.minecraft.class_746;

public class BlockPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private BlockPicker() {
    }

    public static void pickBlock() {
        if (BlockPicker.client.field_1724 == null || BlockPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick Block called outside of play; no world and/or player");
            return;
        }
        if (!config.blockPickEntities() && !config.blockPickBlocks()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pick_block_pro.message.nothingToPick"));
            return;
        }
        class_239 hit = RaycastUtil.getHit(config.blockPickRange(), !config.blockPickFluids(), !config.blockPickEntities());
        if (hit == null) {
            return;
        }
        class_1799 item = ((ClientPickBlockGatherCallback)ClientPickBlockGatherCallback.EVENT.invoker()).pick((class_1657)BlockPicker.client.field_1724, hit);
        if (hit.method_17783() == class_239.class_240.field_1331) {
            item = BlockPicker.getEntityItemStack(hit, item);
        }
        if (hit.method_17783() == class_239.class_240.field_1332 && config.blockPickBlocks()) {
            item = BlockPicker.getBlockItemStack(hit, item);
        }
        if (item.method_7960() && hit.method_17783() == class_239.class_240.field_1333 && config.blockPickLight()) {
            item = BlockPicker.getLightFromSunOrMoon();
        }
        if (!item.method_7960()) {
            item = ((ClientPickBlockApplyCallback)ClientPickBlockApplyCallback.EVENT.invoker()).pick((class_1657)BlockPicker.client.field_1724, hit, item);
        }
        if (!item.method_7960()) {
            InventoryManager.pickOrPlaceItemInInventory(item);
        }
    }

    private static class_1799 getEntityItemStack(class_239 hit, class_1799 item) {
        class_1297 entity = ((class_3966)hit).method_17782();
        class_1799 override = PickBlockOverrides.getEntityOverride(entity.method_5864());
        if (override != null) {
            item = override;
        }
        if (item.method_7960()) {
            item = entity.method_31480();
        }
        if (item != null && BlockPicker.client.field_1724.method_31549().field_7477 && class_437.method_25441()) {
            if (entity instanceof class_1533) {
                class_1533 itemFrame = (class_1533)entity;
                item = BlockPicker.createFramedItemStack(itemFrame);
            } else if (entity instanceof class_1534) {
                class_1534 paintingEntity = (class_1534)entity;
                item = BlockPicker.createPaintingVariantStack(paintingEntity);
            } else {
                NbtUtil.addEntityNbt(item, entity, true);
            }
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            item = new class_1799((class_1935)class_1802.field_8575);
            NbtUtil.setSkullOwner(item, player);
        }
        if (entity instanceof class_1540) {
            class_1540 fallingBlock = (class_1540)entity;
            item = BlockPicker.getFallingBlockItemStack(fallingBlock);
        }
        return item == null ? class_1799.field_8037 : item;
    }

    private static class_1799 createFramedItemStack(class_1533 itemFrame) {
        class_1799 itemFrameStack = new class_1799((class_1935)(itemFrame instanceof class_5915 ? class_1802.field_28408 : class_1802.field_8143));
        class_1799 framedItem = itemFrame.method_6940();
        if (framedItem.method_31574(class_1802.field_8162)) {
            return itemFrameStack;
        }
        class_5250 name = class_2561.method_43469((String)"text.pick_block_pro.name.framed", (Object[])new Object[]{framedItem.method_7964()});
        name.method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054));
        itemFrameStack.method_7977((class_2561)name);
        NbtUtil.addEntityNbt(itemFrameStack, (class_1297)itemFrame, false);
        return itemFrameStack;
    }

    private static class_1799 createPaintingVariantStack(class_1534 painting) {
        class_1799 paintingStack = new class_1799((class_1935)class_1802.field_8892);
        Optional key = painting.method_43404().method_40230();
        if (key.isPresent()) {
            String translationKey = ((class_5321)key.get()).method_29177().method_48747("painting", "title");
            class_5250 name = class_2561.method_43471((String)translationKey);
            name.method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054));
            paintingStack.method_7977((class_2561)name);
        }
        NbtUtil.addEntityNbt(paintingStack, (class_1297)painting, false);
        return paintingStack;
    }

    private static class_1799 getFallingBlockItemStack(class_1540 fallingBlock) {
        class_1799 item = new class_1799((class_1935)fallingBlock.method_6962().method_26204());
        if (BlockPicker.client.field_1724.method_31549().field_7477 && class_437.method_25443()) {
            NbtUtil.addBlockStateNbt(item, fallingBlock.method_6962(), true);
        }
        return item;
    }

    private static class_1799 getBlockItemStack(class_239 hit, class_1799 item) {
        class_2338 blockPos = ((class_3965)hit).method_17777();
        class_2680 state = BlockPicker.client.field_1687.method_8320(blockPos);
        class_2248 block = state.method_26204();
        class_1799 override = PickBlockOverrides.getBlockOverride(block);
        if (override != null) {
            item = override;
        }
        if (item.method_7960() && block instanceof class_2404) {
            item = state.method_26227().method_15772().method_15774().method_7854();
        }
        if (item.method_7960()) {
            item = block.method_9574((class_4538)BlockPicker.client.field_1687, blockPos, state);
        }
        if (!item.method_7960() && BlockPicker.client.field_1724.method_31549().field_7477) {
            if (class_437.method_25441() && state.method_31709()) {
                class_2586 blockEntity = BlockPicker.client.field_1687.method_8321(blockPos);
                NbtUtil.addBlockEntityNbt(item, blockEntity, true);
            }
            if (class_437.method_25443()) {
                NbtUtil.addBlockStateNbt(item, state, true);
            }
        }
        return item;
    }

    private static class_1799 getLightFromSunOrMoon() {
        if (BlockPicker.client.field_1687.method_27983() != class_1937.field_25179) {
            return class_1799.field_8037;
        }
        int distance = (Integer)BlockPicker.client.field_1690.method_42503().method_41753() * 32;
        class_239 hit = RaycastUtil.getHit(distance, false, false);
        if (hit == null || hit.method_17783() != class_239.class_240.field_1333) {
            return class_1799.field_8037;
        }
        double skyAngle = (double)BlockPicker.client.field_1687.method_30274(client.method_1488()) + 0.25;
        if (skyAngle > 1.0) {
            skyAngle -= 1.0;
        }
        skyAngle *= 360.0;
        class_243 playerVector = BlockPicker.client.field_1724.method_5828(client.method_1488());
        double playerAngle = Math.atan2(playerVector.field_1351, playerVector.field_1352) * 180.0 / Math.PI;
        if (playerAngle < 0.0) {
            playerAngle += 360.0;
        }
        double angleDifference = skyAngle - playerAngle;
        if (Math.abs(playerVector.field_1350) < 0.076 && Math.abs(angleDifference) < 4.3) {
            return BlockPicker.giveOrCycleLight(15);
        }
        if (Math.abs(playerVector.field_1350) < 0.051 && Math.abs(angleDifference - 180.0) < 3.0) {
            return BlockPicker.giveOrCycleLight(7);
        }
        return class_1799.field_8037;
    }

    private static class_1799 giveOrCycleLight(int lightLvl) {
        class_746 player = BlockPicker.client.field_1724;
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_31574(class_1802.field_30904) && player.method_31549().field_7477) {
            NbtUtil.cycleLightLevel(mainHandStack);
            InventoryManager.updateCreativeSlot(player.method_31548().field_7545);
            return class_1799.field_8037;
        }
        class_1799 light = new class_1799((class_1935)class_1802.field_30904);
        NbtUtil.setLightLevel(light, lightLvl);
        return light;
    }
}

