/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.util.InventoryManager;
import io.github.sjouwer.pickblockpro.util.RaycastUtil;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class ToolPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private ToolPicker() {
    }

    public static void pickTool() {
        if (ToolPicker.client.field_1724 == null || ToolPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick Tool called outside of play; no world and/or player");
            return;
        }
        class_239 hit = RaycastUtil.getHit(config.toolPickRange(), !config.toolPickFluids(), false);
        if (hit.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)hit).method_17782();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                ToolPicker.giveOrSwitchTool(Tools.SWORD, livingEntity.method_6046());
            }
        } else {
            class_2338 blockPos = ((class_3965)hit).method_17777();
            class_2680 state = ToolPicker.client.field_1687.method_8320(blockPos);
            ToolPicker.pickMostSuitableTool(state);
        }
    }

    private static void pickMostSuitableTool(class_2680 state) {
        if (state.method_26164(class_3481.field_15481) || state.method_27852(class_2246.field_10343)) {
            ToolPicker.giveOrSwitchTool(Tools.SHEARS);
            return;
        }
        if (state.method_27852(class_2246.field_10211) && config.preferSwordForBamboo()) {
            ToolPicker.giveOrSwitchTool(Tools.SWORD);
            return;
        }
        if (state.method_51176() || state.method_27852(class_2246.field_27879)) {
            ToolPicker.giveOrSwitchTool(Tools.BUCKET);
            return;
        }
        if (state.method_26164(class_3481.field_33715)) {
            ToolPicker.giveOrSwitchTool(Tools.PICKAXE);
            return;
        }
        if (state.method_26164(class_3481.field_33713)) {
            ToolPicker.giveOrSwitchTool(Tools.AXE);
            return;
        }
        if (state.method_26164(class_3481.field_33716)) {
            ToolPicker.giveOrSwitchTool(Tools.SHOVEL);
            return;
        }
        if (state.method_26164(class_3481.field_33714)) {
            ToolPicker.giveOrSwitchTool(Tools.HOE);
        }
    }

    private static void giveOrSwitchTool(Tools tool) {
        ToolPicker.giveOrSwitchTool(tool, null);
    }

    private static void giveOrSwitchTool(Tools tool, class_1310 eGroup) {
        class_1799 bestTool;
        class_1799 class_17992 = bestTool = ToolPicker.client.field_1724.method_31549().field_7477 ? ToolPicker.createBestTool(tool, eGroup) : ToolPicker.findBestTool((class_1657)ToolPicker.client.field_1724, tool, eGroup);
        if (bestTool != null) {
            InventoryManager.pickOrPlaceItemInInventory(bestTool);
        }
    }

    public static class_1799 findBestTool(class_1657 player, Tools tool, class_1310 eGroup) {
        class_1799 bucket;
        class_1661 inventory = player.method_31548();
        if (tool.equals((Object)Tools.BUCKET) && inventory.method_7379(bucket = class_1802.field_8550.method_7854())) {
            return bucket;
        }
        class_1799 bestTool = null;
        int bestToolScore = -1;
        for (int i = 0; i < 36; ++i) {
            int score;
            class_1799 itemStack = inventory.method_5438(i);
            if (!tool.getClassType().isInstance(itemStack.method_7909())) continue;
            int n = score = tool.equals((Object)Tools.SWORD) ? ToolPicker.calculateSwordScore(itemStack, eGroup) : ToolPicker.calculateToolScore(itemStack);
            if (score <= bestToolScore && (bestTool == null || score != bestToolScore || itemStack.method_7919() >= bestTool.method_7919())) continue;
            bestTool = itemStack;
            bestToolScore = score;
        }
        return bestTool;
    }

    private static int calculateToolScore(class_1799 item) {
        int score = 0;
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1831) {
            class_1831 toolItem = (class_1831)class_17922;
            score += toolItem.method_8022().method_8024() * 10000;
        }
        if (config.preferSilkTouch()) {
            score += class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)item) * 400;
            score += class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)item) * 100;
        } else {
            score += class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)item) * 150;
            score += class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)item) * 100;
        }
        score = config.preferEfficiency() ? (score += class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)item) * 500) : (score += class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)item) * 10);
        score += class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)item);
        return score += class_1890.method_8225((class_1887)class_1893.field_9101, (class_1799)item) * 5;
    }

    private static int calculateSwordScore(class_1799 item, class_1310 eGroup) {
        int score = 0;
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1829) {
            class_1829 swordItem = (class_1829)class_17922;
            score = (int)((float)score + swordItem.method_8020());
            score = (int)((float)score + class_1890.method_8218((class_1799)item, (class_1310)(eGroup == null ? class_1310.field_6290 : eGroup)));
        }
        return score;
    }

    public static class_1799 createBestTool(Tools tool, class_1310 eGroup) {
        class_1799 bestTool = switch (tool) {
            default -> throw new IncompatibleClassChangeError();
            case Tools.PICKAXE -> class_1802.field_22024.method_7854();
            case Tools.AXE -> class_1802.field_22025.method_7854();
            case Tools.SHOVEL -> class_1802.field_22023.method_7854();
            case Tools.HOE -> class_1802.field_22026.method_7854();
            case Tools.SWORD -> class_1802.field_22022.method_7854();
            case Tools.SHEARS -> class_1802.field_8868.method_7854();
            case Tools.BUCKET -> class_1802.field_8550.method_7854();
        };
        Map<class_1887, Integer> enchantments = config.getEnchantments(tool, eGroup);
        class_1890.method_8214(enchantments, (class_1799)bestTool);
        return bestTool;
    }

    public static enum Tools {
        BUCKET(class_1755.class),
        PICKAXE(class_1810.class),
        AXE(class_1743.class),
        SHOVEL(class_1821.class),
        HOE(class_1794.class),
        SWORD(class_1829.class),
        SHEARS(class_1820.class);

        private final Class<?> classObject;

        private Tools(Class<?> classObj) {
            this.classObject = classObj;
        }

        public Class<?> getClassType() {
            return this.classObject;
        }
    }
}

