/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.util;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.NbtUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public final class InventoryManager {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();
    public static final int HOTBAR_SIZE = class_1661.method_7368();

    private InventoryManager() {
    }

    public static void pickOrPlaceItemInInventory(class_1799 item) {
        if (InventoryManager.client.field_1724 == null) {
            PickBlockPro.LOGGER.error("Unable to place item inside inventory; no player found");
            return;
        }
        class_1661 inventory = InventoryManager.client.field_1724.method_31548();
        int selectedSlot = inventory.field_7545;
        InventoryManager.pickOrPlaceItemInInventory(item, inventory);
        int newSelectedSlot = inventory.field_7545;
        if (config.stayInSameSlot() && selectedSlot != newSelectedSlot && !InventoryManager.isHotbarSlotLocked(selectedSlot) && !InventoryManager.isHotbarSlotLocked(newSelectedSlot)) {
            InventoryManager.swapSlot(selectedSlot, newSelectedSlot);
            inventory.field_7545 = selectedSlot;
        }
    }

    private static void pickOrPlaceItemInInventory(class_1799 item, class_1661 inventory) {
        boolean isCreative = InventoryManager.client.field_1724.method_31549().field_7477;
        int stackSlot = inventory.method_7395(item);
        if (config.searchContainers() && stackSlot == -1 && !isCreative) {
            stackSlot = InventoryManager.searchThroughContainers(inventory, item.method_7909());
        }
        if (class_1661.method_7380((int)stackSlot)) {
            inventory.field_7545 = stackSlot;
            return;
        }
        if ((stackSlot >= HOTBAR_SIZE || isCreative) && !InventoryManager.setOptimalSlot(inventory)) {
            return;
        }
        if (stackSlot >= HOTBAR_SIZE) {
            InventoryManager.swapSlot(inventory.field_7545, stackSlot);
            return;
        }
        if (isCreative) {
            int currentSlot = inventory.field_7545;
            int emptySlot = inventory.method_7376();
            inventory.method_7374(item);
            InventoryManager.updateCreativeSlot(currentSlot);
            if (emptySlot >= HOTBAR_SIZE) {
                InventoryManager.updateCreativeSlot(emptySlot);
            }
        }
    }

    private static void swapSlot(int hotbarSlot, int inventorySlot) {
        if (InventoryManager.client.field_1761 == null || InventoryManager.client.field_1724 == null) {
            PickBlockPro.LOGGER.error("Unable to swap inventory slot; no player and/or interaction manager");
            return;
        }
        if (inventorySlot < 9) {
            inventorySlot += 36;
        }
        InventoryManager.client.field_1761.method_2906(InventoryManager.client.field_1724.field_7498.field_7763, inventorySlot, hotbarSlot, class_1713.field_7791, (class_1657)InventoryManager.client.field_1724);
    }

    private static int searchThroughContainers(class_1661 inventory, class_1792 item) {
        int slot = -1;
        int highestAmount = 0;
        for (int i = 0; i < 36; ++i) {
            int storedAmount;
            class_1799 invStack = inventory.method_5438(i);
            if (invStack.method_7960() || (storedAmount = NbtUtil.getAmountStored(invStack, item)) <= highestAmount) continue;
            slot = i;
            highestAmount = storedAmount;
        }
        return slot;
    }

    private static boolean setOptimalSlot(class_1661 inventory) {
        int slot = InventoryManager.findEmptyHotbarSlot();
        if (slot == -1) {
            slot = InventoryManager.findUnlockedHotbarSlot();
        }
        if (slot == -1) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pick_block_pro.message.allSlotsLocked"));
            return false;
        }
        inventory.field_7545 = slot;
        return true;
    }

    public static int findEmptyHotbarSlot() {
        int tries;
        if (InventoryManager.client.field_1724 == null) {
            return -1;
        }
        class_1661 inventory = InventoryManager.client.field_1724.method_31548();
        int slot = inventory.field_7545;
        for (tries = 0; !inventory.method_5438(slot).method_7960() && tries < HOTBAR_SIZE; ++tries) {
            if (++slot < HOTBAR_SIZE) continue;
            slot = 0;
        }
        return tries >= HOTBAR_SIZE ? -1 : slot;
    }

    public static int findUnlockedHotbarSlot() {
        int tries;
        if (InventoryManager.client.field_1724 == null) {
            return -1;
        }
        int slot = InventoryManager.client.field_1724.method_31548().field_7545;
        for (tries = 0; InventoryManager.isHotbarSlotLocked(slot) && tries < HOTBAR_SIZE; ++tries) {
            if (++slot < HOTBAR_SIZE) continue;
            slot = 0;
        }
        return tries >= HOTBAR_SIZE ? -1 : slot;
    }

    public static boolean isHotbarSlotLocked(int slot) {
        return config.isSlotLocked(slot);
    }

    public static void updateCreativeSlot(int slot) {
        if (InventoryManager.client.field_1761 == null || InventoryManager.client.field_1724 == null) {
            PickBlockPro.LOGGER.error("Unable to update inventory slot; no player and/or interaction manager");
            return;
        }
        if (slot < 0) {
            return;
        }
        class_1799 item = InventoryManager.client.field_1724.method_31548().method_5438(slot);
        if (class_1661.method_7380((int)slot)) {
            slot = 36 + slot;
        }
        InventoryManager.client.field_1761.method_2909(item, slot);
    }
}

