/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1076.class})
abstract class LanguageManagerMixin {
    @Shadow
    private Map<String, class_1077> field_5324;

    LanguageManagerMixin() {
    }

    @Shadow
    public abstract class_1077 method_4668(String var1);

    @Inject(method={"reload"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", ordinal=0, remap=false, target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    void onReload$addFallbacks(class_3300 manager, CallbackInfo ci, List<String> list) {
        Lists.reverse(Config.getInstance().fallbacks).stream().filter(code -> Objects.nonNull(this.method_4668((String)code))).forEach(list::add);
    }

    @Inject(method={"reload"}, at={@At(value="INVOKE", ordinal=0, remap=false, target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    void onReload$setSystemLanguage(class_3300 manager, CallbackInfo ci) {
        if (LanguageReload.shouldSetSystemLanguage) {
            LanguageReload.shouldSetSystemLanguage = false;
            LanguageReload.LOGGER.info("Language is not set. Setting it to system language");
            Locale locale = Locale.getDefault();
            List<String> matchingLanguages = this.field_5324.keySet().stream().filter(code -> code.split("_")[0].equalsIgnoreCase(locale.getLanguage())).toList();
            int count = matchingLanguages.size();
            if (count > 1) {
                matchingLanguages.stream().filter(code -> {
                    String[] split = code.split("_");
                    if (split.length < 2) {
                        return false;
                    }
                    return split[1].equalsIgnoreCase(locale.getCountry());
                }).findFirst().ifPresent(lang -> LanguageManagerMixin.setSystemLanguage(lang, locale));
            } else if (count == 1) {
                LanguageManagerMixin.setSystemLanguage(matchingLanguages.get(0), locale);
            }
        }
    }

    @Unique
    private static void setSystemLanguage(String lang, Locale locale) {
        LanguageReload.LOGGER.info("Set language to {} (mapped from {})", (Object)lang, (Object)locale.toLanguageTag());
        LanguageReload.setLanguage(lang, new LinkedList<String>());
    }
}

