/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Locale;
import java.util.Optional;

public class EnumCodec<E extends Enum<E>>
implements PrimitiveCodec<E> {
    private final E[] members;

    public EnumCodec(E[] members) {
        this.members = members;
        if (members.length == 0) {
            throw new RuntimeException("EnumCodec has no members!");
        }
    }

    public <T> T write(DynamicOps<T> ops, E value) {
        return (T)ops.createString(((Enum)value).toString().toLowerCase(Locale.ROOT));
    }

    public <T> DataResult<E> read(DynamicOps<T> ops, T input) {
        Optional value = ops.getStringValue(input).get().left();
        if (value.isEmpty()) {
            return DataResult.error(() -> this.getTypeName() + " must not be empty!");
        }
        String inner = ((String)value.get()).toUpperCase(Locale.ROOT);
        for (E member : this.members) {
            if (!((Enum)member).name().equals(inner)) continue;
            return DataResult.success(member);
        }
        return DataResult.error(() -> this.getTypeName() + " has no value " + inner + "!");
    }

    private String getTypeName() {
        return ((Enum)this.members[0]).getDeclaringClass().getName();
    }
}

