/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.StructEndec;
import io.wispforest.owo.serialization.endec.AttributeEndecBuilder;
import io.wispforest.owo.serialization.endec.EitherEndec;
import io.wispforest.owo.serialization.endec.KeyedEndec;
import io.wispforest.owo.serialization.endec.StructEndecBuilder;
import io.wispforest.owo.serialization.endec.StructField;
import io.wispforest.owo.serialization.format.edm.EdmElement;
import io.wispforest.owo.serialization.format.edm.EdmEndec;
import io.wispforest.owo.serialization.format.edm.EdmOps;
import io.wispforest.owo.serialization.format.edm.EdmSerializer;
import io.wispforest.owo.serialization.format.edm.LenientEdmDeserializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public interface Endec<T> {
    public static final Endec<Void> VOID = Endec.of((serializer, unused) -> {}, deserializer -> null);
    public static final Endec<Boolean> BOOLEAN = Endec.of(Serializer::writeBoolean, Deserializer::readBoolean);
    public static final Endec<Byte> BYTE = Endec.of(Serializer::writeByte, Deserializer::readByte);
    public static final Endec<Short> SHORT = Endec.of(Serializer::writeShort, Deserializer::readShort);
    public static final Endec<Integer> INT = Endec.of(Serializer::writeInt, Deserializer::readInt);
    public static final Endec<Integer> VAR_INT = Endec.of(Serializer::writeVarInt, Deserializer::readVarInt);
    public static final Endec<Long> LONG = Endec.of(Serializer::writeLong, Deserializer::readLong);
    public static final Endec<Long> VAR_LONG = Endec.of(Serializer::writeVarLong, Deserializer::readVarLong);
    public static final Endec<Float> FLOAT = Endec.of(Serializer::writeFloat, Deserializer::readFloat);
    public static final Endec<Double> DOUBLE = Endec.of(Serializer::writeDouble, Deserializer::readDouble);
    public static final Endec<String> STRING = Endec.of(Serializer::writeString, Deserializer::readString);
    public static final Endec<byte[]> BYTES = Endec.of(Serializer::writeBytes, Deserializer::readBytes);

    public void encode(Serializer<?> var1, T var2);

    public T decode(Deserializer<?> var1);

    default public <E> E encodeFully(Supplier<Serializer<E>> serializerConstructor, T value) {
        Serializer<E> serializer = serializerConstructor.get();
        this.encode(serializer, value);
        return serializer.result();
    }

    default public <E> T decodeFully(Function<E, Deserializer<E>> deserializerConstructor, E value) {
        return this.decode(deserializerConstructor.apply(value));
    }

    default public Endec<List<T>> listOf() {
        return Endec.of((serializer, list) -> {
            try (Serializer.Sequence sequence = serializer.sequence(this, list.size());){
                list.forEach(sequence::element);
            }
        }, deserializer -> {
            Deserializer.Sequence<Object> sequenceState = deserializer.sequence(this);
            ArrayList list = new ArrayList(sequenceState.estimatedSize());
            sequenceState.forEachRemaining(list::add);
            return list;
        });
    }

    default public Endec<Map<String, T>> mapOf() {
        return Endec.of((serializer, map) -> {
            try (Serializer.Map mapState = serializer.map(this, map.size());){
                map.forEach(mapState::entry);
            }
        }, deserializer -> {
            Deserializer.Map mapState = deserializer.map(this);
            HashMap map = new HashMap(mapState.estimatedSize());
            mapState.forEachRemaining(entry -> map.put((String)entry.getKey(), entry.getValue()));
            return map;
        });
    }

    default public Endec<Optional<T>> optionalOf() {
        return Endec.of((serializer, value) -> serializer.writeOptional(this, value), deserializer -> deserializer.readOptional(this));
    }

    public static <T> Endec<T> of(final BiConsumer<Serializer<?>, T> encode, final Function<Deserializer<?>, T> decode) {
        return new Endec<T>(){

            @Override
            public void encode(Serializer<?> serializer, T value) {
                encode.accept(serializer, value);
            }

            @Override
            public T decode(Deserializer<?> deserializer) {
                return decode.apply(deserializer);
            }
        };
    }

    public static <K, V> Endec<Map<K, V>> map(Endec<K> keyEndec, Endec<V> valueEndec) {
        return StructEndecBuilder.of(keyEndec.fieldOf("k", Map.Entry::getKey), valueEndec.fieldOf("v", Map.Entry::getValue), Map::entry).listOf().xmap(entries -> Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new)), kvMap -> List.copyOf(kvMap.entrySet()));
    }

    public static <K, V> Endec<Map<K, V>> map(Function<K, String> keyToString, Function<String, K> stringToKey, Endec<V> valueEndec) {
        return Endec.of((serializer, map) -> {
            try (Serializer.Map mapState = serializer.map(valueEndec, map.size());){
                map.forEach((k, v) -> mapState.entry((String)keyToString.apply(k), v));
            }
        }, deserializer -> {
            Deserializer.Map mapState = deserializer.map(valueEndec);
            HashMap map = new HashMap(mapState.estimatedSize());
            mapState.forEachRemaining(entry -> map.put(stringToKey.apply((String)entry.getKey()), entry.getValue()));
            return map;
        });
    }

    public static <E extends Enum<E>> Endec<E> forEnum(Class<E> enumClass) {
        return Endec.ifAttr(SerializationAttribute.HUMAN_READABLE, STRING.xmap(name -> Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(e -> e.name().equals(name)).findFirst().get(), Enum::name)).orElse(VAR_INT.xmap(ordinal -> ((Enum[])enumClass.getEnumConstants())[ordinal], Enum::ordinal));
    }

    public static <T> Endec<T> ofCodec(Codec<T> codec) {
        return Endec.of((serializer, value) -> EdmEndec.INSTANCE.encode((Serializer<?>)serializer, (EdmElement)class_156.method_47526((DataResult)codec.encodeStart((DynamicOps)EdmOps.INSTANCE, value), IllegalStateException::new)), deserializer -> class_156.method_47526((DataResult)codec.parse((DynamicOps)EdmOps.INSTANCE, EdmEndec.INSTANCE.decode((Deserializer)deserializer)), IllegalStateException::new));
    }

    public static <T, K> Endec<T> dispatchedStruct(Function<K, StructEndec<? extends T>> variantToEndec, Function<T, K> instanceToVariant, Endec<K> variantEndec) {
        return Endec.dispatchedStruct(variantToEndec, instanceToVariant, variantEndec, "type");
    }

    public static <T, K> Endec<T> dispatchedStruct(final Function<K, StructEndec<? extends T>> variantToEndec, final Function<T, K> instanceToVariant, final Endec<K> variantEndec, final String variantKey) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(Serializer.Struct struct, T value) {
                Object variant = instanceToVariant.apply(value);
                struct.field(variantKey, variantEndec, variant);
                ((StructEndec)variantToEndec.apply(variant)).encodeStruct(struct, value);
            }

            @Override
            public T decodeStruct(Deserializer.Struct struct) {
                Object variant = struct.field(variantKey, variantEndec);
                return ((StructEndec)variantToEndec.apply(variant)).decodeStruct(struct);
            }
        };
    }

    public static <T, K> Endec<T> dispatched(final Function<K, Endec<? extends T>> variantToEndec, final Function<T, K> instanceToVariant, final Endec<K> variantEndec) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(Serializer.Struct struct, T value) {
                Object variant = instanceToVariant.apply(value);
                struct.field("variant", variantEndec, variant);
                struct.field("instance", (Endec)variantToEndec.apply(variant), value);
            }

            @Override
            public T decodeStruct(Deserializer.Struct struct) {
                Object variant = struct.field("variant", variantEndec);
                return struct.field("instance", (Endec)variantToEndec.apply(variant));
            }
        };
    }

    private static <F, S> Endec<Either<F, S>> either(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, false);
    }

    public static <F, S> Endec<Either<F, S>> xor(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, true);
    }

    public static <T> AttributeEndecBuilder<T> ifAttr(SerializationAttribute attribute, Endec<T> endec) {
        return new AttributeEndecBuilder<T>(endec, attribute);
    }

    default public <R> Endec<R> xmap(Function<T, R> to, Function<R, T> from) {
        return Endec.of((serializer, value) -> this.encode((Serializer<?>)serializer, (T)from.apply(value)), deserializer -> to.apply(this.decode((Deserializer<?>)deserializer)));
    }

    default public Endec<T> validate(Consumer<T> validator) {
        return this.xmap(t -> {
            validator.accept(t);
            return t;
        }, t -> {
            validator.accept(t);
            return t;
        });
    }

    default public Endec<T> catchErrors(BiFunction<Deserializer<?>, Exception, T> decodeOnError) {
        return Endec.of(this::encode, deserializer -> {
            try {
                return deserializer.tryRead(this::decode);
            }
            catch (Exception e) {
                return decodeOnError.apply((Deserializer<?>)deserializer, e);
            }
        });
    }

    default public Endec<@Nullable T> nullableOf() {
        return this.optionalOf().xmap(o -> o.orElse(null), Optional::ofNullable);
    }

    default public Codec<T> codec(final SerializationAttribute ... assumedAttributes) {
        return new Codec<T>(){

            public <D> DataResult<Pair<T, D>> decode(DynamicOps<D> ops, D input) {
                try {
                    return DataResult.success((Object)new Pair(Endec.this.decode(LenientEdmDeserializer.of((EdmElement)ops.convertTo((DynamicOps)EdmOps.INSTANCE, input)).withAttributes(assumedAttributes)), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <D> DataResult<D> encode(T input, DynamicOps<D> ops, D prefix) {
                try {
                    return DataResult.success(EdmOps.INSTANCE.convertTo(ops, (EdmElement)Endec.this.encodeFully(() -> EdmSerializer.of().withAttributes(assumedAttributes), input)));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
    }

    default public KeyedEndec<T> keyed(String key, T defaultValue) {
        return new KeyedEndec<T>(key, this, defaultValue);
    }

    default public KeyedEndec<T> keyed(String key, Supplier<T> defaultValueFactory) {
        return new KeyedEndec<Supplier<T>>(key, this, defaultValueFactory);
    }

    default public <S> StructField<S, T> fieldOf(String name, Function<S, T> getter) {
        return new StructField<S, T>(name, this, getter);
    }

    default public <S> StructField<S, T> optionalFieldOf(String name, Function<S, T> getter, @Nullable T defaultValue) {
        return new StructField<S, Object>(name, this.optionalOf().xmap(optional -> optional.orElse(defaultValue), Optional::ofNullable), getter, defaultValue);
    }

    default public <S> StructField<S, T> optionalFieldOf(String name, Function<S, T> getter, Supplier<@Nullable T> defaultValue) {
        return new StructField<S, Supplier<T>>(name, this.optionalOf().xmap(optional -> optional.orElseGet(defaultValue), Optional::ofNullable), getter, defaultValue);
    }
}

