/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.data;

import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DataInputDeserializer
implements Deserializer<DataInput> {
    protected final DataInput input;

    protected DataInputDeserializer(DataInput input) {
        this.input = input;
    }

    public static DataInputDeserializer of(DataInput input) {
        return new DataInputDeserializer(input);
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return Set.of();
    }

    @Override
    public byte readByte() {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.input.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.input.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.input.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readVarInt() {
        try {
            byte current;
            int result = 0;
            int bytes = 0;
            do {
                current = this.input.readByte();
                result |= (current & 0x7F) << bytes++ * 7;
                if (bytes <= 5) continue;
                throw new RuntimeException("VarInt too big");
            } while ((current & 0x80) == 128);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readVarLong() {
        try {
            byte current;
            long result = 0L;
            int bytes = 0;
            do {
                current = this.input.readByte();
                result |= (long)(current & 0x7F) << bytes++ * 7;
                if (bytes <= 10) continue;
                throw new RuntimeException("VarLong too big");
            } while ((current & 0x80) == 128);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.input.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readString() {
        try {
            return this.input.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] readBytes() {
        byte[] result = new byte[this.readVarInt()];
        try {
            this.input.readFully(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public <V> Optional<V> readOptional(Endec<V> endec) {
        return this.readBoolean() ? Optional.of(endec.decode(this)) : Optional.empty();
    }

    @Override
    public <V> V tryRead(Function<Deserializer<DataInput>, V> reader) {
        throw new UnsupportedOperationException("As DataInput cannot be rewound, tryRead(...) cannot be supported");
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(Endec<E> elementEndec) {
        return new Sequence<E>(elementEndec, this.readVarInt());
    }

    @Override
    public <V> Deserializer.Map<V> map(Endec<V> valueEndec) {
        return new Map<V>(valueEndec, this.readVarInt());
    }

    @Override
    public Deserializer.Struct struct() {
        return new Sequence(null, 0);
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V>,
    Deserializer.Struct {
        private final Endec<V> valueEndec;
        private final int size;
        private int index = 0;

        private Sequence(Endec<V> valueEndec, int size) {
            this.valueEndec = valueEndec;
            this.size = size;
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public V next() {
            ++this.index;
            return this.valueEndec.decode(DataInputDeserializer.this);
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec) {
            return endec.decode(DataInputDeserializer.this);
        }

        @Override
        @Nullable
        public <F> F field(@Nullable String field, Endec<F> endec, @Nullable F defaultValue) {
            return endec.decode(DataInputDeserializer.this);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final Endec<V> valueEndec;
        private final int size;
        private int index = 0;

        private Map(Endec<V> valueEndec, int size) {
            this.valueEndec = valueEndec;
            this.size = size;
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Map.Entry<String, V> next() {
            ++this.index;
            return java.util.Map.entry(DataInputDeserializer.this.readString(), this.valueEndec.decode(DataInputDeserializer.this));
        }
    }
}

