/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SelfDescribedDeserializer;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.format.edm.EdmDeserializer;
import io.wispforest.owo.serialization.format.edm.EdmElement;
import io.wispforest.owo.serialization.format.edm.EdmIo;
import io.wispforest.owo.serialization.format.edm.EdmSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EdmEndec
implements Endec<EdmElement<?>> {
    public static final EdmEndec INSTANCE = new EdmEndec();

    private EdmEndec() {
    }

    @Override
    public void encode(Serializer<?> serializer, EdmElement<?> value) {
        if (serializer.attributes().contains((Object)SerializationAttribute.SELF_DESCRIBING)) {
            new EdmDeserializer(value).readAny(serializer);
            return;
        }
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            EdmIo.encode((DataOutput)output, value);
            serializer.writeBytes(output.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode EDM element in EdmEndec", e);
        }
    }

    @Override
    public EdmElement<?> decode(Deserializer<?> deserializer) {
        if (deserializer instanceof SelfDescribedDeserializer) {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)deserializer;
            EdmSerializer nativeSerializer = new EdmSerializer();
            selfDescribedDeserializer.readAny(nativeSerializer);
            return (EdmElement)nativeSerializer.result();
        }
        try {
            return EdmIo.decode((DataInput)ByteStreams.newDataInput((byte[])deserializer.readBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse EDM element in EdmEndec", e);
        }
    }
}

