/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.owo.serialization.format.edm.EdmElement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EdmOps
implements DynamicOps<EdmElement<?>> {
    public static final EdmOps INSTANCE = new EdmOps();

    private EdmOps() {
    }

    public EdmElement<?> empty() {
        return null;
    }

    public EdmElement<?> createNumeric(Number number) {
        return EdmElement.wrapDouble(number.doubleValue());
    }

    public EdmElement<?> createByte(byte b) {
        return EdmElement.wrapByte(b);
    }

    public EdmElement<?> createShort(short s) {
        return EdmElement.wrapShort(s);
    }

    public EdmElement<?> createInt(int i) {
        return EdmElement.wrapInt(i);
    }

    public EdmElement<?> createLong(long l) {
        return EdmElement.wrapLong(l);
    }

    public EdmElement<?> createFloat(float f) {
        return EdmElement.wrapFloat(f);
    }

    public EdmElement<?> createDouble(double d) {
        return EdmElement.wrapDouble(d);
    }

    public EdmElement<?> createBoolean(boolean bl) {
        return EdmElement.wrapBoolean(bl);
    }

    public EdmElement<?> createString(String value) {
        return EdmElement.wrapString(value);
    }

    public EdmElement<?> createByteList(ByteBuffer input) {
        return EdmElement.wrapBytes(DataFixUtils.toArray((ByteBuffer)input));
    }

    public EdmElement<?> createList(Stream<EdmElement<?>> input) {
        return EdmElement.wrapSequence(input.toList());
    }

    public DataResult<EdmElement<?>> mergeToList(EdmElement<?> list, EdmElement<?> value) {
        if (list == null) {
            return DataResult.success(EdmElement.wrapSequence(List.of(value)));
        }
        Object obj = list.value();
        if (obj instanceof List) {
            List properList = (List)obj;
            ArrayList newList = new ArrayList(properList);
            newList.add(value);
            return DataResult.success(EdmElement.wrapSequence(newList));
        }
        return DataResult.error(() -> "Not a sequence: " + list);
    }

    public EdmElement<?> createMap(Stream<Pair<EdmElement<?>, EdmElement<?>>> map) {
        return EdmElement.wrapMap(map.collect(Collectors.toMap(pair -> (String)((EdmElement)pair.getFirst()).cast(), Pair::getSecond)));
    }

    public DataResult<EdmElement<?>> mergeToMap(EdmElement<?> map, EdmElement<?> key, EdmElement<?> value) {
        if (!(key.value() instanceof String)) {
            return DataResult.error(() -> "Key is not a string: " + key);
        }
        if (map == null) {
            return DataResult.success(EdmElement.wrapMap(Map.of((String)key.cast(), value)));
        }
        Object obj = map.value();
        if (obj instanceof Map) {
            Map properMap = (Map)obj;
            HashMap newMap = new HashMap(properMap);
            newMap.put((String)key.cast(), value);
            return DataResult.success(EdmElement.wrapMap(newMap));
        }
        return DataResult.error(() -> "Not a map: " + map);
    }

    public DataResult<Number> getNumberValue(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return DataResult.success((Object)number);
        }
        return DataResult.error(() -> "Not a number: " + input);
    }

    public DataResult<Boolean> getBooleanValue(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return DataResult.success((Object)b);
        }
        return DataResult.error(() -> "Not a boolean: " + input);
    }

    public DataResult<String> getStringValue(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof String) {
            String string = (String)obj;
            return DataResult.success((Object)string);
        }
        return DataResult.error(() -> "Not a string: " + input);
    }

    public DataResult<ByteBuffer> getByteBuffer(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return DataResult.success((Object)ByteBuffer.wrap(bytes));
        }
        return DataResult.error(() -> "Not bytes: " + input);
    }

    public DataResult<Stream<EdmElement<?>>> getStream(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof List) {
            List list = (List)obj;
            return DataResult.success(list.stream().map(o -> (EdmElement)o));
        }
        return DataResult.error(() -> "Not a sequence: " + input);
    }

    public DataResult<Stream<Pair<EdmElement<?>, EdmElement<?>>>> getMapValues(EdmElement<?> input) {
        Object obj = input.value();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return DataResult.success(map.entrySet().stream().map(entry -> new Pair(EdmElement.wrapString((String)entry.getKey()), entry.getValue())));
        }
        return DataResult.error(() -> "Not a map: " + input);
    }

    public <U> U convertTo(DynamicOps<U> outOps, EdmElement<?> input) {
        return (U)(switch (input.type()) {
            default -> throw new IncompatibleClassChangeError();
            case EdmElement.Type.BYTE -> outOps.createByte(((Byte)input.cast()).byteValue());
            case EdmElement.Type.SHORT -> outOps.createShort(((Short)input.cast()).shortValue());
            case EdmElement.Type.INT -> outOps.createInt(((Integer)input.cast()).intValue());
            case EdmElement.Type.LONG -> outOps.createLong(((Long)input.cast()).longValue());
            case EdmElement.Type.FLOAT -> outOps.createFloat(((Float)input.cast()).floatValue());
            case EdmElement.Type.DOUBLE -> outOps.createDouble(((Double)input.cast()).doubleValue());
            case EdmElement.Type.BOOLEAN -> outOps.createBoolean(((Boolean)input.cast()).booleanValue());
            case EdmElement.Type.STRING -> outOps.createString((String)input.cast());
            case EdmElement.Type.BYTES -> outOps.createByteList(ByteBuffer.wrap((byte[])input.cast()));
            case EdmElement.Type.OPTIONAL -> ((Optional)input.cast()).map(element -> this.convertTo(outOps, (EdmElement<?>)element)).orElse(outOps.empty());
            case EdmElement.Type.SEQUENCE -> outOps.createList(((List)input.cast()).stream().map(element -> this.convertTo(outOps, (EdmElement<?>)element)));
            case EdmElement.Type.MAP -> outOps.createMap(((Map)input.cast()).entrySet().stream().map(entry -> new Pair(outOps.createString((String)entry.getKey()), this.convertTo(outOps, (EdmElement)entry.getValue()))));
        });
    }

    public EdmElement<?> remove(EdmElement<?> input, String key) {
        Object obj = input.value();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            HashMap newMap = new HashMap(map);
            newMap.remove(key);
            return EdmElement.wrapMap(newMap);
        }
        return input;
    }
}

