/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.nbt;

import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.util.RecursiveSerializer;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_8703;
import net.minecraft.class_8704;

public class NbtSerializer
extends RecursiveSerializer<class_2520> {
    private static final Set<SerializationAttribute> ATTRIBUTES = EnumSet.of(SerializationAttribute.SELF_DESCRIBING);
    protected class_2520 prefix;

    protected NbtSerializer(class_2520 prefix) {
        super(class_2491.field_21033);
        this.prefix = prefix;
    }

    public static NbtSerializer of(class_2520 prefix) {
        return new NbtSerializer(prefix);
    }

    public static NbtSerializer of() {
        return NbtSerializer.of(null);
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public void writeByte(byte value) {
        this.consume(class_2481.method_23233((byte)value));
    }

    @Override
    public void writeShort(short value) {
        this.consume(class_2516.method_23254((short)value));
    }

    @Override
    public void writeInt(int value) {
        this.consume(class_2497.method_23247((int)value));
    }

    @Override
    public void writeLong(long value) {
        this.consume(class_2503.method_23251((long)value));
    }

    @Override
    public void writeFloat(float value) {
        this.consume(class_2494.method_23244((float)value));
    }

    @Override
    public void writeDouble(double value) {
        this.consume(class_2489.method_23241((double)value));
    }

    @Override
    public void writeVarInt(int value) {
        this.consume(switch (class_8703.method_53015((int)value)) {
            case 0, 1 -> class_2481.method_23233((byte)((byte)value));
            case 2 -> class_2516.method_23254((short)((short)value));
            default -> class_2497.method_23247((int)value);
        });
    }

    @Override
    public void writeVarLong(long value) {
        this.consume(switch (class_8704.method_53019((long)value)) {
            case 0, 1 -> class_2481.method_23233((byte)((byte)value));
            case 2 -> class_2516.method_23254((short)((short)value));
            case 3, 4 -> class_2497.method_23247((int)((int)value));
            default -> class_2503.method_23251((long)value);
        });
    }

    @Override
    public void writeBoolean(boolean value) {
        this.consume(class_2481.method_23234((boolean)value));
    }

    @Override
    public void writeString(String value) {
        this.consume(class_2519.method_23256((String)value));
    }

    @Override
    public void writeBytes(byte[] bytes) {
        this.consume(new class_2479(bytes));
    }

    @Override
    public <V> void writeOptional(Endec<V> endec, Optional<V> optional) {
        if (this.isWritingStructField()) {
            optional.ifPresent(v -> endec.encode(this, v));
        } else {
            try (Serializer.Struct struct = this.struct();){
                struct.field("present", Endec.BOOLEAN, optional.isPresent());
                optional.ifPresent(value -> struct.field("value", endec, value));
            }
        }
    }

    @Override
    public <E> Serializer.Sequence<E> sequence(Endec<E> elementEndec, int size) {
        return new Sequence<E>(elementEndec);
    }

    @Override
    public <V> Serializer.Map<V> map(Endec<V> valueEndec, int size) {
        return new Map<V>(valueEndec);
    }

    @Override
    public Serializer.Struct struct() {
        return new Map(null);
    }

    private class Sequence<V>
    implements Serializer.Sequence<V> {
        private final Endec<V> valueEndec;
        private final class_2499 result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Sequence(Endec<V> valueEndec) {
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                class_2499 prefixList;
                class_2520 class_25202 = NbtSerializer.this.prefix;
                if (!(class_25202 instanceof class_2499)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT sequence");
                this.result = prefixList = (class_2499)class_25202;
                return;
            } else {
                this.result = new class_2499();
            }
        }

        @Override
        public void element(V element) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(NbtSerializer.this, element);
                this.result.add((Object)((class_2520)encoded.require("sequence element")));
            }, false);
        }

        @Override
        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }

    private class Map<V>
    implements Serializer.Map<V>,
    Serializer.Struct {
        private final Endec<V> valueEndec;
        private final class_2487 result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map(Endec<V> valueEndec) {
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                class_2487 prefixMap;
                class_2520 class_25202 = NbtSerializer.this.prefix;
                if (!(class_25202 instanceof class_2487)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT map/struct");
                this.result = prefixMap = (class_2487)class_25202;
                return;
            } else {
                this.result = new class_2487();
            }
        }

        @Override
        public void entry(String key, V value) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(NbtSerializer.this, value);
                this.result.method_10566(key, (class_2520)encoded.require("map value"));
            }, false);
        }

        @Override
        public <F> Serializer.Struct field(String name, Endec<F> endec, F value) {
            NbtSerializer.this.frame(encoded -> {
                endec.encode(NbtSerializer.this, value);
                if (encoded.wasEncoded()) {
                    this.result.method_10566(name, (class_2520)encoded.get());
                }
            }, true);
            return this;
        }

        @Override
        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }
}

