/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class MountingHelper {
    protected final ComponentSink sink;
    protected final List<Component> lateChildren;

    protected MountingHelper(ComponentSink sink, List<Component> children) {
        this.sink = sink;
        this.lateChildren = children;
    }

    public static void inflateWithExpand(List<Component> children, Size childSpace, boolean vertical) {
        Size remainingSpace;
        ArrayList nonExpandChildren = new ArrayList();
        children.forEach(child -> {
            if (!((Sizing)child.verticalSizing().get()).isExpand() && !((Sizing)child.horizontalSizing().get()).isExpand()) {
                if (((Positioning)child.positioning().get()).type == Positioning.Type.LAYOUT) {
                    nonExpandChildren.add(child);
                }
                child.inflate(childSpace);
            }
        });
        if (vertical) {
            int height = childSpace.height();
            for (Component nonExpandChild : nonExpandChildren) {
                height -= nonExpandChild.fullSize().height();
            }
            remainingSpace = Size.of(childSpace.width(), Math.max(0, height));
        } else {
            int width = childSpace.width();
            for (Component nonExpandChild : nonExpandChildren) {
                width -= nonExpandChild.fullSize().width();
            }
            remainingSpace = Size.of(Math.max(0, width), childSpace.height());
        }
        children.forEach(child -> {
            if (((Sizing)child.verticalSizing().get()).isExpand() || ((Sizing)child.horizontalSizing().get()).isExpand()) {
                child.inflate(remainingSpace);
            }
        });
    }

    public static MountingHelper mountEarly(ComponentSink sink, List<Component> children, Consumer<Component> layoutFunc) {
        ArrayList<Component> lateChildren = new ArrayList<Component>();
        for (Component child : children) {
            if (!((Positioning)child.positioning().get()).isRelative()) {
                sink.accept(child, layoutFunc);
                continue;
            }
            lateChildren.add(child);
        }
        return new MountingHelper(sink, lateChildren);
    }

    public void mountLate() {
        for (Component child : this.lateChildren) {
            this.sink.accept(child, component -> {
                throw new IllegalStateException("A layout-positioned child was mounted late");
            });
        }
        this.lateChildren.clear();
    }

    public static interface ComponentSink {
        public void accept(@Nullable Component var1, Consumer<Component> var2);
    }
}

