/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.plugins;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PluginManagerImpl<P extends REIPlugin<?>>
implements PluginManager<P>,
PluginView<P> {
    private final List<Reloadable<P>> reloadables = new ArrayList<Reloadable<P>>();
    private final Map<Class<? extends Reloadable<P>>, Reloadable<? super P>> cache = new ConcurrentHashMap<Class<? extends Reloadable<P>>, Reloadable<? super P>>();
    private final Class<P> pluginClass;
    private final UnaryOperator<PluginView<P>> view;
    @Nullable
    private ReloadStage reloading = null;
    private List<ReloadStage> observedStages = new ArrayList<ReloadStage>();
    private final List<REIPluginProvider<P>> plugins = new ArrayList<REIPluginProvider<P>>();
    private final Stopwatch reloadStopwatch = Stopwatch.createUnstarted();
    private boolean forcedMainThread;
    private final Stopwatch forceMainThreadStopwatch = Stopwatch.createUnstarted();

    @SafeVarargs
    public PluginManagerImpl(Class<P> pluginClass, UnaryOperator<PluginView<P>> view, Reloadable<? extends P> ... reloadables) {
        this.pluginClass = pluginClass;
        this.view = view;
        for (Reloadable<? extends P> reloadable : reloadables) {
            this.registerReloadable(reloadable);
        }
    }

    @Override
    public void registerReloadable(Reloadable<? extends P> reloadable) {
        this.reloadables.add(reloadable);
    }

    @Override
    public boolean isReloading() {
        return this.reloading != null;
    }

    @Override
    public <T extends Reloadable<? super P>> T get(Class<T> reloadableClass) {
        Reloadable<? super P> reloadable = this.cache.get(reloadableClass);
        if (reloadable != null) {
            return (T)reloadable;
        }
        for (Reloadable<P> r : this.reloadables) {
            if (!reloadableClass.isInstance(r)) continue;
            this.cache.put(reloadableClass, r);
            return (T)r;
        }
        throw new IllegalArgumentException("Unknown reloadable type! " + reloadableClass.getName());
    }

    @Override
    public List<Reloadable<P>> getReloadables() {
        return Collections.unmodifiableList(this.reloadables);
    }

    @Override
    public PluginView<P> view() {
        return (PluginView)this.view.apply(this);
    }

    @Override
    public void registerPlugin(REIPluginProvider<? extends P> plugin) {
        this.plugins.add(plugin);
        InternalLogger.getInstance().info("Registered plugin provider %s for %s", plugin.getPluginProviderName(), PluginManagerImpl.name(this.pluginClass));
    }

    @Override
    public List<REIPluginProvider<P>> getPluginProviders() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    public FluentIterable<P> getPlugins() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, REIPluginProvider::provide));
    }

    public FluentIterable<PluginWrapper<P>> getPluginWrapped() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, input -> Iterables.transform(input.provide(), plugin -> new PluginWrapper<REIPlugin>((REIPlugin)plugin, (REIPluginProvider<REIPlugin>)input))));
    }

    private SectionClosable section(ReloadStage stage, String section) {
        return new SectionClosable(stage, section);
    }

    private void pluginSection(ReloadStage stage, String sectionName, List<PluginWrapper<P>> list, @Nullable Reloadable<?> reloadable, BiConsumer<PluginWrapper<P>, SectionPluginSink> consumer) {
        for (PluginWrapper<P> wrapper : list) {
            try {
                SectionClosable section = this.section(stage, sectionName + wrapper.getPluginProviderName() + "/");
                try {
                    consumer.accept(wrapper, (respectMainThread, runnable) -> {
                        if (!respectMainThread || reloadable == null || !wrapper.plugin.shouldBeForcefullyDoneOnMainThread(reloadable)) {
                            runnable.run();
                        } else {
                            try {
                                this.forcedMainThread = true;
                                this.forceMainThreadStopwatch.start();
                                InternalLogger.getInstance().warn("Forcing plugin " + wrapper.getPluginProviderName() + " to run on the main thread for " + sectionName + "! This is extremely dangerous, and have large performance implications.");
                                if (Platform.getEnvironment() == Env.CLIENT) {
                                    EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> this.queueExecutionClient(runnable));
                                } else {
                                    this.queueExecution(runnable);
                                }
                            }
                            finally {
                                this.forceMainThreadStopwatch.stop();
                            }
                        }
                    });
                }
                finally {
                    if (section == null) continue;
                    section.close();
                }
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error(wrapper.getPluginProviderName() + " plugin failed to " + sectionName + "!", throwable);
            }
        }
    }

    private void queueExecution(Runnable runnable) {
        MinecraftServer server = GameInstance.getServer();
        if (server != null) {
            server.method_19537(runnable);
        }
    }

    private void queueExecutionClient(Runnable runnable) {
        class_310.method_1551().method_19537(runnable);
    }

    @Override
    public void pre(ReloadStage stage) {
        this.reloading = stage;
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        InternalLogger.getInstance().debug("========================================");
        InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " starting pre-reload for " + stage + ".");
        InternalLogger.getInstance().debug("Reloadables (%d):".formatted(this.reloadables.size()));
        for (Reloadable<P> reloadable : this.reloadables) {
            InternalLogger.getInstance().debug(" - " + PluginManagerImpl.name(reloadable.getClass()));
        }
        InternalLogger.getInstance().debug("Plugins (%d):".formatted(plugins.size()));
        for (PluginWrapper pluginWrapper : plugins) {
            InternalLogger.getInstance().debug(" - (%.2f) ".formatted(pluginWrapper.getPriority()) + pluginWrapper.getPluginProviderName());
        }
        InternalLogger.getInstance().debug("========================================");
        this.forcedMainThread = false;
        this.forceMainThreadStopwatch.reset();
        this.reloadStopwatch.reset().start();
        this.observedStages.clear();
        this.observedStages.add(stage);
        try (SectionClosable preRegister = this.section(stage, "pre-register/");
             PerformanceLogger.Plugin plugin2 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Pre Registration");){
            this.pluginSection(stage, "pre-register/", plugins, null, (plugin, sink) -> {
                try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair(plugin.provider, plugin.plugin));){
                    sink.accept(false, () -> plugin.plugin.preStage(this, stage));
                }
            });
        }
        catch (Throwable throwable) {
            this.reloading = null;
            new RuntimeException("Failed to run pre registration").printStackTrace();
        }
        try (SectionClosable preStageAll = this.section(stage, "pre-stage/");
             PerformanceLogger.Plugin plugin3 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Pre Stage " + stage.name());){
            for (Reloadable<P> reloadable : this.reloadables) {
                Class<?> reloadableClass = reloadable.getClass();
                try {
                    SectionClosable preStage = this.section(stage, "pre-stage/" + PluginManagerImpl.name(reloadableClass) + "/");
                    try {
                        PerformanceLogger.Plugin.Inner inner = plugin3.stage(PluginManagerImpl.name(reloadableClass));
                        try {
                            reloadable.preStage(stage);
                        }
                        finally {
                            if (inner == null) continue;
                            inner.close();
                        }
                    }
                    finally {
                        if (preStage == null) continue;
                        preStage.close();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        this.reloading = null;
        this.reloadStopwatch.stop();
        InternalLogger.getInstance().debug("========================================");
        InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " finished pre-reload for " + stage + " in " + this.reloadStopwatch + ".");
        InternalLogger.getInstance().debug("========================================");
    }

    @Override
    public void post(ReloadStage stage) {
        PerformanceLogger.Plugin perfLogger;
        this.reloading = stage;
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        InternalLogger.getInstance().debug("========================================");
        InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " starting post-reload for " + stage + ".");
        InternalLogger.getInstance().debug("Reloadables (%d):".formatted(this.reloadables.size()));
        for (Reloadable<P> reloadable : this.reloadables) {
            InternalLogger.getInstance().debug(" - " + PluginManagerImpl.name(reloadable.getClass()));
        }
        InternalLogger.getInstance().debug("Plugins (%d):".formatted(plugins.size()));
        for (PluginWrapper pluginWrapper : plugins) {
            InternalLogger.getInstance().debug(" - (%.2f) ".formatted(pluginWrapper.getPriority()) + pluginWrapper.getPluginProviderName());
        }
        InternalLogger.getInstance().debug("========================================");
        this.reloadStopwatch.start();
        Stopwatch postStopwatch = Stopwatch.createStarted();
        try (SectionClosable sectionClosable = this.section(stage, "post-register/");){
            perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Post Registration");
            try {
                this.pluginSection(stage, "post-register/", plugins, null, (plugin, sink) -> {
                    try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair(plugin.provider, plugin.plugin));){
                        sink.accept(false, () -> plugin.plugin.postStage(this, stage));
                    }
                });
            }
            finally {
                if (perfLogger != null) {
                    perfLogger.close();
                }
            }
        }
        catch (Throwable throwable) {
            this.reloading = null;
            new RuntimeException("Failed to run post registration").printStackTrace();
        }
        try (SectionClosable sectionClosable = this.section(stage, "post-stage/");){
            perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Pre Stage " + stage.name());
            try {
                for (Reloadable<P> reloadable : this.reloadables) {
                    Class<?> reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable postStage = this.section(stage, "post-stage/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            PerformanceLogger.Plugin.Inner inner = perfLogger.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.postStage(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (postStage == null) continue;
                            postStage.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            finally {
                if (perfLogger != null) {
                    perfLogger.close();
                }
            }
        }
        this.reloading = null;
        this.reloadStopwatch.stop();
        postStopwatch.stop();
        InternalLogger.getInstance().debug("========================================");
        InternalLogger.getInstance().info(PluginManagerImpl.name(this.pluginClass) + " finished post-reload for " + stage + " in " + postStopwatch + ", totaling " + this.reloadStopwatch + ".");
        if (this.forcedMainThread) {
            InternalLogger.getInstance().warn("Forcing plugins to run on main thread took " + this.forceMainThreadStopwatch);
        }
        InternalLogger.getInstance().debug("========================================");
    }

    private static String name(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            return clazz.getName();
        }
        return simpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReload(ReloadStage stage) {
        try {
            Iterator<Reloadable<P>> inner;
            Class<?> reloadableClass;
            this.reloadStopwatch.start();
            Stopwatch reloadingStopwatch = Stopwatch.createStarted();
            this.reloading = stage;
            ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
            plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
            Collections.reverse(plugins);
            String line = (new String[]{"*", "=", "#", "@", "%", "~", "O", "-", "+"})[new Random().nextInt(9)].repeat(40);
            InternalLogger.getInstance().info(line);
            InternalLogger.getInstance().info(PluginManagerImpl.name(this.pluginClass) + " starting main-reload for " + stage + ".");
            InternalLogger.getInstance().debug("Reloadables (%d):".formatted(this.reloadables.size()));
            for (Reloadable<P> reloadable : this.reloadables) {
                InternalLogger.getInstance().debug(" - " + PluginManagerImpl.name(reloadable.getClass()));
            }
            InternalLogger.getInstance().info("Plugins (%d):".formatted(plugins.size()));
            for (PluginWrapper pluginWrapper : plugins) {
                InternalLogger.getInstance().info(" - (%.2f) ".formatted(pluginWrapper.getPriority()) + pluginWrapper.getPluginProviderName());
            }
            InternalLogger.getInstance().info(line);
            try (SectionClosable startReloadAll = this.section(stage, "start-reload/");
                 PerformanceLogger.Plugin plugin2 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Initialization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable startReload = this.section(stage, "start-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            inner = plugin2.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.startReload(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (startReload == null) continue;
                            startReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            InternalLogger.getInstance().debug("========================================");
            InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " started main-reload for " + stage + ".");
            InternalLogger.getInstance().debug("========================================");
            for (Reloadable reloadable : this.getReloadables()) {
                Class<?> reloadableClass2 = reloadable.getClass();
                SectionClosable reloadablePlugin = this.section(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass2) + "/");
                try {
                    PerformanceLogger.Plugin perfLogger2 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage(PluginManagerImpl.name(reloadableClass2));
                    try {
                        try (PerformanceLogger.Plugin.Inner inner2 = perfLogger2.stage("reloadable-plugin/" + PluginManagerImpl.name(reloadableClass2) + "/prompt-others-before");){
                            for (Reloadable<P> listener : this.reloadables) {
                                try {
                                    listener.beforeReloadable(stage, reloadable);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        this.pluginSection(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass2) + "/", plugins, reloadable, (plugin, sink) -> {
                            try (PerformanceLogger.Plugin.Inner inner = perfLogger2.plugin(new Pair(plugin.provider, plugin.plugin));){
                                sink.accept(true, () -> {
                                    for (Reloadable listener : this.reloadables) {
                                        try {
                                            listener.beforeReloadablePlugin(stage, reloadable, plugin.plugin);
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                        }
                                    }
                                    try {
                                        reloadable.acceptPlugin(plugin.plugin, stage);
                                    }
                                    finally {
                                        for (Reloadable listener : this.reloadables) {
                                            try {
                                                listener.afterReloadablePlugin(stage, reloadable, plugin.plugin);
                                            }
                                            catch (Throwable throwable) {
                                                throwable.printStackTrace();
                                            }
                                        }
                                    }
                                });
                            }
                        });
                        PerformanceLogger.Plugin.Inner inner2 = perfLogger2.stage("reloadable-plugin/" + PluginManagerImpl.name(reloadableClass2) + "/prompt-others-after");
                        try {
                            for (Reloadable<P> listener : this.reloadables) {
                                try {
                                    listener.afterReloadable(stage, reloadable);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (inner2 == null) continue;
                            inner2.close();
                        }
                    }
                    finally {
                        if (perfLogger2 == null) continue;
                        perfLogger2.close();
                    }
                }
                finally {
                    if (reloadablePlugin == null) continue;
                    reloadablePlugin.close();
                }
            }
            InternalLogger.getInstance().debug("========================================");
            InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " ending main-reload for " + stage + ".");
            InternalLogger.getInstance().debug("========================================");
            try (SectionClosable endReloadAll = this.section(stage, "end-reload/");
                 PerformanceLogger.Plugin plugin3 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Finalization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable endReload = this.section(stage, "end-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            inner = plugin3.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.endReload(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (endReload == null) continue;
                            endReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            this.reloadStopwatch.stop();
            InternalLogger.getInstance().debug("========================================");
            InternalLogger.getInstance().debug(PluginManagerImpl.name(this.pluginClass) + " ended main-reload for " + stage + " in " + reloadingStopwatch.stop() + ".");
            InternalLogger.getInstance().debug("========================================");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.reloading = null;
        }
    }

    public List<ReloadStage> getObservedStages() {
        return this.observedStages;
    }

    private class SectionClosable
    implements Closeable {
        private ReloadStage stage;
        private MutablePair<Stopwatch, String> sectionData;

        public SectionClosable(ReloadStage stage, String section) {
            this.stage = stage;
            this.sectionData = new MutablePair((Object)Stopwatch.createUnstarted(), (Object)"");
            this.sectionData.setRight((Object)section);
            InternalLogger.getInstance().trace("[" + PluginManagerImpl.name(PluginManagerImpl.this.pluginClass) + " " + stage + "] Reloading Section: \"%s\"", section);
            ((Stopwatch)this.sectionData.getLeft()).reset().start();
        }

        @Override
        public void close() {
            ((Stopwatch)this.sectionData.getLeft()).stop();
            String section = (String)this.sectionData.getRight();
            InternalLogger.getInstance().trace("[" + PluginManagerImpl.name(PluginManagerImpl.this.pluginClass) + " " + this.stage + "] Reloading Section: \"%s\" done in %s", section, ((Stopwatch)this.sectionData.getLeft()).toString());
            ((Stopwatch)this.sectionData.getLeft()).reset();
        }
    }

    private static class PluginWrapper<P extends REIPlugin<?>> {
        private final P plugin;
        private final REIPluginProvider<P> provider;

        public PluginWrapper(P plugin, REIPluginProvider<P> provider) {
            this.plugin = plugin;
            this.provider = provider;
        }

        public double getPriority() {
            return this.plugin.getPriority();
        }

        public String getPluginProviderName() {
            String pluginName;
            Object providerName = this.provider.getPluginProviderName();
            if (this.provider.provide().size() >= 1 && !((String)providerName).equals(pluginName = this.plugin.getPluginProviderName())) {
                providerName = pluginName + " of " + (String)providerName;
            }
            return providerName;
        }
    }

    @FunctionalInterface
    private static interface SectionPluginSink {
        public void accept(boolean var1, Runnable var2);
    }
}

