/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingRecipeSizeProvider;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCraftingDisplay<C extends class_1860<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<class_8786<C>> recipe;
    private static final List<CraftingRecipeSizeProvider<?>> SIZE_PROVIDER = new ArrayList();

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_8786<C>> recipe) {
        super(inputs, outputs, recipe.map(class_8786::comp_1932));
        this.recipe = recipe;
    }

    public static <R extends class_1860<?>> void registerSizeProvider(CraftingRecipeSizeProvider<R> sizeProvider) {
        SIZE_PROVIDER.add(0, sizeProvider);
    }

    @Nullable
    public static DefaultCraftingDisplay<?> of(class_8786<? extends class_1860<?>> holder) {
        class_1860 recipe = holder.comp_1933();
        if (recipe instanceof class_1867) {
            return new DefaultShapelessDisplay(holder);
        }
        if (recipe instanceof class_1869) {
            return new DefaultShapedDisplay(holder);
        }
        if (!recipe.method_8118()) {
            class_2371 ingredients = recipe.method_8117();
            for (CraftingRecipeSizeProvider<?> pair : SIZE_PROVIDER) {
                CraftingRecipeSizeProvider.Size size = pair.getSize(holder);
                if (size == null) continue;
                return new DefaultCustomShapedDisplay(holder, EntryIngredients.ofIngredients((List<class_1856>)recipe.method_8117()), Collections.singletonList(EntryIngredients.of(recipe.method_8110(BasicDisplay.registryAccess()))), size.getWidth(), size.getHeight());
            }
            return new DefaultCustomDisplay(holder, EntryIngredients.ofIngredients((List<class_1856>)recipe.method_8117()), Collections.singletonList(EntryIngredients.of(recipe.method_8110(BasicDisplay.registryAccess()))));
        }
        return null;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Optional<class_8786<C>> getOptionalRecipe() {
        return this.recipe;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return this.getOptionalRecipe().map(class_8786::comp_1932);
    }

    public <T extends class_1703> List<List<class_1799>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap(ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends class_1703> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public boolean isShapeless() {
        return false;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultCraftingDisplay.getSlotWithSize(display.getInputWidth(craftingGridWidth, 3), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<DefaultCraftingDisplay<?>> serializer() {
        return BasicDisplay.Serializer.of((input, output, location, tag) -> {
            if (tag.method_10545("REIRecipeType")) {
                String type;
                return switch (type = tag.method_10558("REIRecipeType")) {
                    case "Shapeless" -> DefaultCustomShapelessDisplay.simple(input, output, location);
                    case "Shaped" -> DefaultCustomShapedDisplay.simple(input, output, tag.method_10550("RecipeWidth"), tag.method_10550("RecipeHeight"), location);
                    default -> throw new IllegalArgumentException("Unknown recipe type: " + type);
                };
            }
            return DefaultCustomDisplay.simple(input, output, location);
        }, (display, tag) -> {
            tag.method_10582("REIRecipeType", display.isShapeless() ? "Shapeless" : "Shaped");
            if (!display.isShapeless()) {
                tag.method_10569("RecipeWidth", display.getInputWidth(3, 3));
                tag.method_10569("RecipeHeight", display.getInputHeight(3, 3));
            }
        });
    }

    @Override
    public List<InputIngredient<EntryStack<?>>> getInputIngredients(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        int craftingWidth = 3;
        int craftingHeight = 3;
        if (info instanceof SimpleGridMenuInfo && fill) {
            craftingWidth = ((SimpleGridMenuInfo)info).getCraftingWidth(context.getMenu());
            craftingHeight = ((SimpleGridMenuInfo)info).getCraftingHeight(context.getMenu());
        }
        return this.getInputIngredients(craftingWidth, craftingHeight);
    }

    @Override
    public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
        return this.getInputIngredients(3, 3);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        int inputHeight = this.getInputHeight(craftingWidth, craftingHeight);
        HashMap grid = new HashMap();
        List<EntryIngredient> inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient stacks = inputEntries.get(i);
            if (stacks.isEmpty()) continue;
            int index = DefaultCraftingDisplay.getSlotWithSize(inputWidth, i, craftingWidth);
            int x = i % inputWidth;
            int y = i / inputWidth;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of(index, 3 * y + x, stacks));
        }
        ArrayList list = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty(i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, ingredient);
            }
        }
        return list;
    }

    static {
        try {
            Class.forName("me.shedaniel.rei.plugin.common.displays.crafting.%s.DefaultCraftingDisplayImpl".formatted(Platform.isForge() ? "forge" : "fabric")).getDeclaredMethod("registerPlatformSizeProvider", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

