/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.ScreenHandler;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.event.KeyEventImpl;
import com.github.franckyi.guapi.base.event.MouseButtonEventImpl;
import com.github.franckyi.guapi.base.event.MouseDragEventImpl;
import com.github.franckyi.guapi.base.event.MouseEventImpl;
import com.github.franckyi.guapi.base.event.MouseScrollEventImpl;
import com.github.franckyi.guapi.base.event.TypeEventImpl;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public final class ScreenHandlerImpl
implements ScreenHandler {
    public static final ScreenHandler INSTANCE = new ScreenHandlerImpl();
    private final Deque<Scene> scenes = new ArrayDeque<Scene>();
    private final ObjectProperty<Scene> currentSceneProperty = ObjectProperty.create();
    private final IntegerProperty widthProperty = IntegerProperty.create();
    private final IntegerProperty heightProperty = IntegerProperty.create();
    private final class_437 screen = new GuapiScreen();
    private class_437 oldScreen;

    private ScreenHandlerImpl() {
        this.currentSceneProperty().addListener((oldVal, newVal) -> {
            if (newVal == null) {
                if (oldVal != null) {
                    oldVal.widthProperty().unbind();
                    oldVal.heightProperty().unbind();
                    oldVal.hide();
                }
                this.closeScreen();
            } else {
                if (oldVal == null) {
                    this.openScreen();
                } else {
                    oldVal.hide();
                }
                newVal.widthProperty().unbind();
                newVal.widthProperty().bind(this.widthProperty);
                newVal.heightProperty().unbind();
                newVal.heightProperty().bind(this.heightProperty);
                newVal.show();
            }
        });
    }

    @Override
    public void showScene(Scene scene) {
        this.checkScreen();
        this.scenes.push(scene);
        this.setCurrentScene(scene);
    }

    @Override
    public void replaceScene(Scene scene) {
        this.checkScreen();
        if (!this.scenes.isEmpty()) {
            this.scenes.pop();
        }
        this.showScene(scene);
    }

    @Override
    public void hideScene() {
        if (!this.scenes.isEmpty()) {
            this.scenes.pop();
            this.setCurrentScene(this.scenes.peek());
        }
    }

    @Override
    public class_437 getGuapiScreen() {
        return this.screen;
    }

    private void checkScreen() {
        if (class_310.method_1551().field_1755 != this.screen) {
            this.scenes.clear();
            this.setCurrentScene(null);
        }
    }

    private Scene getCurrentScene() {
        return (Scene)this.currentSceneProperty().getValue();
    }

    private ObjectProperty<Scene> currentSceneProperty() {
        return this.currentSceneProperty;
    }

    private void setCurrentScene(Scene value) {
        this.currentSceneProperty().setValue(value);
    }

    private void openScreen() {
        this.oldScreen = class_310.method_1551().field_1755;
        class_310.method_1551().method_1507(this.screen);
    }

    private void closeScreen() {
        class_310.method_1551().method_1507(this.oldScreen);
    }

    private void render(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        try {
            this.getCurrentScene().method_25394(guiGraphics, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Guapi.getExceptionHandler().handleRenderException(e, guiGraphics, mouseX, mouseY, delta, this.getCurrentScene());
            Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while rendering GUAPI Scene", (Throwable)e);
            this.hideScene();
        }
    }

    private void tick() {
        if (this.currentSceneProperty().hasValue()) {
            try {
                this.getCurrentScene().tick();
            }
            catch (Exception e) {
                Guapi.getExceptionHandler().handleTickException(e, this.getCurrentScene());
                Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while ticking GUAPI Scene", (Throwable)e);
                this.hideScene();
            }
        }
    }

    private void updateSize(int width, int height) {
        this.widthProperty.setValue(width);
        this.heightProperty.setValue(height);
    }

    private boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.handleEvent(ScreenEventType.MOUSE_CLICKED, new MouseButtonEventImpl(mouseX, mouseY, button));
    }

    private boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.handleEvent(ScreenEventType.MOUSE_RELEASED, new MouseButtonEventImpl(mouseX, mouseY, button));
    }

    private boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.handleEvent(ScreenEventType.MOUSE_DRAGGED, new MouseDragEventImpl(mouseX, mouseY, button, deltaX, deltaY));
    }

    private boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.handleEvent(ScreenEventType.MOUSE_SCOLLED, new MouseScrollEventImpl(mouseX, mouseY, deltaX, deltaY));
    }

    private boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.handleEvent(ScreenEventType.KEY_PRESSED, new KeyEventImpl(keyCode, scanCode, modifiers));
    }

    private boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.handleEvent(ScreenEventType.KEY_RELEASED, new KeyEventImpl(keyCode, scanCode, modifiers));
    }

    private boolean charTyped(char chr, int modifiers) {
        return this.handleEvent(ScreenEventType.CHAR_TYPED, new TypeEventImpl(chr, modifiers));
    }

    private void mouseMoved(double mouseX, double mouseY) {
        this.handleEvent(ScreenEventType.MOUSE_MOVED, new MouseEventImpl(mouseX, mouseY));
    }

    private <E extends ScreenEvent> boolean handleEvent(ScreenEventType<E> type, E event) {
        if (!this.currentSceneProperty().hasValue()) {
            return false;
        }
        try {
            this.getCurrentScene().handleEvent(type, event);
        }
        catch (Exception e) {
            Guapi.getExceptionHandler().handleEventException(e, type, event, this.getCurrentScene());
            Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while handling " + type.getName() + " event on GUAPI Scene", (Throwable)e);
            this.hideScene();
        }
        return event.isConsumed();
    }

    private final class GuapiScreen
    extends class_437 {
        private GuapiScreen() {
            super((class_2561)GuapiHelper.EMPTY_TEXT);
        }

        public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (!ScreenHandlerImpl.this.currentSceneProperty().hasValue()) {
                return;
            }
            if (ScreenHandlerImpl.this.getCurrentScene().isTexturedBackground()) {
                this.method_25434(guiGraphics);
            } else {
                this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
            }
            ScreenHandlerImpl.this.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public void method_25393() {
            ScreenHandlerImpl.this.tick();
        }

        protected void method_25426() {
            ScreenHandlerImpl.this.updateSize(this.field_22789, this.field_22790);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return ScreenHandlerImpl.this.mouseClicked(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return ScreenHandlerImpl.this.mouseReleased(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return ScreenHandlerImpl.this.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
            return ScreenHandlerImpl.this.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            return ScreenHandlerImpl.this.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean method_16803(int keyCode, int scanCode, int modifiers) {
            return ScreenHandlerImpl.this.keyReleased(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            return ScreenHandlerImpl.this.charTyped(chr, modifiers);
        }

        public void method_16014(double mouseX, double mouseY) {
            ScreenHandlerImpl.this.mouseMoved(mouseX, mouseY);
        }
    }
}

