/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Slider;
import com.github.franckyi.guapi.base.node.AbstractControl;

public abstract class AbstractSlider
extends AbstractControl
implements Slider {
    private final DoubleProperty valueProperty;
    private final DoubleProperty minValueProperty;
    private final DoubleProperty maxValueProperty;
    private final DoubleProperty stepProperty;
    private final ObjectProperty<Slider.LabelFactory> labelFactoryProperty = ObjectProperty.create(d -> GuapiHelper.text(Integer.toString((int)d)));

    protected AbstractSlider() {
        this(0.0);
    }

    protected AbstractSlider(double value) {
        this(value, 0.0, 100.0);
    }

    protected AbstractSlider(double value, double minValue, double maxValue) {
        this(value, minValue, maxValue, 1.0);
    }

    protected AbstractSlider(double value, double minValue, double maxValue, double step) {
        this.valueProperty = DoubleProperty.create(value);
        this.minValueProperty = DoubleProperty.create(minValue);
        this.maxValueProperty = DoubleProperty.create(maxValue);
        this.stepProperty = DoubleProperty.create(step);
        this.minValueProperty.addListener(min -> this.setValue(Math.max(min, this.getValue())));
        this.maxValueProperty.addListener(max -> this.setValue(Math.min(max, this.getValue())));
    }

    @Override
    public DoubleProperty valueProperty() {
        return this.valueProperty;
    }

    @Override
    public DoubleProperty minValueProperty() {
        return this.minValueProperty;
    }

    @Override
    public DoubleProperty maxValueProperty() {
        return this.maxValueProperty;
    }

    @Override
    public DoubleProperty stepProperty() {
        return this.stepProperty;
    }

    @Override
    public ObjectProperty<Slider.LabelFactory> labelFactoryProperty() {
        return this.labelFactoryProperty;
    }
}

