/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.logic;

import com.github.franckyi.ibeeditor.client.ClientContext;
import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.client.context.BlockEditorContext;
import com.github.franckyi.ibeeditor.client.context.EntityEditorContext;
import com.github.franckyi.ibeeditor.client.context.ItemEditorContext;
import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.NetworkManager;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.mixin.AbstractContainerScreenMixin;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2873;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class ClientEditorRequestLogic {
    public static void requestWorldEditor(EditorType editorType) {
        if (!(ClientEditorRequestLogic.requestEntityEditor(editorType) || ClientEditorRequestLogic.requestBlockEditor(editorType) || ClientEditorRequestLogic.requestMainHandItemEditor(editorType))) {
            ClientEditorRequestLogic.requestSelfEditor(editorType);
        }
    }

    public static boolean requestEntityEditor(EditorType editorType) {
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3966) {
            class_3966 res = (class_3966)class_2392;
            class_1297 entity = res.method_17782();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.method_5628()));
            } else {
                class_2487 tag = new class_2487();
                entity.method_5662(tag);
                ModScreenHandler.openEditor(editorType, new EntityEditorContext(tag, (class_2561)ModTexts.errorServerModRequired(ModTexts.ENTITY), true, null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestBlockEditor(EditorType editorType) {
        class_3965 res;
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3965 && (res = (class_3965)class_2392).method_17783() != class_239.class_240.field_1333) {
            class_2338 blockPos = res.method_17777();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.BLOCK_EDITOR_REQUEST, new BlockEditorPacket.Request(editorType, blockPos));
            } else {
                class_638 level = class_310.method_1551().field_1687;
                class_2680 blockState = level.method_8320(blockPos);
                class_2586 blockEntity = level.method_8321(blockPos);
                class_2487 tag = blockEntity == null ? null : blockEntity.method_38243();
                ModScreenHandler.openEditor(editorType, new BlockEditorContext(blockState, tag, (class_2561)ModTexts.errorServerModRequired(ModTexts.BLOCK), null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestMainHandItemEditor(EditorType editorType) {
        class_1799 item = class_310.method_1551().field_1724.method_6047();
        if (item.method_7960()) {
            return false;
        }
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.MAIN_HAND_ITEM_EDITOR_REQUEST, new MainHandItemEditorPacket.Request(editorType));
        } else if (class_310.method_1551().field_1724.method_7337()) {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, null, true, context -> class_310.method_1551().field_1724.field_3944.method_52787((class_2596)new class_2873(class_310.method_1551().field_1724.method_31548().field_7545 + 36, context.getItemStack()))));
        } else {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, (class_2561)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
        }
        return true;
    }

    public static void requestSelfEditor(EditorType editorType) {
        class_746 entity = class_310.method_1551().field_1724;
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.method_5628()));
        }
    }

    public static boolean requestInventoryItemEditor(EditorType editorType, class_465<?> screen) {
        class_1735 slot = ((AbstractContainerScreenMixin)screen).getHoveredSlot();
        if (slot != null && slot.method_7681()) {
            class_3966 res;
            class_3965 res2;
            int slotIndex = slot.method_34266();
            if (slot.field_7871 instanceof class_1661) {
                boolean creativeInventoryScreen = false;
                if (screen instanceof class_481) {
                    class_481 c = (class_481)screen;
                    creativeInventoryScreen = true;
                    if (c.method_47424()) {
                        slotIndex = ClientUtil.convertCreativeInventorySlot(slotIndex);
                    }
                }
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.PLAYER_INVENTORY_ITEM_EDITOR_REQUEST, new PlayerInventoryItemEditorPacket.Request(editorType, slotIndex, creativeInventoryScreen));
                } else if (class_310.method_1551().field_1724.method_7337()) {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.method_7677(), null, true, context -> slot.method_7673(context.getItemStack())));
                } else {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.method_7677(), (class_2561)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
                }
                return true;
            }
            class_239 class_2392 = class_310.method_1551().field_1765;
            if (class_2392 instanceof class_3965 && class_310.method_1551().field_1687.method_8321((res2 = (class_3965)class_2392).method_17777()) instanceof class_1263) {
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.BLOCK_INVENTORY_ITEM_EDITOR_REQUEST, new BlockInventoryItemEditorPacket.Request(editorType, slotIndex, res2.method_17777()));
                }
                return true;
            }
            class_2392 = class_310.method_1551().field_1765;
            if (class_2392 instanceof class_3966 && (res = (class_3966)class_2392).method_17782() instanceof class_1263 && ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_INVENTORY_ITEM_EDITOR_REQUEST, new EntityInventoryItemEditorPacket.Request(editorType, slotIndex, res.method_17782().method_5628()));
            }
        }
        return false;
    }
}

